/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cppcheck;

import com.google.common.base.Strings;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.extensionpoint.AggregationSupport;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.cppcheck.CppCheckCategory;
import com.pmease.quickbuild.plugin.report.cppcheck.CppCheckPublisher;
import com.pmease.quickbuild.plugin.report.cppcheck.CppCheckRest;
import com.pmease.quickbuild.plugin.report.cppcheck.aggregation.CppCheckAggregationOverviewGadget;
import com.pmease.quickbuild.plugin.report.cppcheck.aggregation.CppCheckAggregationStatsGadget;
import com.pmease.quickbuild.plugin.report.cppcheck.aggregation.CppCheckAggregator;
import com.pmease.quickbuild.plugin.report.cppcheck.gadget.CppCheckPieChartGadget;
import com.pmease.quickbuild.plugin.report.cppcheck.gadget.TopBuggyFilesGadget;
import com.pmease.quickbuild.plugin.report.engine.contribution.AbstractReportPlugin;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryAggregationOverview;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryAggregationStatsTab;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;

public class CppCheckPlugin
extends AbstractReportPlugin {
    public static final String CPPCHECK_AGGREGATION_STATS_TAB = "CppCheck Aggregated";

    protected Class<? extends Step> getPublishStepClass() {
        return CppCheckPublisher.class;
    }

    protected ReportCategory createCategory() {
        return new CppCheckCategory();
    }

    protected Class<? extends Gadget>[] getGadgetClasses() {
        return new Class[]{CppCheckPieChartGadget.class, TopBuggyFilesGadget.class, CppCheckAggregationOverviewGadget.class, CppCheckAggregationStatsGadget.class};
    }

    protected Class<?>[] getRestResourceClasses() {
        return new Class[]{CppCheckRest.class};
    }

    protected Object[] getAggregationSupport() {
        return new Object[]{new AggregationSupport(){

            public Class<? extends Aggregation> getAggregationClass() {
                return CppCheckAggregator.class;
            }

            public void cleanupAggregations(Configuration configuration) {
                ReportCategory category = CppCheckPlugin.this.getReportCategory();
                category.deleteAllReportSetsOfAggregation(configuration);
            }
        }, new CategoryAggregationOverview(){

            protected ReportCategory getCategory() {
                return CppCheckPlugin.this.getReportCategory();
            }

            protected String getToTab() {
                return Tab.title2id((String)CppCheckPlugin.CPPCHECK_AGGREGATION_STATS_TAB);
            }
        }, new CategoryAggregationStatsTab(){
            private static final long serialVersionUID = 1L;

            public String getTitle() {
                return CppCheckPlugin.CPPCHECK_AGGREGATION_STATS_TAB;
            }

            protected boolean isAggregationApplicable(Aggregation aggregation) {
                return aggregation.getClass().isAssignableFrom(CppCheckAggregator.class);
            }

            public ReportCategory getCategory() {
                return CppCheckPlugin.this.getReportCategory();
            }
        }};
    }

    public static String getColorBySeverity(String severity) {
        if (Strings.isNullOrEmpty((String)severity)) {
            return "#666666";
        }
        return Severity.valueOf((String)severity).color;
    }

    static enum Severity {
        error("#FF1A00"),
        warning("#FF7400"),
        style("#DCB843"),
        performance("#584B96"),
        portability("#007494"),
        information("#646047");

        final String color;

        private Severity(String color) {
            this.color = color;
        }
    }
}

