/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.resource;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.alert.engine.web.components.TimeSpanButtonGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.ResourceMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.mock.ResourceMock;
import com.pmease.quickbuild.plugin.measurement.core.web.MeasurementHelper;
import com.pmease.quickbuild.plugin.measurement.core.web.MetricsChartSetting;
import com.pmease.quickbuild.plugin.measurement.core.web.component.MenuItems;
import com.pmease.quickbuild.plugin.measurement.core.web.component.MetricGroupPanel;
import com.pmease.quickbuild.plugin.measurement.core.web.component.WidthDetectorPanel;
import com.pmease.quickbuild.plugin.measurement.core.web.data.DataPoint;
import com.pmease.quickbuild.plugin.measurement.core.web.data.MetricsChartData;
import com.pmease.quickbuild.plugin.measurement.core.web.data.TimeSeries;
import com.pmease.quickbuild.plugin.measurement.core.web.event.WidthDetectedEvent;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.util.TimeUtils;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public class ResourceMetricsPanel
extends Panel {
    private String primaryResource;
    private String secondResource;
    private final IModel<Map<String, MetricsChartData>> dataModel;

    public ResourceMetricsPanel(String id, IModel<MetricsChartSetting> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.dataModel = new LoadableDetachableModel<Map<String, MetricsChartData>>(){

            protected Map<String, MetricsChartData> load() {
                List measurements;
                TimeSpan timespan = ResourceMetricsPanel.this.getTimeSpan();
                Range period = ResourceMetricsPanel.this.getPeriod();
                if (Strings.isNullOrEmpty((String)ResourceMetricsPanel.this.primaryResource)) {
                    measurements = ResourceMetricsPanel.this.loadMeasurements(null, (Range<Long>)period);
                } else {
                    measurements = Lists.newArrayList((Iterable)ResourceMetricsPanel.this.loadMeasurements(ResourceMetricsPanel.this.primaryResource, (Range<Long>)period));
                    if (!Strings.isNullOrEmpty((String)ResourceMetricsPanel.this.secondResource)) {
                        measurements.addAll(ResourceMetricsPanel.this.loadMeasurements(ResourceMetricsPanel.this.secondResource, (Range<Long>)period));
                    }
                }
                HashMap map = Maps.newHashMap();
                for (MeasurementData each : measurements) {
                    List list = (List)map.get(each.getMetricName());
                    if (list == null) {
                        list = Lists.newArrayList();
                        map.put(each.getMetricName(), list);
                    }
                    list.add(each);
                }
                LinkedHashMap result = Maps.newLinkedHashMap();
                MeasurementDataManager.TableType tableType = ResourceMetricsPanel.this.getTableType();
                boolean showAll = Strings.isNullOrEmpty((String)ResourceMetricsPanel.this.primaryResource);
                MetricsChartData all = new MetricsChartData((Long)period.lowerEndpoint(), (Long)period.upperEndpoint(), tableType.getInterval());
                if (showAll) {
                    result.put("all", all);
                }
                for (Resource each : ResourceMetricsPanel.this.getResources()) {
                    MetricsChartData data;
                    if (showAll) {
                        data = all;
                    } else if (result.containsKey(each.getName())) {
                        data = (MetricsChartData)result.get(each.getName());
                    } else {
                        data = new MetricsChartData((Long)period.lowerEndpoint(), (Long)period.upperEndpoint(), tableType.getInterval());
                        result.put(each.getName(), data);
                    }
                    String usedName = MetricMeta.of(ResourceMetricGroup.USED_BY_NAME, each.getName()).getMetricName();
                    List list = map.containsKey(usedName) ? (List)map.get(usedName) : Lists.newArrayList();
                    TimeSeries used = TimeSeries.builder(TimeSeries.Key.of("SYSTEM", usedName)).beginTime((Long)period.lowerEndpoint()).endTime((Long)period.upperEndpoint()).interval(tableType.getInterval()).measurements(list).allowEmptyPoint(true).upperAlign(timespan.isUpperAlign()).build();
                    used.setDisplayName("Used");
                    String freesName = MetricMeta.of(ResourceMetricGroup.FREES_BY_NAME, each.getName()).getMetricName();
                    list = map.containsKey(freesName) ? (List)map.get(freesName) : Lists.newArrayList();
                    TimeSeries frees = TimeSeries.builder(TimeSeries.Key.of("SYSTEM", freesName)).beginTime((Long)period.lowerEndpoint()).endTime((Long)period.upperEndpoint()).interval(tableType.getInterval()).measurements(list).allowEmptyPoint(true).upperAlign(timespan.isUpperAlign()).build();
                    frees.setDisplayName("Frees");
                    TimeSeries percent = new TimeSeries(TimeSeries.Key.of("SYSTEM", MetricMeta.of(ResourceMetricGroup.PERCENTAGE_BY_NAME, each.getName()).getMetricName()), DataTypes.PERCENT, (Long)period.lowerEndpoint(), (Long)period.upperEndpoint(), tableType.getInterval());
                    for (int i = 0; i < used.size(); ++i) {
                        DataPoint u = used.getPoint(i);
                        DataPoint f = frees.getPoint(i);
                        double dU = u.getValue() == null ? 0.0 : u.getValue();
                        double dF = f.getValue() == null ? 0.0 : f.getValue();
                        DataPoint point = new DataPoint(MathUtils.divide((Number)dU, (Number)(dU + dF)), u.getTimestamp());
                        percent.addPoint(point);
                    }
                    if (!ResourceMetricsPanel.this.isAllowEmptyValue()) {
                        used.removeEmptyPoints();
                        frees.removeEmptyPoints();
                        percent.removeEmptyPoints();
                    }
                    if (showAll) {
                        percent.setDisplayName(each.getName());
                        data.addSeries(percent);
                        continue;
                    }
                    percent.setDisplayName("Used%");
                    data.addSeries(percent);
                    data.addSeries(used);
                    data.addSeries(frees);
                }
                return result;
            }
        };
    }

    private boolean isAllowEmptyValue() {
        if (Strings.isNullOrEmpty((String)this.primaryResource)) {
            return true;
        }
        return this.getChartSetting().getChartType() == MetricsChartSetting.ChartType.TABLE;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.createControls("controls")});
        this.add(new Component[]{this.createContent("content")});
    }

    private Component createContent(String id) {
        if (ResourceMock.getResources().isEmpty()) {
            Fragment frag = new Fragment(id, "noresourcefrag", (MarkupContainer)this);
            return frag;
        }
        if (this.getChartSetting().getChartWidth() <= 0) {
            return new WidthDetectorPanel(id);
        }
        Fragment frag = new Fragment(id, "frag", (MarkupContainer)this);
        frag.add(new Component[]{this.createSections("sections")});
        frag.setOutputMarkupId(true);
        return frag;
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof WidthDetectedEvent) {
            WidthDetectedEvent e = (WidthDetectedEvent)sink.getPayload();
            this.getChartSetting().setChartWidth(e.getWidth());
            this.addOrReplace(new Component[]{this.createContent("content")});
            e.getTarget().add(new Component[]{this});
        }
    }

    protected Component createSections(String id) {
        AbstractReadOnlyModel<List<String>> viewModel = new AbstractReadOnlyModel<List<String>>(){

            public List<String> getObject() {
                if (Strings.isNullOrEmpty((String)ResourceMetricsPanel.this.primaryResource)) {
                    return ImmutableList.of((Object)"all");
                }
                ArrayList list = Lists.newArrayList();
                for (Resource each : ResourceMetricsPanel.this.getResources()) {
                    list.add(each.getName());
                }
                return list;
            }
        };
        return new ListView<String>(id, (IModel)viewModel){

            protected void populateItem(ListItem<String> item) {
                String key = (String)item.getModelObject();
                item.add(new Component[]{ResourceMetricsPanel.this.createSectionPanel("panel", key).add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return ResourceMetricsPanel.this.getChartSetting().getTimespan().isUpperAlign() ? "upper-align" : "lower-align";
                    }
                })})});
            }
        };
    }

    protected Component createSectionPanel(String id, final String groupId) {
        MetricGroupPanel p = new MetricGroupPanel(id, groupId, this.getDefaultModel(), (IModel)new AbstractReadOnlyModel<MetricsChartData>(){

            public MetricsChartData getObject() {
                Map map = (Map)ResourceMetricsPanel.this.dataModel.getObject();
                MetricsChartData data = (MetricsChartData)map.get(groupId);
                return data;
            }
        }){

            @Override
            protected boolean isShowPercentValue() {
                return false;
            }

            @Override
            protected boolean isShowChartButtons() {
                return !Strings.isNullOrEmpty((String)ResourceMetricsPanel.this.primaryResource);
            }

            @Override
            protected String getSectionName() {
                if (!ResourceMetricsPanel.this.isShowSectionLabel()) {
                    return "";
                }
                if (Strings.isNullOrEmpty((String)ResourceMetricsPanel.this.primaryResource)) {
                    return "All Resources Heatmap";
                }
                return groupId;
            }
        };
        if (Strings.isNullOrEmpty((String)this.primaryResource)) {
            p.setChartType(MetricsChartSetting.ChartType.TABLE);
            p.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)"heatmap"))});
        } else {
            p.setChartType(this.getChartSetting().getChartType());
        }
        return p;
    }

    protected boolean isShowSectionLabel() {
        return true;
    }

    private MetricsChartSetting getChartSetting() {
        return (MetricsChartSetting)this.getDefaultModelObject();
    }

    protected Component createControls(String id) {
        WebMarkupContainer controls = new WebMarkupContainer(id);
        WebMarkupContainer primary = new WebMarkupContainer("primaryRes");
        controls.add(new Component[]{primary});
        primary.add(new Component[]{new Label("primaryName", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ResourceMetricsPanel.this.primaryResource == null ? "All Resources" : ResourceMetricsPanel.this.primaryResource;
            }
        })});
        primary.add(new Behavior[]{new MenuBehavior(){

            protected List<MenuItem> getMenuItems() {
                List<Resource> resources = ResourceMock.getResources();
                ArrayList items = Lists.newArrayList();
                items.add(new ResourceMenuItem(null, true));
                items.add(MenuItems.separator());
                for (Resource each : resources) {
                    String name = each.getName();
                    items.add(new ResourceMenuItem(name, true));
                }
                return items;
            }
        }});
        WebMarkupContainer second = new WebMarkupContainer("secondRes");
        controls.add(new Component[]{second});
        second.add(new Component[]{new Label("secondName", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ResourceMetricsPanel.this.secondResource == null ? "select a metric" : ResourceMetricsPanel.this.secondResource;
            }
        })});
        second.setVisibilityAllowed(!Strings.isNullOrEmpty((String)this.primaryResource));
        second.add(new Behavior[]{new MenuBehavior(){

            protected List<MenuItem> getMenuItems() {
                ArrayList items = Lists.newArrayList();
                List<Resource> resources = ResourceMock.getResources();
                for (Resource each : resources) {
                    String name = each.getName();
                    items.add(new ResourceMenuItem(name, false));
                }
                return items;
            }
        }});
        controls.add(new Component[]{new AjaxLink<Void>("removeSecond"){

            public void onClick(AjaxRequestTarget target) {
                ResourceMetricsPanel.this.secondResource = null;
                ResourceMetricsPanel.this.onChartSettingChanged(target);
            }
        }.setVisibilityAllowed(!Strings.isNullOrEmpty((String)this.secondResource))});
        controls.add(new Component[]{new TimeSpanButtonGroup("periods", this.getChartSetting().getTimespan()){

            protected void onTimeSpanChanged(AjaxRequestTarget target, TimeSpan timespan) {
                ResourceMetricsPanel.this.getChartSetting().setTimespan(timespan);
                ResourceMetricsPanel.this.onChartSettingChanged(target);
            }
        }});
        controls.add(new Component[]{new AjaxLink<Void>("detailed"){

            public void onClick(AjaxRequestTarget target) {
                ResourceMetricsPanel.this.getChartSetting().setShowDetails(!ResourceMetricsPanel.this.getChartSetting().isShowDetails());
                ResourceMetricsPanel.this.onChartSettingChanged(target);
            }

            protected void onConfigure() {
                this.setVisibilityAllowed(ResourceMetricsPanel.this.getTimeSpan().ordinal() >= TimeSpan.LAST_DAY.ordinal());
            }
        }.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ResourceMetricsPanel.this.getChartSetting().isShowDetails() ? "checked" : "";
            }
        })})});
        return controls;
    }

    private TimeSpan getTimeSpan() {
        return this.getChartSetting().getTimespan();
    }

    private List<Resource> getResources() {
        if (Strings.isNullOrEmpty((String)this.primaryResource)) {
            return ResourceMock.getResources();
        }
        ArrayList resources = Lists.newArrayList();
        resources.add(ResourceMock.getResource(this.primaryResource));
        if (!Strings.isNullOrEmpty((String)this.secondResource)) {
            resources.add(ResourceMock.getResource(this.secondResource));
        }
        return resources;
    }

    private List<MeasurementData> loadMeasurements(String name, Range<Long> period) {
        SearchCriteria criteria;
        MeasurementDataManager dataManager = MeasurementDataManager.instance;
        if (Strings.isNullOrEmpty((String)name)) {
            criteria = SearchCriteria.of((Criterion[])new Criterion[]{Restrictions.eq((String)"source", (Object)Grid.instance.getServerNode().getAddress()), Restrictions.like((String)"metricName", (String)"resources.", (MatchMode)MatchMode.START)});
        } else {
            ArrayList crits = Lists.newArrayList();
            crits.add(Restrictions.eq((String)"source", (Object)Grid.instance.getServerNode().getAddress()));
            crits.add(Restrictions.eq((String)"metricName", (Object)MetricMeta.of(ResourceMetricGroup.USED_BY_NAME, name).getMetricName()));
            crits.add(Restrictions.eq((String)"metricName", (Object)MetricMeta.of(ResourceMetricGroup.FREES_BY_NAME, name).getMetricName()));
            criteria = SearchCriteria.builder().or((Criterion[])Iterables.toArray((Iterable)crits, Criterion.class)).build();
        }
        return dataManager.find(this.getTableType(), period, criteria);
    }

    private MeasurementDataManager.TableType getTableType() {
        MetricsChartSetting setting = this.getChartSetting();
        return MeasurementHelper.timespanToTableType(setting.getTimespan(), setting.isShowDetails());
    }

    private Range<Long> getPeriod() {
        Range period = this.getTimeSpan().range();
        period = Range.closedOpen((Comparable)Long.valueOf(TimeUtils.roundDownTime((long)((Long)period.lowerEndpoint()), (long)this.getTableType().getInterval())), (Comparable)period.upperEndpoint());
        return period;
    }

    private void onChartSettingChanged(AjaxRequestTarget target) {
        this.addOrReplace(new Component[]{this.createControls("controls")});
        target.add(new Component[]{this});
    }

    public void onDetach() {
        if (this.dataModel != null) {
            this.dataModel.detach();
        }
        super.onDetach();
    }

    private class ResourceMenuItem
    extends MenuItem {
        final String name;
        final boolean forPrimary;

        ResourceMenuItem(String name, boolean forPrimary) {
            this.name = name;
            this.forPrimary = forPrimary;
        }

        public Component render(String componentId) {
            Fragment frag = new Fragment(componentId, "menufrag", (MarkupContainer)ResourceMetricsPanel.this);
            AjaxLink<Void> link = new AjaxLink<Void>("link"){

                public void onClick(AjaxRequestTarget target) {
                    if (ResourceMenuItem.this.forPrimary) {
                        ResourceMetricsPanel.this.primaryResource = ResourceMenuItem.this.name;
                    } else {
                        ResourceMetricsPanel.this.secondResource = ResourceMenuItem.this.name;
                    }
                    ResourceMetricsPanel.this.onChartSettingChanged(target);
                }
            };
            frag.add(new Component[]{link});
            WebMarkupContainer icon = new WebMarkupContainer("icon");
            link.add(new Component[]{icon});
            icon.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                public String getObject() {
                    return Objects.equal((Object)ResourceMenuItem.this.name, (Object)(ResourceMenuItem.this.forPrimary ? ResourceMetricsPanel.this.primaryResource : ResourceMetricsPanel.this.secondResource)) ? "icon-ok" : "icon-null";
                }
            })});
            link.add(new Component[]{new Label("label", (IModel)new AbstractReadOnlyModel<String>(){

                public String getObject() {
                    if (ResourceMenuItem.this.forPrimary) {
                        return ResourceMenuItem.this.name == null ? "All Resources" : ResourceMenuItem.this.name;
                    }
                    return ResourceMenuItem.this.name;
                }
            })});
            return frag;
        }
    }
}

