/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.resource;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.measurement.core.web.MetricsChartSetting;
import com.pmease.quickbuild.plugin.measurement.core.web.ParamSpec;
import com.pmease.quickbuild.plugin.measurement.core.web.resource.ResourceMetricsPanel;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.component.tabbedpanel.TabbedPanel;
import com.pmease.quickbuild.web.page.grid.GridPage;
import com.pmease.quickbuild.web.page.grid.resource.GridResourcesPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class GridResourcesTabPanel
extends Panel
implements IAjaxIndicatorAware {
    public GridResourcesTabPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        ArrayList tabs = Lists.newArrayList();
        PageParameters params = this.getPage().getPageParameters();
        String tabId = ParamSpec.decode(params.get(1).toString());
        tabs.add(new Tab("overview", "Overview"){

            public Panel getPanel(String id, Map<String, String> params) {
                return new GridResourcesPanel(id);
            }
        });
        tabs.add(new Tab("measurements", "Measurements"){

            public Panel getPanel(String id, Map<String, String> params) {
                return new ResourceMetricsPanel(id, (IModel<MetricsChartSetting>)Model.of((Serializable)new MetricsChartSetting()));
            }
        });
        String[] tabIds = !Strings.isNullOrEmpty((String)tabId) ? new String[]{tabId} : new String[]{};
        this.add(new Component[]{new TabbedPanel("tabs", tabs, tabIds){

            protected WebMarkupContainer newTabLink(String linkId, String[] tabIds) {
                return new BookmarkablePageLink(linkId, GridPage.class, ParamSpec.of(new String[]{"resources", tabIds[0]}));
            }
        }});
    }

    public String getAjaxIndicatorMarkupId() {
        return "global-ajax-indicator";
    }
}

