/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;
import com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher.MatcherOperator;
import org.apache.commons.net.util.SubnetUtils;

public class IpMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private MatcherOperator op = MatcherOperator.EQUALS;
    private String pattern;

    public IpMatcher() {
    }

    public IpMatcher(String pattern, MatcherOperator op) {
        this.pattern = pattern;
        this.op = op;
    }

    public MatcherOperator getOp() {
        return this.op;
    }

    public void setOp(MatcherOperator op) {
        this.op = op;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getName() {
        return "Ip Matcher";
    }

    public String toHtml() {
        return this.toString();
    }

    public boolean matches(GridNode node) {
        if (this.op == MatcherOperator.EQUALS) {
            return Objects.equal((Object)this.pattern, (Object)node.getIp());
        }
        if (this.op == MatcherOperator.CONTAINS) {
            return node.getIp().contains(this.pattern);
        }
        if (this.op == MatcherOperator.IN_SUBNET) {
            SubnetUtils utils = new SubnetUtils(this.pattern);
            return utils.getInfo().isInRange(node.getIp());
        }
        return false;
    }

    public String toString() {
        return "Ip " + this.op.name().toLowerCase() + " " + this.pattern;
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.pattern);
    }
}

