/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;
import java.util.ArrayList;
import java.util.List;

public class CompositeNodeMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private Connective connective;
    private List<NodeMatcher> matchers = Lists.newArrayList();
    private boolean matching = true;

    public String getName() {
        return "Composite Node Matcher";
    }

    public String toHtml() {
        ArrayList list = Lists.newArrayList();
        for (NodeMatcher each : this.matchers) {
            if (!each.isValid()) continue;
            list.add(each.toHtml());
        }
        return Joiner.on((String)(" " + this.connective.name() + " ")).join((Iterable)list);
    }

    public boolean matches(GridNode node) {
        boolean b = this.matcherMatching(node);
        return this.matching ? b : !b;
    }

    private boolean matcherMatching(GridNode node) {
        if (this.matchers.isEmpty()) {
            return true;
        }
        if (this.connective == Connective.AND) {
            for (NodeMatcher each : this.matchers) {
                if (each.matches(node)) continue;
                return false;
            }
            return true;
        }
        for (NodeMatcher each : this.matchers) {
            if (!each.matches(node)) continue;
            return true;
        }
        return false;
    }

    public void addMatcher(NodeMatcher matcher) {
        this.matchers.add(matcher);
    }

    public void removeMatcher(NodeMatcher matcher) {
        this.matchers.remove(matcher);
    }

    public Connective getConnective() {
        return this.connective;
    }

    public void setConnective(Connective connective) {
        this.connective = connective;
    }

    public List<NodeMatcher> getMatchers() {
        return this.matchers;
    }

    public void setMatchers(List<NodeMatcher> matchers) {
        this.matchers = matchers;
    }

    public boolean isMatching() {
        return this.matching;
    }

    public void setMatching(boolean matching) {
        this.matching = matching;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connective, this.matchers, this.matching});
    }

    public String toString() {
        ArrayList list = Lists.newArrayList();
        for (NodeMatcher each : this.matchers) {
            if (!each.isValid()) continue;
            list.add(each.toString());
        }
        String str = Joiner.on((String)(" " + this.connective.name() + " ")).skipNulls().join((Iterable)list);
        if (!this.matching) {
            str = "Not matching: " + str;
        }
        return str;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompositeNodeMatcher)) {
            return false;
        }
        CompositeNodeMatcher rhs = (CompositeNodeMatcher)other;
        return Objects.equal((Object)((Object)this.connective), (Object)((Object)rhs.connective)) && Objects.equal(this.matchers, rhs.matchers) && Objects.equal((Object)this.matching, (Object)rhs.matching);
    }

    public boolean isValid() {
        for (NodeMatcher each : this.matchers) {
            if (each.isValid()) continue;
            return false;
        }
        return true;
    }

    public static enum Connective {
        AND,
        OR;

    }
}

