/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;

public class CloudProfileNameEqualsMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private String profileName;

    public CloudProfileNameEqualsMatcher() {
    }

    public CloudProfileNameEqualsMatcher(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getName() {
        return "Cloud Profile Name Equal";
    }

    public String toHtml() {
        return this.toString();
    }

    public boolean matches(GridNode node) {
        return node.getCloudProfile() != null && node.getCloudProfile().getName().equalsIgnoreCase(this.profileName);
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.profileName);
    }

    public String toString() {
        return "cloud profile = " + this.profileName;
    }

    public boolean equasl(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CloudProfileNameEqualsMatcher)) {
            return false;
        }
        CloudProfileNameEqualsMatcher rhs = (CloudProfileNameEqualsMatcher)other;
        return Objects.equal((Object)this.profileName, (Object)rhs.profileName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.profileName});
    }
}

