/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;

public class CloudProfileNameContainsMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    final String pattern;

    public CloudProfileNameContainsMatcher(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean matches(GridNode node) {
        if (Strings.isNullOrEmpty((String)this.getPattern())) {
            return true;
        }
        return node.getCloudProfile() != null && node.getCloudProfile().getName().contains(this.pattern);
    }

    public String getName() {
        return "PROFILE_NAME_CONTAINS";
    }

    public String toHtml() {
        return this.toString();
    }

    public String toString() {
        return "cloud profile name contains [" + this.pattern + "]";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pattern});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CloudProfileNameContainsMatcher)) {
            return false;
        }
        CloudProfileNameContainsMatcher rhs = (CloudProfileNameContainsMatcher)other;
        return Objects.equal((Object)this.pattern, (Object)rhs.pattern);
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.pattern);
    }
}

