/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node.criterion;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.AttributeValueCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.CriterionType;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriterionChanged;
import com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher.MatcherOperator;
import com.pmease.quickbuild.plugin.report.engine.web.feedback.FeedbackPanel;
import com.pmease.quickbuild.util.OsType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class NodeCriterionEditor
extends Panel {
    private static final long serialVersionUID = 1L;
    private CriterionType criterionType;
    private final int pos;

    public NodeCriterionEditor(String id, int pos, IModel<NodeCriterion> criterion) {
        super(id, criterion);
        this.pos = pos;
        this.setOutputMarkupId(true);
    }

    private void initCriterionType() {
        NodeCriterion criterion = this.getCriterion();
        this.criterionType = criterion.getType();
    }

    private List<CriterionType> getCriterionTypes() {
        return Lists.newArrayList((Object[])CriterionType.values());
    }

    protected void onInitialize() {
        super.onInitialize();
        this.initCriterionType();
        DropDownChoice choice = new DropDownChoice("critType", (IModel)new PropertyModel((Object)this, "criterionType"), this.getCriterionTypes(), (IChoiceRenderer)new IChoiceRenderer<CriterionType>(){

            public Object getDisplayValue(CriterionType obj) {
                return obj.toString();
            }

            public String getIdValue(CriterionType obj, int arg1) {
                return obj.name();
            }
        });
        this.add(new Component[]{choice});
        choice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                NodeCriterion criterion = NodeCriterionEditor.this.criterionType.newCriterion();
                NodeCriterionEditor.this.setDefaultModelObject(criterion);
                NodeCriterionEditor.this.addOrReplace(new Component[]{NodeCriterionEditor.this.createExpressionEdit("expedit")});
                target.add(new Component[]{NodeCriterionEditor.this});
                NodeCriterionEditor.this.send((IEventSink)NodeCriterionEditor.this.getPage(), Broadcast.DEPTH, new NodeCriterionChanged(NodeCriterionEditor.this.pos, criterion, target));
            }
        }});
        this.add(new Component[]{this.createExpressionEdit("expedit")});
    }

    private Component createExpressionEdit(String id) {
        if (this.criterionType == null) {
            return new WebMarkupContainer(id).setOutputMarkupId(true);
        }
        switch (this.criterionType) {
            case ATTRIBUTE_VALUE: {
                return this.createAttributeValueEdit(id);
            }
        }
        return this.createSimpleEdit(id);
    }

    private Component createAttributeValueEdit(String id) {
        Fragment frag = new Fragment(id, "aedit", (MarkupContainer)this);
        frag.add(new Component[]{this.createOpInput("op")});
        frag.add(new Component[]{this.createValueInput("value")});
        AbstractReadOnlyModel<List<String>> nameModel = new AbstractReadOnlyModel<List<String>>(){

            public List<String> getObject() {
                return NodeCriterionEditor.this.getAllAttributeNames();
            }
        };
        AttributeValueCriterion criterion = (AttributeValueCriterion)this.getDefaultModelObject();
        criterion.setAttributeName(this.getAllAttributeNames().get(0));
        DropDownChoice attributeDropDown = new DropDownChoice("attribute-name", (IModel)new PropertyModel((Object)this.getDefaultModel(), "attributeName"), (IModel)nameModel);
        frag.add(new Component[]{attributeDropDown.setRequired(true)});
        frag.add(new Component[]{new FeedbackPanel("feedback", (Component)attributeDropDown)});
        return frag;
    }

    private Component createSimpleEdit(String id) {
        Fragment frag = new Fragment(id, "simpleedit", (MarkupContainer)this);
        frag.add(new Component[]{this.createOpInput("op")});
        frag.add(new Component[]{this.createValueInput("value")});
        return frag;
    }

    private Component createOpInput(String id) {
        AbstractReadOnlyModel<List<MatcherOperator>> opModel = new AbstractReadOnlyModel<List<MatcherOperator>>(){

            public List<MatcherOperator> getObject() {
                NodeCriterion criterion = NodeCriterionEditor.this.getCriterion();
                return criterion.getSupportedOperations();
            }
        };
        return new DropDownChoice("op", (IModel)new PropertyModel((Object)this.getDefaultModel(), "op"), (IModel)opModel, (IChoiceRenderer)new IChoiceRenderer<MatcherOperator>(){

            public Object getDisplayValue(MatcherOperator obj) {
                return obj.name().toLowerCase();
            }

            public String getIdValue(MatcherOperator obj, int i) {
                return obj.name();
            }
        });
    }

    private Component createValueInput(String id) {
        if (this.criterionType == null) {
            return new WebMarkupContainer(id);
        }
        switch (this.criterionType) {
            case OSTYPE: 
            case RESOURCE: 
            case ATTRIBUTE_NAME: 
            case CLOUD_PROFILE: {
                Fragment selectFrag = new Fragment(id, "selectType", (MarkupContainer)this);
                selectFrag.add(new Component[]{this.createSelect("select")});
                return selectFrag;
            }
        }
        Fragment inputFrag = new Fragment(id, "inputType", (MarkupContainer)this);
        inputFrag.add(new Component[]{new TextField("input", (IModel)new PropertyModel((Object)this.getDefaultModel(), "value"))});
        return inputFrag;
    }

    private static List<String> osTypes() {
        ArrayList list = Lists.newArrayList();
        for (OsType each : OsType.values()) {
            list.add(each.name());
        }
        return list;
    }

    private List<String> getAllResources() {
        List resources = CacheManager.instance.getResources();
        ArrayList list = Lists.newArrayList();
        for (Resource each : resources) {
            list.add(each.getName());
        }
        Collections.sort(list);
        return list;
    }

    private List<String> getAllAttributeNames() {
        return ((Grid)Quickbuild.getInstance(Grid.class)).getAttributeNames();
    }

    private List<String> getAllCloudProfiles() {
        List profiles = CacheManager.instance.getCloudProfiles();
        ArrayList list = Lists.newArrayList();
        for (CloudProfile each : profiles) {
            list.add(each.getName());
        }
        return list;
    }

    private Component createSelect(String id) {
        switch (this.criterionType) {
            case OSTYPE: {
                return new DropDownChoice(id, (IModel)new PropertyModel((Object)this.getDefaultModel(), "value"), NodeCriterionEditor.osTypes());
            }
            case ATTRIBUTE_NAME: {
                return new DropDownChoice(id, (IModel)new PropertyModel((Object)this.getDefaultModel(), "value"), this.getAllAttributeNames());
            }
            case CLOUD_PROFILE: {
                return new DropDownChoice(id, (IModel)new PropertyModel((Object)this.getDefaultModel(), "value"), this.getAllCloudProfiles());
            }
            case RESOURCE: {
                return new DropDownChoice(id, (IModel)new PropertyModel((Object)this.getDefaultModel(), "value"), this.getAllResources());
            }
        }
        throw new UnsupportedOperationException("type " + (Object)((Object)this.criterionType));
    }

    private NodeCriterion getCriterion() {
        return (NodeCriterion)this.getDefaultModelObject();
    }
}

