/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node.criterion;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher.CompositeNodeMatcher;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class NodeCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<NodeCriterion> criterions = Lists.newArrayList();
    private CompositeNodeMatcher.Connective connective = CompositeNodeMatcher.Connective.AND;
    private String matching = "Matching";

    public List<NodeCriterion> getCriterions() {
        return this.criterions;
    }

    public void setCriterions(List<NodeCriterion> criterions) {
        this.criterions = criterions;
    }

    public CompositeNodeMatcher.Connective getConnective() {
        return this.connective;
    }

    public void setConnective(CompositeNodeMatcher.Connective connective) {
        this.connective = connective;
    }

    public boolean isEmpty() {
        return this.criterions.isEmpty();
    }

    public void add(NodeCriterion criterion) {
        this.criterions.add(criterion);
    }

    public void remove(NodeCriterion criterion) {
        this.criterions.remove(criterion);
    }

    public void remove(int index) {
        this.criterions.remove(index);
    }

    public String getMatching() {
        return this.matching;
    }

    public void setMatching(String matching) {
        this.matching = matching;
    }

    public void removeInvalid() {
        Iterator<NodeCriterion> it = this.criterions.iterator();
        while (it.hasNext()) {
            NodeCriterion c = it.next();
            if (c.isValid()) continue;
            it.remove();
        }
    }

    public CompositeNodeMatcher toNodeMatcher() {
        CompositeNodeMatcher matcher = new CompositeNodeMatcher();
        matcher.setConnective(this.connective);
        for (NodeCriterion each : this.criterions) {
            NodeMatcher m = each.toNodeMatcher();
            if (m == null || !m.isValid()) continue;
            matcher.addMatcher(m);
        }
        if ("Not Matching".equalsIgnoreCase(this.matching)) {
            matcher.setMatching(false);
        }
        return matcher;
    }
}

