/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node.criterion;

import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.AttributeNameCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.AttributeValueCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.CloudProfileCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.IpAddressCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeNameCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.OsTypeCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.ResourceCriterion;

public enum CriterionType {
    NODE_NAME("Node Name"){

        @Override
        public NodeCriterion newCriterion() {
            return new NodeNameCriterion();
        }
    }
    ,
    OSTYPE("OS Type"){

        @Override
        public NodeCriterion newCriterion() {
            return new OsTypeCriterion();
        }
    }
    ,
    RESOURCE("Resource"){

        @Override
        public NodeCriterion newCriterion() {
            return new ResourceCriterion();
        }
    }
    ,
    ATTRIBUTE_NAME("Attribute Name"){

        @Override
        public NodeCriterion newCriterion() {
            return new AttributeNameCriterion();
        }
    }
    ,
    ATTRIBUTE_VALUE("Attribute Value"){

        @Override
        public NodeCriterion newCriterion() {
            return new AttributeValueCriterion();
        }
    }
    ,
    IP("IP Address"){

        @Override
        public NodeCriterion newCriterion() {
            return new IpAddressCriterion();
        }
    }
    ,
    CLOUD_PROFILE("Cloud Profile"){

        @Override
        public NodeCriterion newCriterion() {
            return new CloudProfileCriterion();
        }
    };

    final String displayName;

    public abstract NodeCriterion newCriterion();

    private CriterionType(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        return this.displayName;
    }
}

