/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node;

import com.pmease.quickbuild.plugin.measurement.core.web.MetricsChartSetting;
import com.pmease.quickbuild.plugin.measurement.core.web.component.WidthDetectorPanel;
import com.pmease.quickbuild.plugin.measurement.core.web.event.WidthDetectedEvent;
import com.pmease.quickbuild.plugin.measurement.core.web.node.MeasurementPanel;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class NodeMeasurementPanel
extends Panel {
    final String source;
    private MetricsChartSetting chartSetting = new MetricsChartSetting();

    public NodeMeasurementPanel(String id, String source) {
        this(id, source, new MetricsChartSetting());
    }

    public NodeMeasurementPanel(String id, String source, MetricsChartSetting setting) {
        super(id);
        this.source = source;
        this.chartSetting = setting;
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.createContent("content")});
    }

    private Component createContent(String id) {
        if (this.getChartSetting().getChartWidth() <= 0) {
            return new WidthDetectorPanel(id);
        }
        return new MeasurementPanel(id, this.source, (IModel<MetricsChartSetting>)Model.of((Serializable)this.getChartSetting()));
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof WidthDetectedEvent) {
            WidthDetectedEvent event = (WidthDetectedEvent)sink.getPayload();
            this.getChartSetting().setChartWidth(event.getWidth());
            Component c = this.createContent("content");
            this.addOrReplace(new Component[]{c});
            event.getTarget().add(new Component[]{this});
        }
    }

    public MetricsChartSetting getChartSetting() {
        return this.chartSetting;
    }

    public void setChartSetting(MetricsChartSetting chartSetting) {
        this.chartSetting = chartSetting;
    }

    public String getSource() {
        return this.source;
    }
}

