/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.measurement.core.MeasurementPlugin;
import com.pmease.quickbuild.plugin.measurement.core.alert.ListEditor;
import com.pmease.quickbuild.plugin.measurement.core.web.node.UserFilters;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.CriterionType;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.EmptyCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.IpAddressCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriteria;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriteriaChanged;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriterionChanged;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriterionEditor;
import com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher.CompositeNodeMatcher;
import com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher.MatcherOperator;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.ContainerFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.WildcardListModel;

public class NodeFilterFormPanel
extends Panel {
    private Form<?> form;
    private NodeCriteria criteria;
    private String filterName;
    private final Panel parentPanel;

    public NodeFilterFormPanel(String id, Panel parentPanel, NodeCriteria criteria, String filterName) {
        super(id);
        this.parentPanel = parentPanel;
        this.criteria = criteria;
        this.filterName = filterName;
    }

    protected void onInitialize() {
        super.onInitialize();
        if (this.criteria.isEmpty()) {
            this.criteria.add(new EmptyCriterion());
        }
        this.form = new Form("form");
        this.form.setOutputMarkupId(true);
        this.add(new Component[]{this.form});
        this.form.add(new Component[]{new FeedbackPanel("feedback", (IFeedbackMessageFilter)new ContainerFeedbackMessageFilter(this.form))});
        this.form.add(new Component[]{new DropDownChoice("matching", (IModel)new PropertyModel((Object)this.criteria, "matching"), (List)Lists.newArrayList((Object[])new String[]{"Matching", "Not Matching"}))});
        DropDownChoice connectiveChoice = new DropDownChoice("connective", (IModel)new PropertyModel((Object)this.criteria, "connective"), (List)Lists.newArrayList((Object[])CompositeNodeMatcher.Connective.values()), (IChoiceRenderer)new IChoiceRenderer<CompositeNodeMatcher.Connective>(){

            public Object getDisplayValue(CompositeNodeMatcher.Connective obj) {
                return obj == CompositeNodeMatcher.Connective.AND ? "ALL" : "ANY";
            }

            public String getIdValue(CompositeNodeMatcher.Connective obj, int arg1) {
                return obj.name();
            }
        });
        connectiveChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                NodeFilterFormPanel.this.onListChanged(target);
            }
        }});
        this.form.add(new Component[]{connectiveChoice});
        this.form.add(new Component[]{this.createEditor()});
        this.form.add(new Component[]{new AjaxButton("addlink", this.form){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                NodeFilterFormPanel.this.criteria.add(new EmptyCriterion());
                NodeFilterFormPanel.this.onListChanged(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{form});
            }
        }});
        Button btn = new AjaxButton("submit", this.form){

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{form});
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                if (NodeFilterFormPanel.this.validateFilters()) {
                    this.send((IEventSink)NodeFilterFormPanel.this.parentPanel, Broadcast.BREADTH, new NodeCriteriaChanged(target, NodeFilterFormPanel.this.criteria, NodeFilterFormPanel.this.filterName));
                    Dialog.closeTopmost((AjaxRequestTarget)target);
                } else {
                    target.add(new Component[]{form});
                }
            }
        }.setDefaultFormProcessing(true);
        this.form.add(new Component[]{btn});
        this.form.setDefaultButton((IFormSubmittingComponent)btn);
        WebMarkupContainer filterSpan = new WebMarkupContainer("filterspan"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(WebSession.get().getUserId() != null);
            }
        };
        this.form.add(new Component[]{filterSpan});
        final TextField nameField = new TextField("name", (IModel)new PropertyModel((Object)this, "filterName"));
        filterSpan.add(new Component[]{nameField});
        FeedbackPanel nameFeedback = new FeedbackPanel("namemessage", (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter((Component)nameField));
        filterSpan.add(new Component[]{nameFeedback});
        filterSpan.add(new Component[]{new AjaxButton("save", this.form){

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{form});
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                if (Strings.isNullOrEmpty((String)NodeFilterFormPanel.this.filterName)) {
                    nameField.error((Serializable)((Object)"Filter name is required"));
                    target.add(new Component[]{form});
                    return;
                }
                if (!NodeFilterFormPanel.this.validateFilters()) {
                    target.add(new Component[]{form});
                    return;
                }
                Optional<UserFilters> oFilters = UserFilters.get();
                UserFilters filters = oFilters.isPresent() ? (UserFilters)oFilters.get() : new UserFilters();
                filters.getFilters().put(NodeFilterFormPanel.this.filterName, NodeFilterFormPanel.this.criteria);
                PluginSettingHelper.saveUserSetting(MeasurementPlugin.class, (User)NodeFilterFormPanel.this.getCurrentUser(), (Object)filters);
                this.send((IEventSink)NodeFilterFormPanel.this.parentPanel, Broadcast.BREADTH, new NodeCriteriaChanged(target, NodeFilterFormPanel.this.criteria, NodeFilterFormPanel.this.filterName));
                Dialog.closeTopmost((AjaxRequestTarget)target);
            }
        }});
    }

    private User getCurrentUser() {
        return Context.getUser();
    }

    private boolean validateFilters() {
        for (NodeCriterion each : this.criteria.getCriterions()) {
            IpAddressCriterion c;
            if (each.getType() != CriterionType.IP || (c = (IpAddressCriterion)each).getOp() != MatcherOperator.IN_SUBNET) continue;
            try {
                SubnetUtils utils = new SubnetUtils(c.getValue());
                utils.getInfo();
            }
            catch (Exception e) {
                this.form.error((Serializable)((Object)"Cann't parse the subnet, please pecify the subnet in CIDR format like 192.168.0.0/16"));
                return false;
            }
        }
        return true;
    }

    private void onListChanged(AjaxRequestTarget target) {
        this.form.addOrReplace(new Component[]{this.createEditor()});
        target.add(new Component[]{this.form});
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof NodeCriterionChanged) {
            NodeCriterionChanged payload = (NodeCriterionChanged)event.getPayload();
            this.criteria.getCriterions().set(payload.getPos(), payload.getCriterion());
        }
    }

    private Component createEditor() {
        ListEditor<NodeCriterion> editor = new ListEditor<NodeCriterion>("filters", (IModel)new WildcardListModel(this.criteria.getCriterions())){

            public void updateModel() {
                this.setDefaultModelObject(NodeFilterFormPanel.this.criteria.getCriterions());
            }
        };
        for (int i = 0; i < this.criteria.getCriterions().size(); ++i) {
            String markupId = editor.newChildId();
            WebMarkupContainer container = new WebMarkupContainer(markupId);
            editor.add(new Component[]{container});
            final NodeCriterion filter = this.criteria.getCriterions().get(i);
            container.add(new Component[]{new NodeCriterionEditor("filter", i, (IModel<NodeCriterion>)Model.of((Serializable)filter))});
            container.add(new Component[]{new AjaxButton("removeLink", this.form){

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    NodeFilterFormPanel.this.criteria.remove(filter);
                    if (NodeFilterFormPanel.this.criteria.isEmpty()) {
                        NodeFilterFormPanel.this.criteria.add(new EmptyCriterion());
                    }
                    NodeFilterFormPanel.this.onListChanged(target);
                }
            }});
            container.add(new Component[]{new Label("connective", this.criteria.getConnective().name())});
        }
        return editor;
    }
}

