/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.web.components.ListDataProvider;
import com.pmease.quickbuild.plugin.measurement.core.cache.LatestReportCache;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.NodeMeasurementReport;
import com.pmease.quickbuild.plugin.measurement.core.mock.GridMock;
import com.pmease.quickbuild.plugin.measurement.core.trait.NodeTraits;
import com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher.CompositeNodeMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class NodeDataProvider
extends ListDataProvider<String> {
    private static final long serialVersionUID = 1L;
    private CompositeNodeMatcher matcher;

    public NodeDataProvider(CompositeNodeMatcher matcher) {
        super(new ArrayList(0));
        this.matcher = matcher;
    }

    protected List<String> getList() {
        ArrayList nodes = Lists.newArrayList();
        for (GridNode each : GridMock.getNodes()) {
            boolean satisfied = this.matcher.matches(each);
            if (!satisfied) continue;
            nodes.add(each.getAddress());
        }
        return nodes;
    }

    public Iterator<String> iterator(int first, int count) {
        SortParam sort = this.getSort();
        if (sort == null) {
            return super.iterator(first, count);
        }
        final NodeSort sortType = NodeSort.valueOf(sort.getProperty().toUpperCase());
        final boolean asc = sort.isAscending();
        List<String> nodes = this.getList();
        Collections.sort(nodes, new Comparator<String>(){

            @Override
            public int compare(String address1, String address2) {
                int a = asc ? 1 : -1;
                Optional<GridNode> o1 = GridMock.getNode(address1);
                Optional<GridNode> o2 = GridMock.getNode(address2);
                if (!o1.isPresent()) {
                    return a * -1;
                }
                if (!o2.isPresent()) {
                    return a * 1;
                }
                switch (sortType) {
                    case NAME: {
                        return a * address1.compareTo(address2);
                    }
                    case OS: {
                        NodeTraits t1 = NodeTraits.getFromNodeData(o1);
                        NodeTraits t2 = NodeTraits.getFromNodeData(o2);
                        return a * t1.getOsType().compareTo((Enum)t2.getOsType());
                    }
                    case BENCHMARK: {
                        return a * new Long(((GridNode)o1.get()).getBenchmark()).compareTo(((GridNode)o2.get()).getBenchmark());
                    }
                    case CLOUDPROFILE: {
                        if (((GridNode)o1.get()).getCloudProfile() == null) {
                            return a * -1;
                        }
                        if (((GridNode)o2.get()).getCloudProfile() == null) {
                            return a * 1;
                        }
                        return a * ((GridNode)o1.get()).getCloudProfile().getName().compareTo(((GridNode)o2.get()).getCloudProfile().getName());
                    }
                    case STEPS: {
                        NodeMeasurementReport snapshot1 = (NodeMeasurementReport)LatestReportCache.INSTANCE.getUnchecked((Object)((GridNode)o1.get()).getAddress());
                        long s1 = snapshot1.getStepRunnings();
                        NodeMeasurementReport snapshot2 = (NodeMeasurementReport)LatestReportCache.INSTANCE.getUnchecked((Object)((GridNode)o2.get()).getAddress());
                        long s2 = snapshot2.getStepRunnings();
                        return a * new Long(s1).compareTo(s2);
                    }
                    case CPU: {
                        NodeMeasurementReport snapshot1 = (NodeMeasurementReport)LatestReportCache.INSTANCE.getUnchecked((Object)((GridNode)o1.get()).getAddress());
                        double s1 = snapshot1.getCpuUsage();
                        NodeMeasurementReport snapshot2 = (NodeMeasurementReport)LatestReportCache.INSTANCE.getUnchecked((Object)((GridNode)o2.get()).getAddress());
                        double s2 = snapshot2.getCpuUsage();
                        return a * new Double(s1).compareTo(s2);
                    }
                    case MEMORY: {
                        NodeMeasurementReport snapshot1 = (NodeMeasurementReport)LatestReportCache.INSTANCE.getUnchecked((Object)((GridNode)o1.get()).getAddress());
                        double s1 = snapshot1.getJvmMemoryUsage();
                        NodeMeasurementReport snapshot2 = (NodeMeasurementReport)LatestReportCache.INSTANCE.getUnchecked((Object)((GridNode)o2.get()).getAddress());
                        double s2 = snapshot2.getJvmMemoryUsage();
                        return a * new Double(s1).compareTo(s2);
                    }
                }
                return a * ((GridNode)o1.get()).compareTo((GridNode)o2.get());
            }
        });
        return nodes.listIterator(first);
    }

    public CompositeNodeMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(CompositeNodeMatcher matcher) {
        this.matcher = matcher;
    }

    public static enum NodeSort {
        NAME,
        OS,
        BENCHMARK,
        STEPS,
        REQUESTS,
        CPU,
        MEMORY,
        CLOUDPROFILE;

    }
}

