/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricCategory;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricType;
import com.pmease.quickbuild.plugin.measurement.core.mock.GridMock;
import com.pmease.quickbuild.plugin.measurement.core.web.MeasurementHelper;
import com.pmease.quickbuild.plugin.measurement.core.web.MetricsChartSetting;
import com.pmease.quickbuild.plugin.measurement.core.web.component.MetricGroupPanel;
import com.pmease.quickbuild.plugin.measurement.core.web.component.WidthDetectorPanel;
import com.pmease.quickbuild.plugin.measurement.core.web.data.MetricsChartData;
import com.pmease.quickbuild.plugin.measurement.core.web.data.TimeSeries;
import com.pmease.quickbuild.plugin.measurement.core.web.event.ChartSettingChanged;
import com.pmease.quickbuild.plugin.measurement.core.web.event.WidthDetectedEvent;
import com.pmease.quickbuild.plugin.measurement.core.web.node.ControlsPanel;
import com.pmease.quickbuild.util.TimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class MeasurementPanel
extends Panel {
    private final String source;
    private final IModel<Map<String, MetricsChartData>> dataModel;
    private int chartWidth;

    public MeasurementPanel(String id, String source, IModel<MetricsChartSetting> model) {
        super(id, model);
        this.source = source;
        this.dataModel = this.createDataModel();
        this.setOutputMarkupId(true);
    }

    protected IModel<Map<String, MetricsChartData>> createDataModel() {
        return new LoadableDetachableModel<Map<String, MetricsChartData>>(){

            protected Map<String, MetricsChartData> load() {
                MetricsChartSetting setting = MeasurementPanel.this.getChartSetting();
                String primaryGroup = setting.getPrimaryGroup();
                String secondGroup = setting.getSecondGroup();
                TimeSpan timespan = setting.getTimespan();
                Range period = timespan.range();
                MeasurementDataManager.TableType tableType = MeasurementPanel.this.getTableType();
                long interval = tableType.getInterval();
                period = Range.closed((Comparable)Long.valueOf(TimeUtils.roundDownTime((long)((Long)period.lowerEndpoint()), (long)interval)), (Comparable)period.upperEndpoint());
                MetricsChartData.Builder builder = MetricsChartData.builder();
                builder.timespan(timespan).interval(interval).addSource(MeasurementPanel.this.source).allowEmptyValue(MeasurementPanel.this.isAllowEmptyValue()).tableType(tableType);
                if (!Strings.isNullOrEmpty((String)primaryGroup)) {
                    builder.addMetricGroup(primaryGroup).addMetricGroup(secondGroup);
                }
                Map<String, MetricsChartData> data = builder.build(MeasurementPanel.this.getMetricType());
                for (MetricCategory each : MeasurementPanel.this.getAvailableGroups()) {
                    MetricsChartData d;
                    if (data.containsKey(each.getId())) {
                        d = data.get(each.getId());
                    } else {
                        d = new MetricsChartData((Range<Long>)period, interval);
                        data.put(each.getId(), d);
                    }
                    List<MetricMeta> metas = each.getMetas();
                    for (MetricMeta meta : metas) {
                        TimeSeries.Key key;
                        if (!MeasurementPanel.this.getMetricType().includes(meta.getMetricType()) || d.hasSeries(key = TimeSeries.Key.of(MeasurementPanel.this.source, meta.getMetricName()))) continue;
                        d.addMeasurements(key, new ArrayList<MeasurementData>(), MeasurementPanel.this.isAllowEmptyValue(), timespan.isUpperAlign());
                    }
                }
                return data;
            }
        };
    }

    protected boolean isAllowEmptyValue() {
        if (this.getChartSetting().getChartType() == MetricsChartSetting.ChartType.TABLE) {
            return true;
        }
        return true;
    }

    private MeasurementDataManager.TableType getTableType() {
        return MeasurementHelper.timespanToTableType(this.getChartSetting().getTimespan(), this.getChartSetting().isShowDetails());
    }

    protected Map<String, MetricsChartData> getData() {
        return (Map)this.dataModel.getObject();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.createControls("controls")});
        this.add(new Component[]{this.createContent()});
    }

    protected boolean isShowChartControls() {
        return true;
    }

    protected Component createGroupSections(String id) {
        Fragment frag = new Fragment(id, "frag", (MarkupContainer)this);
        frag.add(new Component[]{this.createSections("sections")});
        frag.setOutputMarkupId(true);
        return frag;
    }

    protected Component createContent() {
        if (this.chartWidth <= 0) {
            return new WidthDetectorPanel("content");
        }
        return this.createGroupSections("content");
    }

    protected Set<String> excludedGroups() {
        return ImmutableSet.of();
    }

    private MetricCategory[] getAvailableGroups() {
        List<Object> groups;
        String primaryGroup = this.getChartSetting().getPrimaryGroup();
        if (Strings.isNullOrEmpty((String)primaryGroup)) {
            groups = this.getAllGroups();
            Collections.sort(groups);
        } else {
            groups = Lists.newArrayList();
            MetricCategory g1 = MetricMetaRegistry.instance.getCategory(primaryGroup);
            groups.add(g1);
            String secondGroup = this.getChartSetting().getSecondGroup();
            if (!Strings.isNullOrEmpty((String)secondGroup)) {
                MetricCategory g2 = MetricMetaRegistry.instance.getCategory(secondGroup);
                groups.add(g2);
            }
        }
        return (MetricCategory[])Iterables.toArray((Iterable)groups, MetricCategory.class);
    }

    public List<MetricCategory> getAllGroups() {
        ArrayList all = Lists.newArrayList(MetricMetaRegistry.instance.getCategoriesOfType(this.getMetricType()));
        Collections.sort(all);
        return all;
    }

    protected Component createSections(String id) {
        AbstractReadOnlyModel<List<MetricCategory>> viewModel = new AbstractReadOnlyModel<List<MetricCategory>>(){

            public List<MetricCategory> getObject() {
                return ImmutableList.copyOf((Object[])MeasurementPanel.this.getAvailableGroups());
            }
        };
        return new ListView<MetricCategory>(id, (IModel)viewModel){

            protected void populateItem(ListItem<MetricCategory> item) {
                String key = ((MetricCategory)item.getModelObject()).getId();
                item.add(new Component[]{MeasurementPanel.this.createSectionPanel("panel", key).add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return MeasurementPanel.this.getChartSetting().getTimespan().isUpperAlign() ? "upper-align" : "lower-align";
                    }
                })})});
            }
        };
    }

    protected Component createSectionPanel(String id, final String groupId) {
        MetricGroupPanel p = new MetricGroupPanel(id, groupId, (IModel<MetricsChartSetting>)this.getDefaultModel(), (IModel<MetricsChartData>)new AbstractReadOnlyModel<MetricsChartData>(){

            public MetricsChartData getObject() {
                Map map = (Map)MeasurementPanel.this.dataModel.getObject();
                MetricsChartData data = (MetricsChartData)map.get(groupId);
                return data;
            }
        });
        return p;
    }

    public MetricsChartSetting getChartSetting() {
        return (MetricsChartSetting)this.getDefaultModelObject();
    }

    protected Component createControls(String id) {
        if (this.isShowChartControls()) {
            return new ControlsPanel(id, this);
        }
        return new WebMarkupContainer(id).setVisibilityAllowed(false);
    }

    protected MetricType getMetricType() {
        Optional<GridNode> node = GridMock.getNode(this.source);
        if (((GridNode)node.get()).isServer()) {
            return MetricType.SERVER;
        }
        return MetricType.NODE;
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof ChartSettingChanged) {
            ChartSettingChanged payload = (ChartSettingChanged)sink.getPayload();
            this.addOrReplace(new Component[]{this.createControls("controls")});
            this.addOrReplace(new Component[]{this.createContent()});
            payload.getTarget().add(new Component[]{this});
        } else if (sink.getPayload() instanceof WidthDetectedEvent) {
            WidthDetectedEvent e = (WidthDetectedEvent)sink.getPayload();
            this.getChartSetting().setChartWidth(e.getWidth());
            this.chartWidth = e.getWidth();
            this.addOrReplace(new Component[]{this.createContent()});
            e.getTarget().add(new Component[]{this});
        }
    }

    public String getSource() {
        return this.source;
    }

    public void onDetach() {
        if (this.dataModel != null) {
            this.dataModel.detach();
        }
        super.onDetach();
    }
}

