/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.log.NodeLog;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.measurement.core.mock.GridMock;
import com.pmease.quickbuild.plugin.measurement.core.trait.NodeTraits;
import com.pmease.quickbuild.plugin.measurement.core.web.ParamSpec;
import com.pmease.quickbuild.plugin.measurement.core.web.component.NodeTraitsPanel;
import com.pmease.quickbuild.plugin.measurement.core.web.node.NodeMeasurementPanel;
import com.pmease.quickbuild.plugin.report.engine.web.LinkPanel;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.OsType;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.LogPanel;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.component.tabbedpanel.TabbedPanel;
import com.pmease.quickbuild.web.page.grid.GridNodeModel;
import com.pmease.quickbuild.web.page.grid.GridPage;
import com.pmease.quickbuild.web.page.grid.NodeTabContribution;
import com.pmease.quickbuild.web.page.grid.RunningStepsPanel;
import com.pmease.quickbuild.web.page.grid.SystemAttributePanel;
import com.pmease.quickbuild.web.page.grid.UserAttributeEdit;
import com.pmease.quickbuild.web.page.grid.resource.NodeResourcesPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class GridNodePanel
extends Panel
implements IAjaxIndicatorAware {
    public static final String SYSTEM_ATTRIBUTES = "system_attributes";
    public static final String USER_ATTRIBUTES = "user_attributes";
    public static final String RESOURCES = "resources";
    public static final String STEPS = "steps";
    public static final String LOG = "log";
    private static final long serialVersionUID = 1L;
    private final String nodeAddress;
    private final String tabId;
    private final String tabParam;

    public GridNodePanel(String id, String address) {
        this(id, address, null, null);
    }

    public GridNodePanel(String id, String address, String tabId, String tabParam) {
        super(id);
        this.nodeAddress = address;
        this.tabId = tabId;
        this.tabParam = tabParam;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new BookmarkablePageLink("main", GridPage.class, GridPage.params4((String[])new String[]{"active_nodes", "overview"})).setEnabled(!Strings.isNullOrEmpty((String)this.nodeAddress))});
        WebMarkupContainer nodeLink = new WebMarkupContainer("nodelink");
        this.add(new Component[]{nodeLink});
        Label nodeLabel = new Label("address", this.nodeAddress);
        nodeLink.add(new Component[]{nodeLabel});
        nodeLink.setVisibilityAllowed(!Strings.isNullOrEmpty((String)this.nodeAddress));
        nodeLink.add(new Behavior[]{new MenuBehavior(){

            protected List<MenuItem> getMenuItems() {
                ArrayList list = Lists.newArrayList();
                List<GridNode> nodes = GridMock.getNodes();
                for (GridNode each : nodes) {
                    final String address = each.getAddress();
                    list.add(new MenuItem(){

                        public Component render(String componentId) {
                            LinkPanel p = new LinkPanel(componentId, address, true){

                                protected AbstractLink createLink(String id) {
                                    return new BookmarkablePageLink(id, GridPage.class, GridPage.params4((String[])new String[]{"active_nodes", address}));
                                }
                            };
                            return p;
                        }
                    });
                }
                return list;
            }
        }});
        WebMarkupContainer osIcon = new WebMarkupContainer("ostype");
        this.add(new Component[]{osIcon});
        Optional<GridNode> node = GridMock.getNode(this.nodeAddress);
        NodeTraits traits = NodeTraits.getFromNodeData(node);
        OsType ostype = traits.getOsType();
        osIcon.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)Model.of((Serializable)((Object)("icon-os-" + ostype.name().toLowerCase()))))});
        osIcon.add(new Behavior[]{AttributeAppender.append((String)"title", (Serializable)((Object)traits.getOsName()))});
        if (node.isPresent()) {
            this.add(new Component[]{new NodeTraitsPanel("nodetraits", this.nodeAddress)});
        } else {
            this.add(new Component[]{new WebMarkupContainer("nodetraits").setVisibilityAllowed(false)});
        }
        this.add(new Component[]{new WebMarkupContainer("notfound").setVisibilityAllowed(!node.isPresent())});
        WebMarkupContainer actionLink = new WebMarkupContainer("actions");
        this.add(new Component[]{actionLink.setVisibilityAllowed(SecurityHelper.isAdmin() && node.isPresent() && !((GridNode)node.get()).isServer())});
        actionLink.add(new Behavior[]{new MenuBehavior(){

            protected List<MenuItem> getMenuItems() {
                ArrayList menus = Lists.newArrayList();
                for (Action each : Action.values()) {
                    NodeActionMenuItem item = new NodeActionMenuItem(each);
                    menus.add(item);
                }
                return menus;
            }
        }});
        ArrayList tabs = Lists.newArrayList();
        tabs.add(new Tab("overview", "Overview"){

            public Panel getPanel(String id, Map<String, String> params) {
                return new NodeMeasurementPanel(id, GridNodePanel.this.nodeAddress);
            }
        });
        if (SecurityHelper.isNodeAttributesAllowed((User)Context.getUser())) {
            tabs.add(new Tab(SYSTEM_ATTRIBUTES, "System Attributes"){

                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    return new SystemAttributePanel(panelId, (IModel)new GridNodeModel(GridNodePanel.this.nodeAddress));
                }
            });
            tabs.add(new Tab(USER_ATTRIBUTES, "User Attributes"){

                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    return new UserAttributeEdit(panelId, (IModel)new GridNodeModel(GridNodePanel.this.nodeAddress));
                }
            });
        }
        tabs.add(new Tab(RESOURCES, "Resources"){

            public Panel getPanel(String panelId, Map<String, String> params) {
                return new NodeResourcesPanel(panelId, (IModel)new GridNodeModel(GridNodePanel.this.nodeAddress));
            }
        });
        tabs.add(new Tab(STEPS, "Running Steps"){

            public Panel getPanel(String panelId, Map<String, String> params) {
                return new RunningStepsPanel(panelId, (IModel)new GridNodeModel(GridNodePanel.this.nodeAddress));
            }
        });
        if (SecurityHelper.isSystemLogAllowed()) {
            String title = this.nodeAddress.equals(Grid.instance.getServerNode().getAddress()) ? "Server Log" : "Agent Log";
            tabs.add(new Tab(LOG, title){

                public Panel getPanel(String panelId, Map<String, String> params) {
                    Date anchorDate = this.getId().equals(GridNodePanel.this.tabId) && GridNodePanel.this.tabParam != null ? new Date(Long.parseLong(GridNodePanel.this.tabParam)) : null;
                    return new LogPanel(panelId, (IModel)new Model((Serializable)new NodeLog(GridNodePanel.this.nodeAddress, anchorDate)), false);
                }
            });
        }
        ArrayList extendedTabs = new ArrayList();
        List contributions = PluginManager.instance.getExtensions(NodeTabContribution.class);
        for (NodeTabContribution each : contributions) {
            extendedTabs.addAll(each.getTabs(this.nodeAddress));
        }
        Collections.sort(extendedTabs, new Comparator<Tab>(){

            @Override
            public int compare(Tab o1, Tab o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        tabs.addAll(extendedTabs);
        if (this.tabId != null) {
            this.add(new Component[]{new TabbedPanel("tabs", tabs, new String[]{this.tabId}){

                protected WebMarkupContainer newTabLink(String linkId, String[] tabIds) {
                    return new BookmarkablePageLink(linkId, GridPage.class, ParamSpec.of(new String[]{"active_nodes", GridNodePanel.this.nodeAddress, tabIds[0]}));
                }
            }});
        } else {
            this.add(new Component[]{new TabbedPanel("tabs", tabs){

                protected WebMarkupContainer newTabLink(String linkId, String[] tabIds) {
                    return new BookmarkablePageLink(linkId, GridPage.class, ParamSpec.of(new String[]{"active_nodes", GridNodePanel.this.nodeAddress, tabIds[0]}));
                }
            }});
        }
    }

    private void onAction(Action action) {
        Optional<GridNode> node = GridMock.getNode(this.nodeAddress);
        if (!node.isPresent()) {
            return;
        }
        switch (action) {
            case RESTART: {
                ((GridNode)node.get()).getNodeService().restart();
                break;
            }
            case STOP: {
                ((GridNode)node.get()).getNodeService().stop();
                break;
            }
            case UNAUTHORIZE: {
                Token token = CacheManager.instance.getToken(((GridNode)node.get()).getToken());
                if (token != null) {
                    TokenManager.instance.delete((AbstractEntity)token);
                }
                AgentManager.instance.removeBuildAgent(((GridNode)node.get()).getIp(), ((GridNode)node.get()).getPort());
                break;
            }
            case TERMINATE: {
                CloudProfile profile = CacheManager.instance.getCloudProfile(((GridNode)node.get()).getCloudProfile().getId());
                if (profile == null) break;
                profile.getNodeLauncher().terminateNode(((GridNode)node.get()).getLaunchId());
                Token token = TokenManager.instance.getByValue(((GridNode)node.get()).getToken());
                if (token == null) break;
                TokenManager.instance.delete((AbstractEntity)token);
                break;
            }
        }
        String message = "Active node '" + ((GridNode)node.get()).getAddress() + "' was " + action.getPreteriteName();
        AuditManager.instance.audit("Grid::Nodes", message);
        this.getSession().info((Serializable)((Object)message));
        this.getRequestCycle().setResponsePage(GridPage.class, ParamSpec.of(new String[]{"active_nodes"}));
    }

    public String getAjaxIndicatorMarkupId() {
        return "global-ajax-indicator";
    }

    private static enum Action {
        UNAUTHORIZE("Unauthorize", "unauthroized"),
        RESTART("Restart", "requested to restart"),
        STOP("Stop", "requested to stop"),
        TERMINATE("Terminate", "requested to terminate");

        final String displayName;
        final String preteriteName;

        private Action(String displayName, String preteriteName) {
            this.displayName = displayName;
            this.preteriteName = preteriteName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getPreteriteName() {
            return this.preteriteName;
        }
    }

    private class NodeActionMenuItem
    extends MenuItem {
        private static final long serialVersionUID = 1L;
        final Action action;

        NodeActionMenuItem(Action action) {
            this.action = action;
        }

        public Component render(String componentId) {
            TextLink<Void> link = new TextLink<Void>(componentId, this.action.getDisplayName()){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    GridNodePanel.this.onAction(NodeActionMenuItem.this.action);
                }
            };
            link.add(new Behavior[]{new ConfirmBehavior("Are you sure you want to " + this.action.name().toLowerCase() + " the node [" + GridNodePanel.this.nodeAddress + "]?")});
            return link;
        }
    }
}

