/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.measurement.core.meta.CpuMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.JvmMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.mock.GridMock;
import com.pmease.quickbuild.plugin.measurement.core.web.MeasurementHelper;
import com.pmease.quickbuild.plugin.measurement.core.web.component.MetricsColorTablePanel;
import com.pmease.quickbuild.plugin.measurement.core.web.data.MetricsChartData;
import com.pmease.quickbuild.plugin.measurement.core.web.data.TimeSeries;
import com.pmease.quickbuild.plugin.measurement.core.web.node.MetricLinkPanel;
import com.pmease.quickbuild.plugin.measurement.core.web.node.NodeFilterFormPanel;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriteria;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriteriaChanged;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher.CompositeNodeMatcher;
import com.pmease.quickbuild.plugin.report.engine.web.AjaxTextLink;
import com.pmease.quickbuild.plugin.report.engine.web.LinkPanel;
import com.pmease.quickbuild.util.TimeUtils;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class GridHeatmapPanel
extends Panel {
    private MetricMeta metric;
    private TimeSpan timespan;
    private NodeCriteria criteria = new NodeCriteria();
    private boolean showDetails;
    static List<MetricMeta> METAS = ImmutableList.of((Object)JvmMetricGroup.MEMORY_USAGE, (Object)CpuMetricGroup.TOTAL_USAGE);
    static List<TimeSpan> PERIODS = ImmutableList.of((Object)TimeSpan.LAST_HOUR, (Object)TimeSpan.LAST_2_HOURS, (Object)TimeSpan.LAST_4_HOURS, (Object)TimeSpan.LAST_DAY, (Object)TimeSpan.LAST_WEEK, (Object)TimeSpan.LAST_MONTH);

    public GridHeatmapPanel(String id) {
        this(id, TimeSpan.LAST_HOUR, JvmMetricGroup.MEMORY_USAGE, false);
    }

    public GridHeatmapPanel(String id, TimeSpan timespan, MetricMeta metric, boolean showDetails) {
        super(id);
        this.timespan = timespan;
        this.metric = metric;
        this.showDetails = showDetails;
        this.setOutputMarkupId(true);
        LoadableDetachableModel<MetricsChartData> model = new LoadableDetachableModel<MetricsChartData>(){

            protected MetricsChartData load() {
                MetricsChartData.Builder builder = MetricsChartData.builder().addMetric(GridHeatmapPanel.this.metric.getMetricName()).timespan(GridHeatmapPanel.this.getTimeSpan()).tableType(GridHeatmapPanel.this.getTableType()).interval(GridHeatmapPanel.this.getTableType().getInterval()).allowEmptyValue(true);
                List<MeasurementData> measurements = builder.find();
                HashMap map = Maps.newHashMap();
                for (MeasurementData each : measurements) {
                    List<MeasurementData> list;
                    String source = each.getSource();
                    if (map.containsKey(source)) {
                        list = (List)map.get(source);
                    } else {
                        list = Lists.newArrayList();
                        map.put(source, list);
                    }
                    list.add(each);
                }
                Range period = GridHeatmapPanel.this.getTimeSpan().range();
                long beginTime = TimeUtils.roundDownTime((long)((Long)period.lowerEndpoint()), (long)GridHeatmapPanel.this.getTableType().getInterval());
                long endTime = (Long)period.upperEndpoint();
                MetricsChartData data = new MetricsChartData(beginTime, endTime, GridHeatmapPanel.this.getTableType().getInterval());
                for (GridNode each : GridHeatmapPanel.this.getNodes()) {
                    List list = (List)map.get(each.getAddress());
                    if (list == null) {
                        list = Lists.newArrayList();
                    }
                    data.addMeasurements(TimeSeries.Key.of(each.getAddress(), GridHeatmapPanel.this.metric.getMetricName()), list, true, GridHeatmapPanel.this.getTimeSpan().isUpperAlign());
                }
                return data;
            }
        };
        this.setDefaultModel((IModel)model);
    }

    private MeasurementDataManager.TableType getTableType() {
        return MeasurementHelper.timespanToTableType(this.getTimeSpan(), this.showDetails);
    }

    private List<GridNode> getNodes() {
        ArrayList nodes = Lists.newArrayList(GridMock.getNodes());
        if (this.criteria.isEmpty()) {
            return nodes;
        }
        CompositeNodeMatcher matcher = this.criteria.toNodeMatcher();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            GridNode node = (GridNode)it.next();
            if (matcher.matches(node)) continue;
            it.remove();
        }
        return nodes;
    }

    private TimeSpan getTimeSpan() {
        return this.timespan;
    }

    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer headspan = new WebMarkupContainer("headspan");
        this.add(new Component[]{headspan});
        this.createHeadControls(headspan);
        this.add(new Component[]{this.createHeatmap()});
        this.add(new Component[]{this.createBreadcrumbs()});
        headspan.add(new Component[]{new AjaxLink<Void>("searchbtn"){

            public void onClick(AjaxRequestTarget target) {
                Dialog dialog = new Dialog("Advanced Search"){
                    private static final long serialVersionUID = 1L;

                    protected Component render(String componentId) {
                        return new NodeFilterFormPanel(componentId, GridHeatmapPanel.this, GridHeatmapPanel.this.criteria, null);
                    }
                };
                dialog.dialogClass("search-dlg").width(600).open(target);
            }
        }});
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof NodeCriteriaChanged) {
            NodeCriteriaChanged event = (NodeCriteriaChanged)sink.getPayload();
            this.criteria = event.getCriteria();
            this.onFilterChanged(event.getTarget());
        }
    }

    private void onFilterChanged(AjaxRequestTarget target) {
        this.criteria.removeInvalid();
        this.addOrReplace(new Component[]{this.createBreadcrumbs()});
        this.addOrReplace(new Component[]{this.createHeatmap()});
        target.add(new Component[]{this});
    }

    private Component createBreadcrumbs() {
        WebMarkupContainer container = new WebMarkupContainer("breadcrumbs");
        if (this.criteria.isEmpty()) {
            container.setVisibilityAllowed(false);
            return container;
        }
        container.add(new Component[]{new AjaxLink<Void>("allLink"){

            public void onClick(AjaxRequestTarget target) {
                GridHeatmapPanel.this.criteria = new NodeCriteria();
                GridHeatmapPanel.this.onFilterChanged(target);
            }
        }});
        container.add(new Component[]{new ListView<NodeCriterion>("links", this.criteria.getCriterions()){

            protected void populateItem(ListItem<NodeCriterion> item) {
                final int index = item.getIndex();
                if (index == 0) {
                    item.add(new Component[]{new Label("connective", "").setVisibilityAllowed(false)});
                } else {
                    item.add(new Component[]{new Label("connective", GridHeatmapPanel.this.criteria.getConnective().name())});
                }
                NodeCriterion criterion = (NodeCriterion)item.getModelObject();
                item.add(new Component[]{new AjaxLink<Void>("remove"){

                    public void onClick(AjaxRequestTarget target) {
                        GridHeatmapPanel.this.criteria.remove(index);
                        GridHeatmapPanel.this.onFilterChanged(target);
                    }
                }});
                item.add(new Component[]{new Label("filter", criterion.toNodeMatcher().toString())});
            }
        }});
        return container;
    }

    protected void createHeadControls(WebMarkupContainer headspan) {
        WebMarkupContainer link = new WebMarkupContainer("metricLink");
        headspan.add(new Component[]{link});
        link.add(new Component[]{new Label("label", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return GridHeatmapPanel.this.metric.getFullName();
            }
        })});
        link.add(new Behavior[]{new MenuBehavior(){

            protected List<MenuItem> getMenuItems() {
                ArrayList lists = Lists.newArrayList();
                for (MetricMeta each : METAS) {
                    lists.add(new MetricMenuItem(each));
                }
                return lists;
            }
        }});
        headspan.add(new Component[]{new Loop("periods", PERIODS.size()){

            protected void populateItem(LoopItem item) {
                int index = item.getIndex();
                final TimeSpan span = PERIODS.get(index);
                AjaxTextLink link = new AjaxTextLink("link", span.getDisplayName()){

                    public void onClick(AjaxRequestTarget target) {
                        GridHeatmapPanel.this.timespan = span;
                        GridHeatmapPanel.this.onChartSettingChanged(target);
                    }
                };
                link.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return GridHeatmapPanel.this.timespan == span ? "checked" : "";
                    }
                })});
                item.add(new Component[]{link});
            }
        }});
        headspan.add(new Component[]{new AjaxLink<Void>("detailed"){

            public void onClick(AjaxRequestTarget target) {
                GridHeatmapPanel.this.showDetails = !GridHeatmapPanel.this.showDetails;
                GridHeatmapPanel.this.onChartSettingChanged(target);
            }

            protected void onConfigure() {
                this.setVisibilityAllowed(GridHeatmapPanel.this.getTimeSpan().ordinal() >= TimeSpan.LAST_DAY.ordinal());
            }
        }.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return GridHeatmapPanel.this.showDetails ? "checked" : "";
            }
        })})});
    }

    private Component createHeatmap() {
        List<GridNode> nodes = this.getNodes();
        if (nodes.isEmpty()) {
            return new Fragment("heats", "notfound", (MarkupContainer)this);
        }
        MetricsColorTablePanel panel = new MetricsColorTablePanel("heats", this.getDefaultModel(), MeasurementHelper.getTimeFormatPattern(this.getTimeSpan(), this.showDetails), false){

            @Override
            protected Component createNameComponent(String id, int idx) {
                final String address = this.getNameLabel(idx);
                return new LinkPanel(id, address, true){

                    protected AbstractLink createLink(String id) {
                        return new BookmarkablePageLink(id, GridPage.class, GridPage.params4((String[])new String[]{"active_nodes", address}));
                    }
                };
            }
        };
        panel.setNameColumnType(MetricsColorTablePanel.NameColumnType.SOURCE);
        panel.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)(this.getTimeSpan().isUpperAlign() ? "upper-align" : "lower-align")))});
        return panel;
    }

    private void onChartSettingChanged(AjaxRequestTarget target) {
        this.addOrReplace(new Component[]{this.createHeatmap()});
        target.add(new Component[]{this});
    }

    private class MetricMenuItem
    extends MenuItem {
        final MetricMeta meta;

        MetricMenuItem(MetricMeta meta) {
            this.meta = meta;
        }

        public Component render(String componentId) {
            return new MetricLinkPanel(componentId, this.meta){

                @Override
                protected AjaxLink<?> createLink(String id) {
                    return new AjaxLink<Void>(id){

                        public void onClick(AjaxRequestTarget target) {
                            if (Objects.equal((Object)GridHeatmapPanel.this.metric, (Object)MetricMenuItem.this.meta)) {
                                return;
                            }
                            GridHeatmapPanel.this.metric = MetricMenuItem.this.meta;
                            GridHeatmapPanel.this.onChartSettingChanged(target);
                        }
                    };
                }

                @Override
                protected boolean isSelected() {
                    return Objects.equal((Object)GridHeatmapPanel.this.metric, (Object)MetricMenuItem.this.meta);
                }
            };
        }
    }
}

