/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.alert.engine.web.components.TimeSpanButtonGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricCategory;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.measurement.core.web.MetricsChartSetting;
import com.pmease.quickbuild.plugin.measurement.core.web.component.MenuItems;
import com.pmease.quickbuild.plugin.measurement.core.web.event.ChartSettingChanged;
import com.pmease.quickbuild.plugin.measurement.core.web.node.MeasurementPanel;
import com.pmease.quickbuild.plugin.report.engine.web.AjaxTextLink;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

class ControlsPanel
extends Panel {
    final MeasurementPanel parentPanel;
    static final TimeSpan[] PERIODS = new TimeSpan[]{TimeSpan.LAST_HOUR, TimeSpan.LAST_2_HOURS, TimeSpan.LAST_4_HOURS, TimeSpan.LAST_DAY, TimeSpan.LAST_WEEK, TimeSpan.LAST_MONTH};

    public ControlsPanel(String id, MeasurementPanel parent) {
        super(id);
        this.parentPanel = parent;
        this.setOutputMarkupId(true);
    }

    private MetricsChartSetting getChartSetting() {
        return this.parentPanel.getChartSetting();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.newPeriodButtons("periods")});
        WebMarkupContainer primary = new WebMarkupContainer("primaryMetric");
        this.add(new Component[]{primary});
        primary.add(new Component[]{new Label("primaryName", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                String primaryGroup = ControlsPanel.this.getChartSetting().getPrimaryGroup();
                if (Strings.isNullOrEmpty((String)primaryGroup)) {
                    return "All Metrics";
                }
                MetricCategory group = MetricMetaRegistry.instance.getCategory(primaryGroup);
                return group.getName();
            }
        })});
        primary.add(new Behavior[]{new MenuBehavior(){

            protected List<MenuItem> getMenuItems() {
                return ControlsPanel.this.getMetricMenuItems(true);
            }
        }});
        WebMarkupContainer secondary = new WebMarkupContainer("secondaryMetric");
        this.add(new Component[]{secondary});
        boolean visible = !Strings.isNullOrEmpty((String)this.getChartSetting().getPrimaryGroup());
        secondary.setVisibilityAllowed(visible);
        if (visible) {
            secondary.add(new Component[]{new Label("secondaryName", (IModel)new AbstractReadOnlyModel<String>(){

                public String getObject() {
                    String secondGroup = ControlsPanel.this.getChartSetting().getSecondGroup();
                    if (Strings.isNullOrEmpty((String)secondGroup)) {
                        return "select a metric";
                    }
                    MetricCategory group = MetricMetaRegistry.instance.getCategory(secondGroup);
                    return group.getName();
                }
            })});
            secondary.add(new Behavior[]{new MenuBehavior(){

                protected List<MenuItem> getMenuItems() {
                    return ControlsPanel.this.getMetricMenuItems(false);
                }
            }});
        }
        this.add(new Component[]{new AjaxLink<Void>("removeSecond"){

            public void onClick(AjaxRequestTarget target) {
                ControlsPanel.this.getChartSetting().setSecondGroup(null);
                ControlsPanel.this.onChartSettingChanged(target);
            }
        }.setVisibilityAllowed(!Strings.isNullOrEmpty((String)this.getChartSetting().getSecondGroup()))});
        this.add(new Component[]{this.newChartTypeButtons()});
        this.add(new Component[]{new AjaxLink<Void>("detailed"){

            public void onClick(AjaxRequestTarget target) {
                ControlsPanel.this.getChartSetting().setShowDetails(!ControlsPanel.this.getChartSetting().isShowDetails());
                ControlsPanel.this.onChartSettingChanged(target);
            }

            protected void onConfigure() {
                this.setVisibilityAllowed(ControlsPanel.this.getChartSetting().getTimespan().ordinal() >= TimeSpan.LAST_DAY.ordinal());
            }
        }.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ControlsPanel.this.getChartSetting().isShowDetails() ? "checked" : "";
            }
        })})});
    }

    private MetricsChartSetting.ChartType[] getChartTypes() {
        return new MetricsChartSetting.ChartType[]{MetricsChartSetting.ChartType.TABLE, MetricsChartSetting.ChartType.LINE, MetricsChartSetting.ChartType.AREA};
    }

    private Component newChartTypeButtons() {
        return new Loop("chartTypes", (IModel)new AbstractReadOnlyModel<Integer>(){

            public Integer getObject() {
                return ControlsPanel.this.getChartTypes().length;
            }
        }){

            protected void populateItem(LoopItem item) {
                final MetricsChartSetting.ChartType type = ControlsPanel.this.getChartTypes()[item.getIndex()];
                AjaxLink<Void> link = new AjaxLink<Void>("btn"){

                    public void onClick(AjaxRequestTarget target) {
                        ControlsPanel.this.getChartSetting().setChartTypes(type);
                        ControlsPanel.this.onChartSettingChanged(target);
                    }
                };
                link.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return type == ControlsPanel.this.getChartSetting().getChartType() ? "checked" : "";
                    }
                })});
                link.add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)type.name().toLowerCase()))});
                link.add(new Component[]{new WebMarkupContainer("icon").add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return "icon-chart-" + type.name().toLowerCase();
                    }
                })})});
                item.add(new Component[]{link});
            }
        };
    }

    private List<MenuItem> getMetricMenuItems(boolean forPrimary) {
        ArrayList list = Lists.newArrayList();
        if (forPrimary) {
            list.add(new MenuItem(){

                public Component render(String componentId) {
                    return new AjaxTextLink(componentId, "All Metrics"){

                        public void onClick(AjaxRequestTarget target) {
                            ControlsPanel.this.getChartSetting().setPrimaryGroup(null);
                            ControlsPanel.this.onChartSettingChanged(target);
                        }
                    };
                }
            });
            list.add(MenuItems.separator());
        }
        List<MetricCategory> groups = this.parentPanel.getAllGroups();
        ArrayList sorted = Lists.newArrayList(groups);
        Collections.sort(sorted);
        for (MetricCategory each : sorted) {
            list.add(new MetricGroupMenu(each, forPrimary));
        }
        return list;
    }

    protected Component newPeriodButtons(String id) {
        return new TimeSpanButtonGroup(id, this.getChartSetting().getTimespan()){

            protected void onTimeSpanChanged(AjaxRequestTarget target, TimeSpan timespan) {
                ControlsPanel.this.getChartSetting().setTimespan(timespan);
                ControlsPanel.this.onChartSettingChanged(target);
            }
        };
    }

    private void onChartSettingChanged(AjaxRequestTarget target) {
        target.add(new Component[]{this});
        this.send((IEventSink)this.parentPanel, Broadcast.BREADTH, new ChartSettingChanged(target));
    }

    private class MetricGroupMenu
    extends MenuItem {
        final MetricCategory group;
        final boolean forPrimary;

        MetricGroupMenu(MetricCategory group, boolean forPrimary) {
            this.group = group;
            this.forPrimary = forPrimary;
        }

        public Component render(String componentId) {
            Fragment frag = new Fragment(componentId, "menuFrag", (MarkupContainer)ControlsPanel.this);
            AjaxLink<Void> link = new AjaxLink<Void>("link"){

                public void onClick(AjaxRequestTarget target) {
                    if (MetricGroupMenu.this.forPrimary) {
                        ControlsPanel.this.getChartSetting().setPrimaryGroup(MetricGroupMenu.this.group.getId());
                    } else {
                        ControlsPanel.this.getChartSetting().setSecondGroup(MetricGroupMenu.this.group.getId());
                    }
                    ControlsPanel.this.onChartSettingChanged(target);
                }
            };
            frag.add(new Component[]{link});
            link.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                public String getObject() {
                    return MetricGroupMenu.this.isSelected() ? "selected" : "";
                }
            })});
            WebMarkupContainer icon = new WebMarkupContainer("icon");
            link.add(new Component[]{icon});
            icon.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                public String getObject() {
                    return MetricGroupMenu.this.isSelected() ? "icon-ok" : "icon-null";
                }
            })});
            link.add(new Component[]{new Label("label", (IModel)new AbstractReadOnlyModel<String>(){

                public String getObject() {
                    return MetricGroupMenu.this.group.getName();
                }
            })});
            return frag;
        }

        private boolean isSelected() {
            return Objects.equal((Object)ControlsPanel.this.getChartSetting().getPrimaryGroup(), (Object)this.group.getId()) || Objects.equal((Object)ControlsPanel.this.getChartSetting().getSecondGroup(), (Object)this.group.getId());
        }
    }
}

