/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.node;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.measurement.core.MeasurementPlugin;
import com.pmease.quickbuild.plugin.measurement.core.cache.LatestReportCache;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.NodeMeasurementReport;
import com.pmease.quickbuild.plugin.measurement.core.mock.GridMock;
import com.pmease.quickbuild.plugin.measurement.core.trait.NodeTraits;
import com.pmease.quickbuild.plugin.measurement.core.web.component.MenuItems;
import com.pmease.quickbuild.plugin.measurement.core.web.node.ActiveNodesTable;
import com.pmease.quickbuild.plugin.measurement.core.web.node.NodeDataProvider;
import com.pmease.quickbuild.plugin.measurement.core.web.node.NodeFilterFormPanel;
import com.pmease.quickbuild.plugin.measurement.core.web.node.UserFilters;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.AttributeNameCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.CloudProfileCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriteria;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriteriaChanged;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.criterion.NodeNameCriterion;
import com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher.CompositeNodeMatcher;
import com.pmease.quickbuild.plugin.measurement.core.web.node.morenodematcher.MatcherOperator;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.web.AjaxTextLink;
import com.pmease.quickbuild.plugin.report.engine.web.LinkPanel;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.chart.ColorUtils;
import com.pmease.quickbuild.web.component.BookmarkableTextLink;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchNavToolbar;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchPatternChanged;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.feedback.ContainerFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class ActiveNodesTablePanel
extends Panel
implements IAjaxIndicatorAware {
    private SelectionColumn<String> selectionColumn;
    private ActiveNodesTable table;
    private IModel<List<BuildRequest>> buildRequestsModel;
    private NodeCriteria criteria = new NodeCriteria();
    private final IModel<Map<String, NodeCriteria>> userFiltersModel;
    private IModel<String> selectedName = Model.of((Serializable)((Object)""));

    public ActiveNodesTablePanel(String id) {
        super(id);
        this.buildRequestsModel = new LoadableDetachableModel<List<BuildRequest>>(){

            protected List<BuildRequest> load() {
                return BuildEngine.instance.getBuildRequests(null);
            }
        };
        this.userFiltersModel = new LoadableDetachableModel<Map<String, NodeCriteria>>(){

            protected Map<String, NodeCriteria> load() {
                Optional<UserFilters> uf = UserFilters.get();
                if (uf.isPresent()) {
                    return ((UserFilters)uf.get()).getFilters();
                }
                return Collections.emptyMap();
            }
        };
        this.setOutputMarkupId(true);
    }

    private List<BuildRequest> getBuildRequests() {
        return (List)this.buildRequestsModel.getObject();
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof NodeCriteriaChanged) {
            NodeCriteriaChanged event = (NodeCriteriaChanged)sink.getPayload();
            this.criteria = event.getCriteria();
            this.selectedName.setObject((Object)event.getCriteriaName());
            this.onFilterChanged(event.getTarget());
        } else if (sink.getPayload() instanceof SearchPatternChanged) {
            SearchPatternChanged event = (SearchPatternChanged)sink.getPayload();
            this.criteria = new NodeCriteria();
            this.selectedName.setObject(null);
            if (!Strings.isNullOrEmpty((String)event.getPattern())) {
                this.criteria.add(new NodeNameCriterion(MatcherOperator.CONTAINS, event.getPattern()));
                this.criteria.add(new AttributeNameCriterion(MatcherOperator.CONTAINS, event.getPattern()));
                this.criteria.add(new CloudProfileCriterion(MatcherOperator.CONTAINS, event.getPattern()));
                this.criteria.setConnective(CompositeNodeMatcher.Connective.OR);
            }
            this.onFilterChanged(event.getTarget());
        }
    }

    private void onFilterChanged(AjaxRequestTarget target) {
        this.criteria.removeInvalid();
        CompositeNodeMatcher matcher = this.criteria.toNodeMatcher();
        NodeDataProvider provider = (NodeDataProvider)this.table.getDataProvider();
        provider.setMatcher(matcher);
        this.table.setCurrentPage(0);
        if (this.selectionColumn != null) {
            this.selectionColumn.getSelections().clear();
        }
        this.addOrReplace(new Component[]{this.createBreadcrumbs()});
        target.add(new Component[]{this});
    }

    private Component createBreadcrumbs() {
        WebMarkupContainer container = new WebMarkupContainer("breadcrumbs");
        if (this.criteria.isEmpty()) {
            container.setVisibilityAllowed(false);
            return container;
        }
        AjaxLink<Void> allLink = new AjaxLink<Void>("allLink"){

            public void onClick(AjaxRequestTarget target) {
                ActiveNodesTablePanel.this.criteria = new NodeCriteria();
                ActiveNodesTablePanel.this.selectedName.setObject(null);
                ActiveNodesTablePanel.this.onFilterChanged(target);
            }
        };
        allLink.add(new Component[]{new Label("label", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ActiveNodesTablePanel.this.criteria.getMatching();
            }
        })});
        container.add(new Component[]{allLink});
        container.add(new Component[]{new ListView<NodeCriterion>("links", this.criteria.getCriterions()){

            protected void populateItem(ListItem<NodeCriterion> item) {
                final int index = item.getIndex();
                if (index == 0) {
                    item.add(new Component[]{new Label("connective", "").setVisibilityAllowed(false)});
                } else {
                    item.add(new Component[]{new Label("connective", ActiveNodesTablePanel.this.criteria.getConnective().name())});
                }
                NodeCriterion criterion = (NodeCriterion)item.getModelObject();
                item.add(new Component[]{new AjaxLink<Void>("remove"){

                    public void onClick(AjaxRequestTarget target) {
                        ActiveNodesTablePanel.this.criteria.remove(index);
                        ActiveNodesTablePanel.this.selectedName.setObject((Object)"");
                        ActiveNodesTablePanel.this.onFilterChanged(target);
                    }
                }});
                item.add(new Component[]{new Label("filter", criterion.toNodeMatcher().toString())});
            }
        }});
        return container;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.table = new ActiveNodesTable("nodes", this.getColumns(), new CompositeNodeMatcher());
        this.add(new Component[]{this.table});
        this.table.addTopToolbar((AbstractToolbar)new AdvancedSearchNavToolbar(this.table));
        this.table.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar((DataTable)this.table, (ISortStateLocator)((ISortableDataProvider)this.table.getDataProvider())));
        this.table.addBottomToolbar((AbstractToolbar)new AdvancedSearchNavToolbar(this.table));
        this.add(new Component[]{this.createBreadcrumbs()});
        WebMarkupContainer actionLink = new WebMarkupContainer("actions");
        actionLink.setOutputMarkupId(true);
        actionLink.setVisibilityAllowed(SecurityHelper.isAdmin());
        this.add(new Component[]{actionLink});
        actionLink.add(new Behavior[]{new MenuBehavior(){

            protected List<MenuItem> getMenuItems() {
                ArrayList menus = Lists.newArrayList();
                for (int i = 0; i < Action.values().length; ++i) {
                    Action a = Action.values()[i];
                    if (a == Action.RESTART_ALL) {
                        menus.add(MenuItems.separator());
                    }
                    menus.add(new ActionMenuItem(a));
                }
                return menus;
            }
        }});
        if (SecurityHelper.isAdmin()) {
            this.add(new Component[]{new UpdateAttributeForm("attrForm")});
        } else {
            this.add(new Component[]{new WebMarkupContainer("attrForm").setVisibilityAllowed(false)});
        }
        final WebMarkupContainer filtersDiv = new WebMarkupContainer("filterdiv"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(!ActiveNodesTablePanel.this.getUserFilters().isEmpty());
            }
        };
        filtersDiv.setOutputMarkupId(true);
        this.add(new Component[]{filtersDiv});
        filtersDiv.add(new Component[]{new ListView<String>("filters", (IModel)new AbstractReadOnlyModel<List<String>>(){

            public List<String> getObject() {
                ArrayList names = Lists.newArrayList(ActiveNodesTablePanel.this.getUserFilters().keySet());
                Collections.sort(names);
                return names;
            }
        }){

            protected void populateItem(ListItem<String> item) {
                final String name = (String)item.getModelObject();
                FilterLink link = new FilterLink("filterlink", (IModel<String>)Model.of((Serializable)((Object)name)));
                link.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return Objects.equal((Object)name, (Object)ActiveNodesTablePanel.this.selectedName.getObject()) ? "selected" : "";
                    }
                })});
                item.add(new Component[]{link});
                link.add(new Component[]{new Label("name", name)});
                WebMarkupContainer more = new WebMarkupContainer("morelink");
                item.add(new Component[]{more});
                more.add(new Behavior[]{new MenuBehavior(){

                    protected List<MenuItem> getMenuItems() {
                        ArrayList menus = Lists.newArrayList();
                        menus.add(new MenuItem(){

                            public Component render(String componentId) {
                                AjaxTextLink link = new AjaxTextLink(componentId, "Delete filter"){

                                    public void onClick(AjaxRequestTarget target) {
                                        Optional<UserFilters> uf = UserFilters.get();
                                        if (!uf.isPresent()) {
                                            return;
                                        }
                                        User user = ActiveNodesTablePanel.this.getCurrentUser();
                                        if (user == null) {
                                            return;
                                        }
                                        UserFilters filters = (UserFilters)uf.get();
                                        filters.getFilters().remove(name);
                                        PluginSettingHelper.saveUserSetting(MeasurementPlugin.class, (User)user, (Object)filters);
                                        if (Objects.equal((Object)name, (Object)ActiveNodesTablePanel.this.selectedName.getObject())) {
                                            ActiveNodesTablePanel.this.selectedName.setObject((Object)"");
                                            this.send((IEventSink)ActiveNodesTablePanel.this, Broadcast.EXACT, new NodeCriteriaChanged(target, new NodeCriteria(), null));
                                        } else {
                                            target.add(new Component[]{filtersDiv});
                                        }
                                    }
                                };
                                link.add(new Behavior[]{new ConfirmBehavior("Are you sure you want to remove this filter?")});
                                return link;
                            }
                        });
                        menus.add(new MenuItem(){

                            public Component render(String componentId) {
                                AjaxTextLink link = new AjaxTextLink(componentId, "Edit filter"){

                                    public void onClick(AjaxRequestTarget target) {
                                        Dialog dialog = new Dialog("Edit Filter"){
                                            private static final long serialVersionUID = 1L;

                                            protected Component render(String componentId) {
                                                return new NodeFilterFormPanel(componentId, ActiveNodesTablePanel.this, (NodeCriteria)ActiveNodesTablePanel.this.getUserFilters().get(name), name);
                                            }
                                        };
                                        dialog.dialogClass("search-dlg").width(600).open(target);
                                    }
                                };
                                return link;
                            }
                        });
                        return menus;
                    }
                }});
            }
        }});
    }

    private Map<String, NodeCriteria> getUserFilters() {
        return (Map)this.userFiltersModel.getObject();
    }

    private User getCurrentUser() {
        return Context.getUser();
    }

    private void onRestartNodes(List<GridNode> nodes, boolean all) {
        for (GridNode node : nodes) {
            if (node.isServer()) continue;
            node.getNodeService().restart();
            if (all) continue;
            AuditManager.instance.audit("Grid::Nodes", "Active agent " + node.getAddress() + " is requested to restart.");
        }
        if (all) {
            AuditManager.instance.audit("Grid::Nodes", "All active agents are requested to restart.");
        }
        this.getSession().info((Serializable)((Object)"Restart command has been issued to those agents."));
    }

    private void onStopNodes(List<GridNode> nodes, boolean all) {
        for (String address : this.selectionColumn.getSelections()) {
            GridNode node = Grid.instance.getNode(address);
            if (node.isServer()) continue;
            node.getNodeService().stop();
            if (all) continue;
            AuditManager.instance.audit("Grid::Nodes", "Active agent " + node.getAddress() + " is requested to stop.");
        }
        if (all) {
            AuditManager.instance.audit("Grid::Nodes", "All active agents are requested to restart.");
        }
        this.getSession().info((Serializable)((Object)"Stop command has been issued to those agents."));
    }

    private void onUnauthorizedNodes(List<GridNode> nodes, boolean all) {
        for (String address : this.selectionColumn.getSelections()) {
            GridNode node = Grid.instance.getNode(address);
            if (node.isServer()) continue;
            Token token = CacheManager.instance.getToken(node.getToken());
            if (token != null) {
                TokenManager.instance.delete((AbstractEntity)token);
            }
            AgentManager.instance.removeBuildAgent(node.getIp(), node.getPort());
            if (all) continue;
            AuditManager.instance.audit("Grid::Nodes", "Active node " + node.getAddress() + " was unauthorized.");
        }
        if (all) {
            AuditManager.instance.audit("Grid::Nodes", "All active nodes were unauthorized.");
        }
        this.getSession().info((Serializable)((Object)"Unauthorized command has been issued to those agents."));
    }

    private void onTerminateNodes(List<GridNode> nodes, boolean all) {
        boolean notEligiblesFound = false;
        for (GridNode node : nodes) {
            if (node.getCloudProfile() != null) {
                CloudProfile profile = CacheManager.instance.getCloudProfile(node.getCloudProfile().getId());
                if (profile == null) continue;
                profile.getNodeLauncher().terminateNode(node.getLaunchId());
                Token token = TokenManager.instance.getByValue(node.getToken());
                if (token != null) {
                    TokenManager.instance.delete((AbstractEntity)token);
                }
                AuditManager.instance.audit("Grid::Nodes", "Request to terminate node '" + node.getAddress() + "'.");
                continue;
            }
            notEligiblesFound = true;
        }
        if (notEligiblesFound) {
            this.getSession().warn((Serializable)((Object)"Some of the selected nodes can not be terminated as they are not launched by cloud profiles."));
        } else {
            this.getSession().info((Serializable)((Object)"Terminating requests have been sent to selected nodes."));
        }
    }

    private void onNodeAction(Action action) {
        ArrayList nodes;
        if (action.needSelect) {
            if (this.selectionColumn.getSelections().isEmpty()) {
                this.getSession().warn((Serializable)((Object)"Please select agents to restart."));
                return;
            }
            nodes = Lists.newArrayList();
            for (String each : this.selectionColumn.getSelections()) {
                GridNode node = Grid.instance.getNode(each);
                nodes.add(node);
            }
        } else {
            nodes = GridMock.getNodes();
        }
        switch (action) {
            case RESTART_SELECTED: {
                this.onRestartNodes(nodes, false);
                break;
            }
            case RESTART_ALL: {
                this.onRestartNodes(nodes, true);
                break;
            }
            case UNAUTHORIZED_SELECTED: {
                this.onUnauthorizedNodes(nodes, false);
                break;
            }
            case UNAUTHORIZED_ALL: {
                this.onUnauthorizedNodes(nodes, true);
                break;
            }
            case STOP_SELECTED: {
                this.onStopNodes(nodes, false);
                break;
            }
            case STOP_ALL: {
                this.onStopNodes(nodes, true);
                break;
            }
            case TERMINATE_SELECTED: {
                this.onTerminateNodes(nodes, false);
                break;
            }
            case TERMINATE_ALL: {
                this.onTerminateNodes(nodes, true);
            }
        }
        this.selectionColumn.getSelections().clear();
    }

    private List<IColumn<String>> getColumns() {
        ArrayList columns = Lists.newArrayList();
        if (SecurityHelper.isAdmin()) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<String>((IModel)Model.of((Serializable)((Object)"OS")), NodeDataProvider.NodeSort.OS.name()){

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, IModel<String> rowModel) {
                Optional<GridNode> node = GridMock.getNode((String)rowModel.getObject());
                if (node.isPresent()) {
                    NodeTraits trait = NodeTraits.getFromNodeData(node);
                    Fragment frag = new Fragment(componentId, "osfrag", (MarkupContainer)ActiveNodesTablePanel.this);
                    WebMarkupContainer icon = new WebMarkupContainer("icon");
                    icon.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)("icon-os-" + trait.getOsType().name().toLowerCase())))});
                    frag.add(new Component[]{icon});
                    cellItem.add(new Component[]{frag});
                } else {
                    cellItem.add(new Component[]{new WebMarkupContainer(componentId).setVisibilityAllowed(false)});
                }
            }
        });
        columns.add(new AbstractColumn<String>((IModel)Model.of((Serializable)((Object)"Node")), NodeDataProvider.NodeSort.NAME.name()){

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, IModel<String> rowModel) {
                Optional<GridNode> node = GridMock.getNode((String)rowModel.getObject());
                if (node.isPresent()) {
                    Fragment frag = new Fragment(componentId, "nodefrag", (MarkupContainer)ActiveNodesTablePanel.this);
                    frag.add(new Component[]{new BookmarkablePageLink("link", GridPage.class, GridPage.params4((String[])new String[]{"active_nodes", ((GridNode)node.get()).getAddress()})).add(new Component[]{new Label("label", ((GridNode)node.get()).getAddress()).setEscapeModelStrings(true)})});
                    frag.add(new Component[]{new WebMarkupContainer("ssl").setVisibilityAllowed(((GridNode)node.get()).isOverSSL())});
                    cellItem.add(new Component[]{frag});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, (String)rowModel.getObject() + " (offline)")});
                }
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<String>((IModel)new Model((Serializable)((Object)"IP"))){

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, IModel<String> rowModel) {
                Optional<GridNode> node = GridMock.getNode((String)rowModel.getObject());
                if (node.isPresent()) {
                    cellItem.add(new Component[]{new Label(componentId, ((GridNode)node.get()).getIp())});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "")});
                }
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<String>((IModel)new Model((Serializable)((Object)"Offline Alert"))){

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, final IModel<String> rowModel) {
                if (((String)rowModel.getObject()).equals(Grid.instance.getLocalNode().getAddress())) {
                    cellItem.add(new Component[]{new Label(componentId, "<i>N/A</i>").setEscapeModelStrings(false)});
                } else if (SecurityHelper.isAdmin()) {
                    Fragment fragment = new Fragment(componentId, "offlineAlertFrag", (MarkupContainer)ActiveNodesTablePanel.this);
                    cellItem.add(new Component[]{fragment});
                    fragment.add(new Component[]{new AjaxCheckBox("checkbox", (IModel)new IModel<Boolean>(){

                        public void detach() {
                        }

                        public Boolean getObject() {
                            Token token = CacheManager.instance.getTokenByAddress((String)rowModel.getObject());
                            if (token != null) {
                                return token.isOfflineAlert();
                            }
                            return false;
                        }

                        public void setObject(Boolean object) {
                            Token token = CacheManager.instance.getTokenByAddress((String)rowModel.getObject());
                            if (token != null) {
                                token = (Token)TokenManager.instance.load(token.getId());
                                token.setOfflineAlert(object.booleanValue());
                                TokenManager.instance.save((AbstractEntity)token);
                            }
                        }
                    }){

                        protected void onUpdate(AjaxRequestTarget target) {
                        }

                        protected boolean wantOnSelectionChangedNotifications() {
                            return true;
                        }
                    }});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, (IModel)new AbstractReadOnlyModel<String>(){

                        public String getObject() {
                            Token token = CacheManager.instance.getTokenByAddress((String)rowModel.getObject());
                            if (token != null) {
                                return token.isOfflineAlert() ? "Yes" : "No";
                            }
                            return "<i>N/A</i>";
                        }
                    }).setEscapeModelStrings(false)});
                }
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<String>((IModel)new Model((Serializable)((Object)"Cloud Profile")), NodeDataProvider.NodeSort.CLOUDPROFILE.name()){

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, IModel<String> rowModel) {
                Optional<GridNode> node = GridMock.getNode((String)rowModel.getObject());
                if (node.isPresent()) {
                    if (((GridNode)node.get()).getCloudProfile() != null) {
                        final Long profileId = ((GridNode)node.get()).getCloudProfile().getId();
                        cellItem.add(new Component[]{new LinkPanel(componentId, ((GridNode)node.get()).getCloudProfile().getName(), true){

                            protected AbstractLink createLink(String id) {
                                return new BookmarkablePageLink(id, GridPage.class, GridPage.params4Profile((Long)profileId));
                            }
                        }});
                    } else {
                        cellItem.add(new Component[]{new Label(componentId, "")});
                    }
                } else {
                    cellItem.add(new Component[]{new WebMarkupContainer(componentId).setVisibilityAllowed(false)});
                }
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<String>((IModel)new Model((Serializable)((Object)"Launch Id"))){

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, IModel<String> rowModel) {
                Optional<GridNode> node = GridMock.getNode((String)rowModel.getObject());
                if (node.isPresent()) {
                    if (((GridNode)node.get()).getLaunchId() != null) {
                        cellItem.add(new Component[]{new Label(componentId, ((GridNode)node.get()).getLaunchId())});
                    } else {
                        cellItem.add(new Component[]{new Label(componentId, "")});
                    }
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "")});
                }
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<String>((IModel)Model.of((Serializable)((Object)"Benchmark")), NodeDataProvider.NodeSort.BENCHMARK.name()){

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, IModel<String> rowModel) {
                Optional<GridNode> node = GridMock.getNode((String)rowModel.getObject());
                if (node.isPresent()) {
                    cellItem.add(new Component[]{new Label(componentId, String.valueOf(((GridNode)node.get()).getBenchmark()))});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "")});
                }
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<String>((IModel)new Model((Serializable)((Object)"#Steps"))){

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, IModel<String> rowModel) {
                Optional<GridNode> node = GridMock.getNode((String)rowModel.getObject());
                if (node.isPresent()) {
                    int count = 0;
                    for (BuildRequest request : ActiveNodesTablePanel.this.getBuildRequests()) {
                        for (StepRuntime runtime : request.getBuild().getStepRuntimes().values()) {
                            if (runtime.getStatus() != StepRuntime.Status.RUNNING || !runtime.getNodeAddress().equals(((GridNode)node.get()).getAddress())) continue;
                            ++count;
                        }
                    }
                    cellItem.add(new Component[]{new BookmarkableTextLink(componentId, String.valueOf(count), GridPage.class, GridPage.params4((String)((GridNode)node.get()).getAddress(), (String)"steps")){

                        protected void onComponentTag(ComponentTag tag) {
                            tag.setName("a");
                            super.onComponentTag(tag);
                        }
                    }});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "")});
                }
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new AbstractColumn<String>((IModel)Model.of((Serializable)((Object)"CPU")), NodeDataProvider.NodeSort.CPU.name()){

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, IModel<String> rowModel) {
                Optional<GridNode> node = GridMock.getNode((String)rowModel.getObject());
                if (node.isPresent()) {
                    NodeMeasurementReport snapshot = (NodeMeasurementReport)LatestReportCache.INSTANCE.getUnchecked((Object)((GridNode)node.get()).getAddress());
                    double usage = snapshot.getCpuUsage();
                    cellItem.add(new Component[]{new Label(componentId, DataTypes.PERCENT.asString((Object)usage, "#%"))});
                    cellItem.add(new Behavior[]{AttributeAppender.append((String)"style", (Serializable)((Object)("background: " + ColorUtils.getCssHeatColor((int)((int)(usage * 100.0))) + (usage > 0.8 ? "; color: white;" : ""))))});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "")});
                }
            }
        });
        columns.add(new AbstractColumn<String>((IModel)Model.of((Serializable)((Object)"JVM Memory")), NodeDataProvider.NodeSort.MEMORY.name()){

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, IModel<String> rowModel) {
                Optional<GridNode> node = GridMock.getNode((String)rowModel.getObject());
                if (node.isPresent()) {
                    NodeMeasurementReport snapshot = (NodeMeasurementReport)LatestReportCache.INSTANCE.getUnchecked((Object)((GridNode)node.get()).getAddress());
                    double usage = snapshot.getJvmMemoryUsage();
                    cellItem.add(new Component[]{new Label(componentId, DataTypes.PERCENT.asString((Object)usage, "#%"))});
                    cellItem.add(new Behavior[]{AttributeAppender.append((String)"style", (Serializable)((Object)("background: " + ColorUtils.getCssHeatColor((int)((int)(usage * 100.0))) + (usage > 0.8 ? "; color: white;" : ""))))});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "")});
                }
            }
        });
        return columns;
    }

    public void onDetach() {
        if (this.buildRequestsModel != null) {
            this.buildRequestsModel.detach();
        }
        if (this.userFiltersModel != null) {
            this.userFiltersModel.detach();
        }
        if (this.selectedName != null) {
            this.selectedName.detach();
        }
        super.onDetach();
    }

    public String getAjaxIndicatorMarkupId() {
        return "global-ajax-indicator";
    }

    class UpdateAttributeForm
    extends Form<Void> {
        AttributeAction action;
        String attrName;
        String attrValue;

        public UpdateAttributeForm(String id) {
            super(id);
            this.action = AttributeAction.ADD;
        }

        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{new FeedbackPanel("feedback", (IFeedbackMessageFilter)new ContainerFeedbackMessageFilter((MarkupContainer)this))});
            this.add(new Component[]{new DropDownChoice("attrAction", (IModel)new PropertyModel((Object)this, "action"), (List)Lists.newArrayList((Object[])AttributeAction.values()))});
            this.add(new Component[]{new TextField("attrName", (IModel)new PropertyModel((Object)this, "attrName"))});
            this.add(new Component[]{new TextField("attrValue", (IModel)new PropertyModel((Object)this, "attrValue"))});
            AjaxButton btn = new AjaxButton("submit", this){

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    Set nodes = ActiveNodesTablePanel.this.selectionColumn.getSelections();
                    if (nodes.isEmpty()) {
                        UpdateAttributeForm.this.error((Serializable)((Object)"Please select the nodes you want first"));
                        target.add(new Component[]{form});
                        return;
                    }
                    for (String each : nodes) {
                        GridNode fresh = Grid.instance.getNode(each);
                        Map attributes = fresh.getUserAttributes();
                        if (UpdateAttributeForm.this.action == AttributeAction.REMOVE) {
                            attributes.remove(UpdateAttributeForm.this.attrName);
                        } else {
                            attributes.put(UpdateAttributeForm.this.attrName, UpdateAttributeForm.this.attrValue);
                        }
                        fresh.setUserAttributes(attributes, true);
                    }
                    String s = UpdateAttributeForm.this.action == AttributeAction.ADD ? "Attribute " + UpdateAttributeForm.this.attrName + " has been added to " + nodes.size() + " nodes" : (UpdateAttributeForm.this.action == AttributeAction.UPDATE ? "Attribute " + UpdateAttributeForm.this.attrName + " has been updated to " + nodes.size() + " nodes" : "Attribute " + UpdateAttributeForm.this.attrName + " has been removed from " + nodes.size() + " nodes");
                    target.add(new Component[]{form});
                    this.getSession().info((Serializable)((Object)s));
                }
            };
            this.add(new Component[]{btn});
            this.setDefaultButton((IFormSubmittingComponent)btn);
        }
    }

    static enum AttributeAction {
        ADD,
        UPDATE,
        REMOVE;

    }

    class ActionMenuItem
    extends MenuItem {
        final Action action;

        ActionMenuItem(Action action) {
            this.action = action;
        }

        public Component render(String componentId) {
            final boolean enabled = !this.action.needSelect || this.action.needSelect && ActiveNodesTablePanel.this.selectionColumn.getSelections().size() > 0;
            Fragment frag = new Fragment(componentId, "actionlinkfrag", (MarkupContainer)ActiveNodesTablePanel.this);
            Link<Void> link = new Link<Void>("link"){

                public void onClick() {
                    ActiveNodesTablePanel.this.onNodeAction(ActionMenuItem.this.action);
                }
            };
            link.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                public String getObject() {
                    return enabled ? "" : "disabled";
                }
            })});
            link.setEnabled(enabled);
            if (enabled) {
                link.add(new Behavior[]{new ConfirmBehavior(this.getConfirmMessage())});
            }
            link.add(new Component[]{new Label("name", this.action.displayName)});
            link.add(new Component[]{new WebMarkupContainer("icon"){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    String current = tag.getAttribute("class");
                    tag.put("class", (CharSequence)(current + " " + ActionMenuItem.this.action.iconClass));
                }
            }});
            frag.add(new Component[]{link});
            return frag;
        }

        private String getConfirmMessage() {
            switch (this.action) {
                case RESTART_SELECTED: 
                case RESTART_ALL: 
                case UNAUTHORIZED_SELECTED: 
                case UNAUTHORIZED_ALL: 
                case STOP_SELECTED: 
                case STOP_ALL: {
                    return "Do you really want to " + this.action.displayName.toLowerCase() + " active agents?";
                }
                case TERMINATE_SELECTED: {
                    return "This will forcibly terminate selected nodes launched by cloud profiles even if they are still being used by builds. Do you really want to continue?";
                }
                case TERMINATE_ALL: {
                    return "This will forcibly terminate all nodes launched by cloud profiles even if they are still being used by builds. Do you really want to continue?";
                }
            }
            throw new IllegalArgumentException("Unknown action " + (Object)((Object)this.action));
        }
    }

    static enum Action {
        RESTART_SELECTED("Restart Selected", true, "fa-refresh"),
        UNAUTHORIZED_SELECTED("Unauthorize Selected", true, ""),
        STOP_SELECTED("Stop Selected", true, "fa-stop"),
        TERMINATE_SELECTED("Terminate Selected", true, "fa-power-off"),
        RESTART_ALL("Restart All", false, "fa-refresh"),
        UNAUTHORIZED_ALL("Unauthorize All", false, ""),
        STOP_ALL("Stop All", false, "fa-stop"),
        TERMINATE_ALL("Terminate All", false, "fa-power-off");

        final String displayName;
        final boolean needSelect;
        final String iconClass;

        private Action(String displayName, boolean needSelect, String iconClass) {
            this.displayName = displayName;
            this.needSelect = needSelect;
            this.iconClass = iconClass;
        }
    }

    private class FilterLink
    extends AjaxLink<String> {
        public FilterLink(String id, IModel<String> model) {
            super(id, model);
        }

        public void onClick(AjaxRequestTarget target) {
            String name = (String)this.getDefaultModelObject();
            this.send((IEventSink)ActiveNodesTablePanel.this, Broadcast.EXACT, new NodeCriteriaChanged(target, (NodeCriteria)ActiveNodesTablePanel.this.getUserFilters().get(name), name));
        }

        protected void onConfigure() {
            super.onConfigure();
            this.setEnabled(!Objects.equal((Object)this.getDefaultModelObject(), (Object)ActiveNodesTablePanel.this.selectedName.getObject()));
        }
    }

    private class AdvancedSearchNavToolbar
    extends SearchNavToolbar {
        public AdvancedSearchNavToolbar(DataTable<?> table) {
            super(table);
        }

        protected Component createAdvancedLink(String id) {
            return new AjaxLink<Void>(id){

                public void onClick(AjaxRequestTarget target) {
                    Dialog dialog = new Dialog("Advanced Search"){
                        private static final long serialVersionUID = 1L;

                        protected Component render(String componentId) {
                            return new NodeFilterFormPanel(componentId, ActiveNodesTablePanel.this, ActiveNodesTablePanel.this.criteria, (String)ActiveNodesTablePanel.this.selectedName.getObject());
                        }
                    };
                    dialog.dialogClass("search-dlg").width(600).open(target);
                }
            };
        }
    }
}

