/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.measurement.core.web.data.DataPoint;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.util.TimeUtils;
import com.pmease.quickbuild.web.chart.ColorUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeries
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TimeSeries.class);
    private final Key key;
    private final List<DataPoint> points = Lists.newArrayList();
    @JsonIgnore
    private final DataType dataType;
    private Double maxValue = Double.NaN;
    private Double minValue = Double.NaN;
    private final long beginTime;
    private final long endTime;
    private final long interval;
    private String displayName;
    private boolean enabled = true;

    public TimeSeries(Key key, DataType dataType, long beginTime, long endTime, long interval) {
        this.key = key;
        this.dataType = dataType;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.interval = interval;
        String metricName = key.getName();
        MetricMeta meta = MetricMetaRegistry.instance.getMeta(metricName);
        String scope = meta.getScopeValue(metricName);
        this.displayName = Strings.isNullOrEmpty((String)scope) ? meta.getDisplayName() : meta.getDisplayName() + " " + scope;
    }

    public static TimeSeriesBuilder builder(Key key) {
        return new TimeSeriesBuilder(key);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public int size() {
        return this.points.size();
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Key getKey() {
        return this.key;
    }

    public long getInterval() {
        return this.interval;
    }

    public void addPoint(DataPoint point) {
        if (point == null) {
            return;
        }
        this.points.add(point);
        if (point.getValue().isNaN()) {
            return;
        }
        this.maxValue = Double.isNaN(this.maxValue) ? point.getValue() : Double.valueOf(Math.max(this.maxValue, point.getValue()));
        this.minValue = Double.isNaN(this.minValue) ? point.getValue() : Double.valueOf(Math.min(this.minValue, point.getValue()));
    }

    public String getCssColor(DataPoint point) {
        Double value = point.getValue();
        if (value.isNaN() || value.isInfinite()) {
            value = 0.0;
        }
        return ColorUtils.getCssHeatColor((int)((int)(value * 100.0)));
    }

    public List<DataPoint> getPoints() {
        return this.points;
    }

    public DataPoint getPoint(int index) {
        if (index < this.points.size()) {
            return this.points.get(index);
        }
        return null;
    }

    public String formatPoint(DataPoint point) {
        if (point.getValue().isNaN() || point.getValue().isInfinite()) {
            return "";
        }
        return this.dataType.asString((Object)point.getValue());
    }

    @JsonIgnore
    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public XYDataset toXYSeries() {
        XYSeries series = new XYSeries((Comparable)((Object)this.key.toString()));
        for (DataPoint each : this.points) {
            series.add((double)each.getTimestamp(), (Number)each.getValue());
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    public CategoryTableXYDataset toCategoryTableXYDataset() {
        CategoryTableXYDataset dataset = new CategoryTableXYDataset();
        for (DataPoint each : this.points) {
            dataset.add((double)each.getTimestamp(), each.getValue().doubleValue(), this.key.toString());
        }
        return dataset;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void removeEmptyPoints() {
        Iterator<DataPoint> it = this.points.iterator();
        while (it.hasNext()) {
            DataPoint p = it.next();
            if (p.isValid()) continue;
            it.remove();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.key);
        for (DataPoint each : this.points) {
            sb.append("\n").append(each);
        }
        return sb.toString();
    }

    public static class TimeSeriesBuilder {
        private final Key key;
        private long beginTime;
        private long endTime;
        private long interval;
        private boolean allowEmptyPoint = false;
        private boolean upperAlign;
        private List<MeasurementData> measurements;

        public TimeSeriesBuilder(Key key) {
            this.key = key;
        }

        public TimeSeriesBuilder beginTime(long beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public TimeSeriesBuilder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public TimeSeriesBuilder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public TimeSeriesBuilder measurements(List<MeasurementData> measurements) {
            Preconditions.checkArgument((measurements != null ? 1 : 0) != 0);
            this.measurements = measurements;
            return this;
        }

        public TimeSeriesBuilder allowEmptyPoint(boolean b) {
            this.allowEmptyPoint = b;
            return this;
        }

        public TimeSeriesBuilder upperAlign(boolean upperAlign) {
            this.upperAlign = upperAlign;
            return this;
        }

        public TimeSeries build() {
            String metricName;
            MetricMeta meta;
            Preconditions.checkArgument((this.key != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.beginTime > 0L && this.endTime > 0L && this.interval > 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((this.beginTime <= this.endTime ? 1 : 0) != 0);
            if (logger.isTraceEnabled()) {
                MeasurementData first = (MeasurementData)Iterables.getFirst(this.measurements, null);
                MeasurementData last = (MeasurementData)Iterables.getLast(this.measurements, null);
                logger.trace("Building timeseries, original data time range [" + (first == null ? "n/a" : new Date(first.getTimestamp())) + ", " + (last == null ? "n/a" : new Date(last.getTimestamp())) + "], expected time range [" + new Date(this.beginTime) + ", " + new Date(this.endTime) + "]");
            }
            if ((meta = MetricMetaRegistry.instance.getMeta(metricName = this.key.getName())) == null) {
                throw new IllegalStateException("Metric name " + metricName + " not found");
            }
            String title = meta.getDisplayName();
            if (meta.isNeedScope()) {
                title = meta.getScope() == null ? title : meta.getScope();
            }
            TimeSeries series = new TimeSeries(this.key, meta.getDataType(), this.beginTime, this.endTime, this.interval);
            series.setDisplayName(title);
            long start = TimeUtils.roundDownTime((long)this.beginTime, (long)this.interval);
            int idx = 0;
            while (start + this.interval < this.endTime) {
                long end = start + this.interval;
                MeasurementData found = null;
                while (found == null && idx < this.measurements.size()) {
                    MeasurementData data = this.measurements.get(idx);
                    if (data.getTimestamp() >= start && data.getTimestamp() < end) {
                        found = data;
                    } else if (data.getTimestamp() >= end) break;
                    ++idx;
                }
                Double value = Double.NaN;
                if (found != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Add DataPoint, original time: " + new Date(found.getTimestamp()) + ", to range [" + new Date(start) + ", " + new Date(end) + "]");
                    }
                    value = found.getValue();
                }
                if (!value.isNaN() || this.allowEmptyPoint) {
                    series.addPoint(new DataPoint(value, this.upperAlign ? end : start));
                }
                start = end;
            }
            return series;
        }
    }

    public static class Key
    implements Serializable,
    Comparable<Key> {
        private static final long serialVersionUID = 1L;
        private final String source;
        private final String name;

        Key(String nodeAddress, String metricName) {
            this.source = nodeAddress;
            this.name = metricName;
        }

        public static Key of(String node, String metric) {
            return new Key(node, metric);
        }

        public String getSource() {
            return this.source;
        }

        public String getName() {
            return this.name;
        }

        @JsonIgnore
        public DataType getDataType() {
            MetricMeta meta = MetricMetaRegistry.instance.getMeta(this.name);
            Preconditions.checkState((meta != null ? 1 : 0) != 0, (Object)("Name [" + this.name + "] should be a valid metric name"));
            return meta.getDataType();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key rhs = (Key)other;
            return Objects.equal((Object)this.source, (Object)rhs.source) && Objects.equal((Object)this.name, (Object)rhs.name);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.source, this.name});
        }

        public String toString() {
            return "[" + this.source + ":" + this.name + "]";
        }

        @Override
        public int compareTo(Key o) {
            MetricMeta m2;
            int r = this.source.compareTo(o.source);
            if (r != 0) {
                return r;
            }
            MetricMeta m1 = MetricMetaRegistry.instance.getMeta(this.name);
            r = m1.compareTo(m2 = MetricMetaRegistry.instance.getMeta(o.name));
            if (r == 0) {
                return this.name.compareTo(o.name);
            }
            return r;
        }
    }
}

