/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.data;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricCategory;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricType;
import com.pmease.quickbuild.plugin.measurement.core.web.MeasurementHelper;
import com.pmease.quickbuild.plugin.measurement.core.web.MetricsChartSetting;
import com.pmease.quickbuild.plugin.measurement.core.web.chart.AreaChartBuilder;
import com.pmease.quickbuild.plugin.measurement.core.web.chart.LineChartBuilder;
import com.pmease.quickbuild.plugin.measurement.core.web.data.DataPoint;
import com.pmease.quickbuild.plugin.measurement.core.web.data.TimeSeries;
import com.pmease.quickbuild.plugin.measurement.core.web.data.XYChartData;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.util.TimeUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.jfree.chart.JFreeChart;

public class MetricsChartData
implements XYChartData {
    private static final long serialVersionUID = 1L;
    private final long beginTime;
    private final long endTime;
    private final long interval;
    private final Map<TimeSeries.Key, TimeSeries> dataSeries = Maps.newTreeMap();

    public static Builder builder() {
        return new Builder();
    }

    public MetricsChartData(Range<Long> range, long interval) {
        this((Long)range.lowerEndpoint(), (Long)range.upperEndpoint(), interval);
    }

    public MetricsChartData(long beginTime, long endTime, long interval) {
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.interval = interval;
    }

    public void addMeasurements(TimeSeries.Key key, List<MeasurementData> measurements) {
        this.addMeasurements(key, measurements, false);
    }

    public void addMeasurements(TimeSeries.Key key, List<MeasurementData> measurements, boolean allowEmpty) {
        this.addMeasurements(key, measurements, allowEmpty, false);
    }

    public void addMeasurements(TimeSeries.Key key, List<MeasurementData> measurements, boolean allowEmpty, boolean upperAlign) {
        TimeSeries series = TimeSeries.builder(key).beginTime(this.beginTime).endTime(this.endTime).interval(this.interval).measurements(measurements).allowEmptyPoint(allowEmpty).upperAlign(upperAlign).build();
        this.addSeries(series);
    }

    public void addSeries(TimeSeries series) {
        TimeSeries.Key key = series.getKey();
        this.dataSeries.put(key, series);
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getInterval() {
        return this.interval;
    }

    @Override
    public int getSeriesCount() {
        return this.getKeys().size();
    }

    @Override
    public Double getStep() {
        long period = this.getEndTime() - this.getBeginTime();
        if (period < 0x6DDD00L) {
            return 300000.0;
        }
        if (period < 14400000L) {
            return 900000.0;
        }
        if (period < 86400000L) {
            return 1800000.0;
        }
        if (period <= 172800000L) {
            return 3600000.0;
        }
        if (period <= 691200000L) {
            return 8.64E7;
        }
        return 8.64E7;
    }

    public Set<TimeSeries.Key> getKeys() {
        return this.dataSeries.keySet();
    }

    @Override
    public TimeSeries getSeries(int idx) {
        return this.getAllSeries()[idx];
    }

    @Override
    public TimeSeries getSeries(TimeSeries.Key key) {
        return this.dataSeries.get(key);
    }

    public boolean hasSeries(TimeSeries.Key key) {
        if (this.dataSeries.containsKey(key)) {
            return true;
        }
        for (TimeSeries.Key each : this.dataSeries.keySet()) {
            if (!Objects.equal((Object)each.getSource(), (Object)key.getSource()) || !each.getName().startsWith(key.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeSeries(TimeSeries.Key key) {
        this.dataSeries.remove(key);
    }

    public Map<DataType, Range<Double>> getTypeRange() {
        HashMap typeRanges = Maps.newHashMap();
        for (TimeSeries series : this.dataSeries.values()) {
            if (!series.isEnabled()) continue;
            if (!typeRanges.containsKey(series.getDataType())) {
                typeRanges.put(series.getDataType(), Range.closed((Comparable)Double.valueOf(series.getMinValue()), (Comparable)Double.valueOf(series.getMaxValue())));
                continue;
            }
            Range range = (Range)typeRanges.get(series.getDataType());
            double min = ((Double)range.lowerEndpoint()).isNaN() ? 0.0 : (Double)range.lowerEndpoint();
            double max = ((Double)range.upperEndpoint()).isNaN() ? 0.0 : (Double)range.upperEndpoint();
            typeRanges.put(series.getDataType(), Range.closed((Comparable)Double.valueOf(Math.min(min, series.getMinValue())), (Comparable)Double.valueOf(Math.max(max, series.getMaxValue()))));
        }
        return typeRanges;
    }

    @Override
    public Range<Double> getSeriesRange(int idx) {
        TimeSeries series = this.getSeries(idx);
        return this.getTypeRange().get(series.getDataType());
    }

    @Override
    public Range<Double> getXAxisRange() {
        return Range.closed((Comparable)Double.valueOf((double)this.beginTime - (double)this.interval * 0.05), (Comparable)Double.valueOf((double)this.endTime + (double)this.interval * 0.05));
    }

    @Override
    public String domainLabel(double value) {
        long period = this.getEndTime() - this.getBeginTime();
        Date date = new Date((long)value);
        if (period < 86400000L) {
            return DataTypes.DATE.asString((Object)date, "HH:mm");
        }
        if (period <= 172800000L) {
            return DataTypes.DATE.asString((Object)date, "HH");
        }
        if (period <= 691200000L) {
            return DataTypes.DATE.asString((Object)date, "EEE MM/dd");
        }
        return DataTypes.DATE.asString((Object)date, "dd");
    }

    public JFreeChart buildChart(MetricsChartSetting.ChartType chartType) {
        switch (chartType) {
            case LINE: {
                return new LineChartBuilder(this).build();
            }
            case AREA: {
                return new AreaChartBuilder(this).build();
            }
        }
        throw new IllegalArgumentException("Chart type " + (Object)((Object)chartType) + " doesn't support.");
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("beginTime", (Object)new Date(this.beginTime)).add("endTime", (Object)new Date(this.endTime)).add("interval", this.interval).add("Series", (Object)this.getAllSeries()).toString();
    }

    @Override
    public String getTooltip(int seriesIdx, int item) {
        StringBuffer sb = new StringBuffer();
        TimeSeries series = this.getSeries(seriesIdx);
        if (item >= series.size()) {
            return null;
        }
        DataPoint point = series.getPoint(item);
        long time = point.getTimestamp();
        sb.append("<p class='light-text'>").append(DataTypes.DATE.asString((Object)time, "EEE, MMM dd, HH:mm")).append("</p>");
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            series = this.getSeries(i);
            if (!series.isEnabled()) continue;
            sb.append("<div class='chart-tooltip tooltip-").append(i);
            if (i == 0) {
                sb.append(" first");
            }
            if (i + 1 == this.getSeriesCount()) {
                sb.append(" last");
            }
            sb.append("'>");
            sb.append("<p>");
            DataPoint dp = series.getPoint(item);
            sb.append("<span class='m-legend inline m-legend-" + (i + 1)).append("'></span>");
            sb.append("<span class='light-text'>").append(series.getDisplayName()).append("</span>: ");
            if (dp == null) {
                sb.append("<strong>N/A</strong>");
            } else {
                sb.append("<strong>").append(series.getDataType().asString((Object)dp.getValue())).append("</strong>");
            }
            sb.append("</p>");
            sb.append("</div>");
        }
        return sb.toString();
    }

    @Override
    public TimeSeries[] getAllSeries() {
        return (TimeSeries[])Iterables.toArray(this.dataSeries.values(), TimeSeries.class);
    }

    @Override
    public Range<Long> getTimeRange() {
        return Range.closed((Comparable)Long.valueOf(this.beginTime), (Comparable)Long.valueOf(this.endTime));
    }

    public static class Builder {
        private List<String> metricNames = Lists.newArrayList();
        private List<String> nodes = Lists.newArrayList();
        private List<String> metricGroups = Lists.newArrayList();
        private SearchCriteria.Builder criteriaBuilder = SearchCriteria.builder();
        private long beginTime;
        private long endTime;
        private long interval;
        private MeasurementDataManager.TableType tableType = MeasurementDataManager.TableType.RAW;
        private boolean allowEmpty = true;
        private boolean upperAlign;

        public Builder beginTime(long beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder timespan(TimeSpan timespan) {
            this.tableType = MeasurementHelper.timespanToTableType(timespan, false);
            this.interval = this.tableType.getInterval();
            Range period = timespan.range();
            this.beginTime = TimeUtils.roundDownTime((long)((Long)period.lowerEndpoint()), (long)this.interval);
            this.endTime = (Long)period.upperEndpoint();
            this.upperAlign = timespan.isUpperAlign();
            return this;
        }

        public Builder allowEmptyValue(boolean allowEmptyValue) {
            this.allowEmpty = allowEmptyValue;
            return this;
        }

        public Builder tableType(MeasurementDataManager.TableType tableType) {
            this.tableType = tableType;
            return this;
        }

        public Builder addMetricGroup(MetricCategory group) {
            if (group == null) {
                return this;
            }
            return this.addMetricGroup(group.getId());
        }

        public Builder addMetricGroup(String groupId) {
            if (groupId == null) {
                return this;
            }
            this.metricGroups.add(groupId);
            return this;
        }

        public Builder addCriterion(Criterion crit) {
            this.criteriaBuilder.add(crit);
            return this;
        }

        public Builder addOrder(Order order) {
            this.criteriaBuilder.add(order);
            return this;
        }

        public Builder addSource(String source) {
            if (source == null) {
                return this;
            }
            this.nodes.add(source);
            return this;
        }

        public Builder addMetric(String metricName) {
            this.criteriaBuilder.add((Criterion)Restrictions.eq((String)"metricName", (Object)metricName));
            return this;
        }

        public List<MeasurementData> find() {
            SimpleExpression e;
            LogicalExpression or;
            SimpleExpression pre;
            MeasurementDataManager dataManager = MeasurementDataManager.instance;
            if (this.metricNames.size() > 1) {
                pre = null;
                or = null;
                for (String each : this.metricNames) {
                    MetricMeta meta = MetricMetaRegistry.instance.getMeta(each);
                    String v = meta.getScopeValue(each);
                    e = meta.isNeedScope() && Strings.isNullOrEmpty((String)v) ? Restrictions.like((String)"metricName", (String)(each + "."), (MatchMode)MatchMode.START) : Restrictions.eq((String)"metricName", (Object)each);
                    if (pre != null) {
                        or = Restrictions.or((Criterion)pre, (Criterion)e);
                    }
                    pre = e;
                }
                if (or == null) {
                    this.criteriaBuilder.add(pre);
                } else {
                    this.criteriaBuilder.add(or);
                }
            } else if (this.metricNames.size() == 1) {
                String name = this.metricNames.get(0);
                MetricMeta meta = MetricMetaRegistry.instance.getMeta(name);
                String v = meta.getScopeValue(name);
                SimpleExpression e2 = meta.isNeedScope() && Strings.isNullOrEmpty((String)v) ? Restrictions.like((String)"metricName", (String)(name + "."), (MatchMode)MatchMode.START) : Restrictions.eq((String)"metricName", (Object)name);
                this.criteriaBuilder.add((Criterion)e2);
            }
            if (!this.metricGroups.isEmpty()) {
                pre = null;
                or = null;
                for (String group : this.metricGroups) {
                    e = Restrictions.like((String)"metricName", (String)(group + "."), (MatchMode)MatchMode.START);
                    if (pre != null) {
                        or = Restrictions.or((Criterion)pre, (Criterion)e);
                    }
                    pre = e;
                }
                if (or == null) {
                    Preconditions.checkArgument((pre != null ? 1 : 0) != 0);
                    this.criteriaBuilder.add(pre);
                } else {
                    this.criteriaBuilder.add(or);
                }
            }
            if (this.nodes.size() > 1) {
                this.criteriaBuilder.add(Restrictions.in((String)"source", this.nodes));
            } else if (this.nodes.size() == 1) {
                this.criteriaBuilder.add((Criterion)Restrictions.eq((String)"source", (Object)this.nodes.get(0)));
            }
            return dataManager.find(this.tableType, Range.closedOpen((Comparable)Long.valueOf(this.beginTime), (Comparable)Long.valueOf(this.endTime)), this.criteriaBuilder.build());
        }

        public Map<String, MetricsChartData> build(MetricType sourceType) {
            List<MeasurementData> measurements = this.find();
            HashMap metrics = Maps.newHashMap();
            HashSet keys = Sets.newHashSet();
            for (MeasurementData each : measurements) {
                List<MeasurementData> list;
                String metricName = each.getMetricName();
                MetricMeta meta = MetricMetaRegistry.instance.getMeta(metricName);
                if (!sourceType.includes(meta.getMetricType())) continue;
                keys.add(meta.getCategory().getId());
                TimeSeries.Key metricKey = TimeSeries.Key.of(each.getSource(), each.getMetricName());
                if (metrics.containsKey(metricKey)) {
                    list = (List)metrics.get(metricKey);
                } else {
                    list = Lists.newArrayList();
                    metrics.put(metricKey, list);
                }
                list.add(each);
            }
            HashMap result = Maps.newHashMap();
            for (String id : keys) {
                MetricsChartData chartData = (MetricsChartData)result.get(id);
                if (chartData == null) {
                    chartData = new MetricsChartData(this.beginTime, this.endTime, this.interval);
                    result.put(id, chartData);
                }
                MetricCategory group = MetricMetaRegistry.instance.getCategory(id);
                for (Map.Entry entry : metrics.entrySet()) {
                    TimeSeries.Key key = (TimeSeries.Key)entry.getKey();
                    String metricName = key.getName();
                    if (!group.contains(metricName)) continue;
                    chartData.addMeasurements(key, (List)entry.getValue(), this.allowEmpty, this.upperAlign);
                }
            }
            return result;
        }
    }
}

