/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.data;

import com.pmease.quickbuild.model.MeasurementData;
import java.io.Serializable;
import java.util.Date;

public class DataPoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Double value;
    private final long timestamp;

    public DataPoint(long timestamp) {
        this.timestamp = timestamp;
        this.value = Double.NaN;
    }

    public DataPoint(MeasurementData measurement) {
        this.value = measurement.getValue();
        this.timestamp = measurement.getTimestamp();
    }

    public DataPoint(Double value, long timestamp) {
        this.value = value;
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public boolean isValid() {
        return !this.value.isInfinite() && !this.value.isNaN();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataPoint) {
            DataPoint val = (DataPoint)obj;
            return this.getTimestamp() == val.getTimestamp() && this.getValue() == val.getValue();
        }
        return false;
    }

    public String toString() {
        return new Date(this.timestamp) + ": " + (this.value.isNaN() ? "NaN" : this.value);
    }
}

