/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component.util;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;

public class ParameterUtils {
    public static StringValue getQueryParameterValue(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        return parameters.getParameterValue(name);
    }

    public static List<StringValue> getQueryParameterValues(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        return parameters.getParameterValues(name);
    }

    public static PageParameters newPageParams(String key, Object value) {
        PageParameters params = new PageParameters();
        params.add(key, (Object)value.toString());
        return params;
    }

    public static PageParameters newPageParams(String key1, String value1, String key2, String value2) {
        return ParameterUtils.newPageParams((Map<String, String>)ImmutableMap.of((Object)key1, (Object)value1, (Object)key2, (Object)value2));
    }

    public static PageParameters newPageParams(String k1, String v1, String k2, String v2, String k3, String v3) {
        return ParameterUtils.newPageParams((Map<String, String>)ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3));
    }

    public static PageParameters newPageParams(Map<String, String> map) {
        PageParameters params = new PageParameters();
        for (Map.Entry<String, String> each : map.entrySet()) {
            params.add(each.getKey(), (Object)each.getValue());
        }
        return params;
    }

    public static String getStringParam(PageParameters params, String key, String defaultValue) {
        StringValue v = params.get(key);
        if (v == null) {
            return defaultValue;
        }
        return v.toString(defaultValue);
    }

    public static String getStringParam(PageParameters params, String key) {
        return ParameterUtils.getStringParam(params, key, null);
    }

    public static int getIntParam(PageParameters params, String key, int defaultValue) {
        StringValue v = params.get(key);
        if (v == null) {
            return defaultValue;
        }
        return v.toInt(defaultValue);
    }

    private ParameterUtils() {
    }
}

