/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.resource.IResourceStream;

public final class Components {
    public static void assertTag(Component component, ComponentTag tag, String ... tagNames) {
        Components.assertTag(component, tag, Sets.newHashSet((Object[])tagNames));
    }

    public static void assertTag(Component component, ComponentTag tag, Set<String> tagNames) {
        boolean found = false;
        for (String tagName : tagNames) {
            if (!tag.getName().equalsIgnoreCase(tagName)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw Components.createMarkupException(component, tag, tagNames);
        }
    }

    private static MarkupException createMarkupException(Component component, ComponentTag tag, Set<String> tagNames) {
        String msg = String.format("Component [%s] (path = [%s]) must be applied to a tag of type [%s], not: %s", component.getId(), component.getPath(), Joiner.on((char)',').join(tagNames), tag.toUserDebugString());
        throw new MarkupException((IResourceStream)component.getMarkup().getMarkupResourceStream(), msg);
    }

    public static void hideIfModelIsEmpty(Component component) {
        if (Components.isModelEmpty(component)) {
            component.setVisible(false);
        }
    }

    public static boolean isModelEmpty(Component component) {
        return component != null && (component.getDefaultModel() == null || component.getDefaultModelObject() == null || Strings.isNullOrEmpty((String)component.getDefaultModelObjectAsString()));
    }

    public static boolean isModelEmpty(IModel<String> model) {
        return model == null || Strings.isNullOrEmpty((String)((String)model.getObject()));
    }

    public static void show(Component ... components) {
        if (components != null) {
            for (Component component : components) {
                component.setVisible(true);
            }
        }
    }
}

