/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component.form.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.measurement.core.web.component.form.validation.AbstractBeanPropertyValidator;
import java.io.Serializable;
import java.util.List;
import javax.validation.Validator;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.AbstractPropertyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.validation.IValidator;

public abstract class AbstractJSR303FormValidator
extends Behavior
implements IFormValidator {
    private static final long serialVersionUID = 1L;
    private Form<?> form;
    private Class<?>[] groups;
    private Class<?> beanType;
    private List<FormComponent<?>> formComponents;

    public AbstractJSR303FormValidator(Class<?> beanType) {
        this(beanType, new Class[0]);
    }

    public AbstractJSR303FormValidator(Class<?> beanType, Class<?>[] groups) {
        this.beanType = beanType;
        this.groups = groups;
        this.formComponents = Lists.newArrayList();
    }

    public FormComponent<?>[] getDependentFormComponents() {
        return (FormComponent[])Iterables.toArray(this.formComponents, FormComponent.class);
    }

    public void bind(Component component) {
        if (!(component instanceof Form)) {
            throw new WicketRuntimeException("The JSR303FormValidator must be added to a form");
        }
        this.form = (Form)component;
        if (!(this.form.getModel() instanceof CompoundPropertyModel)) {
            throw new WicketRuntimeException("The form model must be a valid CompoundPropertyModel");
        }
        this.form.visitFormComponents((IVisitor)new JSR303ValidatorFormVisitor());
    }

    protected abstract Validator getJSR303Validator();

    public void validate(Form<?> form) {
        if (form.hasError()) {
            form.error((Serializable)((Object)"Please fix below errors"));
        }
    }

    class JSR303ValidatorFormVisitor
    implements IVisitor<FormComponent<?>, List<FormComponent<?>>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        JSR303ValidatorFormVisitor() {
        }

        public void component(FormComponent<?> object, IVisit<List<FormComponent<?>>> visit) {
            AbstractTextComponent fc;
            AbstractPropertyModel pm;
            if (object instanceof AbstractTextComponent && (pm = (AbstractPropertyModel)(fc = (AbstractTextComponent)object).getModel()).getChainedModel() != null && pm.getChainedModel().getObject() != null) {
                fc.add((IValidator)new AbstractBeanPropertyValidator(AbstractJSR303FormValidator.this.beanType, pm.getPropertyExpression(), AbstractJSR303FormValidator.this.groups){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected Validator getJSR303Validator() {
                        return AbstractJSR303FormValidator.this.getJSR303Validator();
                    }
                });
                AbstractJSR303FormValidator.this.formComponents.add(fc);
            }
        }
    }
}

