/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component.form.validation;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.apache.wicket.validation.INullAcceptingValidator;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBeanPropertyValidator<T>
implements INullAcceptingValidator<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractBeanPropertyValidator.class);
    private final Class<T> beanType;
    private final String propertyName;
    private final Class<?>[] groups;

    protected abstract Validator getJSR303Validator();

    public AbstractBeanPropertyValidator(Class<T> beanType, String propertyName) {
        this(beanType, propertyName, new Class[0]);
    }

    public AbstractBeanPropertyValidator(Class<T> beanType, String propertyName, Class<?>[] groups) {
        this.beanType = beanType;
        this.propertyName = propertyName;
        this.groups = groups;
    }

    public void validate(IValidatable<T> validatable) {
        Object value = validatable.getValue();
        Set violations = this.getJSR303Validator().validateValue(this.beanType, this.propertyName, value, (Class[])this.groups);
        for (ConstraintViolation each : violations) {
            validatable.error((IValidationError)new ValidationError().setMessage(each.getMessage()));
            if (!logger.isDebugEnabled()) continue;
            logger.error("Violation = " + this.propertyName + " " + each.getMessage() + " - value was " + value);
        }
    }
}

