/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component.form;

import com.pmease.quickbuild.plugin.measurement.core.web.component.behavior.AssertTagNameBehavior;
import com.pmease.quickbuild.plugin.measurement.core.web.component.form.AbstractFormComponentBorder;
import com.pmease.quickbuild.plugin.measurement.core.web.component.util.Components;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TextInputBorder
extends AbstractFormComponentBorder {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer labelspan = new WebMarkupContainer("labelspan");
    private final Label label;
    private final Label required;
    private final Label help;
    private final Label error;
    private Model<String> stateClassName;

    public TextInputBorder(String id, IModel<String> label) {
        this(id, label, (IModel<String>)Model.of((Serializable)((Object)"")), true);
    }

    public TextInputBorder(String id, IModel<String> label, IModel<String> help, boolean required) {
        super(id);
        this.label = new Label("label", label);
        this.required = new Label("required", (IModel)new AbstractFormComponentBorder.RequiredModel(required));
        this.help = new Label("help", help);
        this.error = new Label("error", (IModel)Model.of((Serializable)((Object)"")));
        this.labelspan.add(new Component[]{this.label});
        this.labelspan.add(new Component[]{this.required.setEscapeModelStrings(false)});
        this.stateClassName = Model.of((Serializable)((Object)""));
        this.add(new Behavior[]{new AssertTagNameBehavior("div")});
        this.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)"control-group"))});
        this.add(new Behavior[]{AttributeAppender.append((String)"class", this.stateClassName)});
        this.addToBorder(new Component[]{this.labelspan, this.help, this.error});
    }

    protected void onInitialize() {
        super.onInitialize();
        List<FormComponent<?>> formComponents = this.findFormComponents();
        for (FormComponent<?> fc : formComponents) {
            fc.setOutputMarkupId(true);
            this.labelspan.add(new Behavior[]{AttributeModifier.replace((String)"for", (Serializable)((Object)fc.getMarkupId()))});
        }
    }

    protected void onConfigure() {
        super.onConfigure();
        Components.show(new Component[]{this.help, this.labelspan, this.error});
        List<FormComponent<?>> formComponents = this.findFormComponents();
        for (FormComponent<?> fc : formComponents) {
            List messages = fc.getFeedbackMessages();
            if (!messages.isEmpty()) {
                this.stateClassName.setObject((Serializable)((Object)this.toClassName(((FeedbackMessage)messages.get(0)).getLevelAsString())));
                this.error.setDefaultModelObject((Object)((FeedbackMessage)messages.get(0)).getMessage());
                ((FeedbackMessage)messages.get(0)).markRendered();
                break;
            }
            this.stateClassName.setObject((Serializable)((Object)""));
            this.error.setDefaultModelObject((Object)"");
        }
        if (formComponents.isEmpty()) {
            this.stateClassName.setObject((Serializable)((Object)""));
            this.error.setDefaultModelObject((Object)"");
        }
        Components.hideIfModelIsEmpty((Component)this.help);
        if (Components.isModelEmpty((Component)this.label)) {
            this.labelspan.setVisibilityAllowed(false);
        }
        Components.hideIfModelIsEmpty((Component)this.error);
    }

    @Override
    public TextInputBorder label(String label) {
        return this.label((IModel)Model.of((Serializable)((Object)label)));
    }

    @Override
    public TextInputBorder label(IModel<String> label) {
        this.label.setDefaultModel(label);
        return this;
    }

    @Override
    public TextInputBorder help(IModel<String> help) {
        this.help.setDefaultModel(help);
        return this;
    }

    @Override
    public TextInputBorder help(String help) {
        return this.help((IModel)Model.of((Serializable)((Object)help)));
    }

    @Override
    public String getLabel() {
        return this.label.getDefaultModelObjectAsString();
    }

    @Override
    public TextInputBorder required(boolean required) {
        this.required.setDefaultModel((IModel)new AbstractFormComponentBorder.RequiredModel(required));
        return this;
    }

    public void onDetach() {
        if (this.stateClassName != null) {
            this.stateClassName.detach();
        }
        super.onDetach();
    }
}

