/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component.form;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.measurement.core.web.component.form.AbstractFormComponentBorder;
import com.pmease.quickbuild.plugin.measurement.core.web.component.form.AbstractValidatableElement;
import com.pmease.quickbuild.plugin.measurement.core.web.component.form.TextInputBorder;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class TextFieldElement<T>
extends AbstractValidatableElement<T> {
    private static final long serialVersionUID = 1L;
    private int size;

    public TextFieldElement(String id, IModel<T> model) {
        this(id, model, (IModel<String>)Model.of((Serializable)((Object)"")));
    }

    public TextFieldElement(String id, IModel<T> model, IModel<String> label) {
        super(id, model, label);
    }

    protected AbstractFormComponentBorder createBorder(String id, IModel<String> label) {
        return new TextInputBorder(id, label);
    }

    protected TextField<T> createInputField(String id, IModel<T> model) {
        return new TextField(id, model);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        TextField<T> field = this.getFormComponent();
        field.add(new Behavior[]{AttributeModifier.replace((String)"size", (IModel)new PropertyModel((Object)this, "size"))});
    }

    public int getSize() {
        return this.size;
    }

    public TextFieldElement<T> setSize(int size) {
        this.size = size;
        return this;
    }

    @Override
    protected String getPlaceHolderText() {
        if (Strings.isNullOrEmpty((String)this.placeholder)) {
            return this.border.getLabel();
        }
        return this.placeholder;
    }

    protected FormComponent<T> createInputField(IModel<T> model) {
        return this.createInputField("input", model);
    }

    @Override
    protected AbstractFormComponentBorder createBorder(IModel<String> label) {
        return this.createBorder("border", label);
    }

    @Override
    public TextField<T> getFormComponent() {
        return (TextField)super.getFormComponent();
    }
}

