/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component.form;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.measurement.core.web.component.behavior.DefaultFocusBehavior;
import com.pmease.quickbuild.plugin.measurement.core.web.component.form.AbstractInputElement;
import com.pmease.quickbuild.plugin.measurement.core.web.component.form.IValidatable;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidator;

public abstract class AbstractValidatableElement<T>
extends AbstractInputElement<T>
implements IValidatable<T> {
    private static final long serialVersionUID = 1L;
    protected List<IValidator<T>> validators = Lists.newArrayList();

    public AbstractValidatableElement(String id, IModel<T> model, IModel<String> label) {
        super(id, model, label);
    }

    public AbstractValidatableElement<T> addValidator(IValidator<T> validator) {
        this.validators.add(validator);
        return this;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        for (IValidator<T> each : this.validators) {
            this.getFormComponent().add(each);
        }
        this.getFormComponent().setLabel((IModel)Model.of((Serializable)((Object)this.border.getLabel())));
        this.getFormComponent().add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return AbstractValidatableElement.this.getFormComponent().hasErrorMessage() ? "invalid" : "";
            }
        })});
    }

    @Override
    public FormComponent<T> getFormComponent() {
        return (FormComponent)super.getFormComponent();
    }

    public AbstractValidatableElement<T> setFocus() {
        this.getFormComponent().add(new Behavior[]{new DefaultFocusBehavior()});
        return this;
    }
}

