/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component.form;

import com.pmease.quickbuild.plugin.measurement.core.web.component.behavior.AssertTagNameBehavior;
import com.pmease.quickbuild.plugin.measurement.core.web.component.form.AbstractFormComponentBorder;
import com.pmease.quickbuild.plugin.measurement.core.web.component.util.Components;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class AbstractCheckRadioBorder
extends AbstractFormComponentBorder {
    private static final long serialVersionUID = 1L;
    private final Label label;
    private final Label error;
    private Model<String> stateClassName;

    public AbstractCheckRadioBorder(String id, IModel<String> label) {
        super(id);
        this.label = new Label("label", label);
        this.error = new Label("error", (IModel)Model.of((Serializable)((Object)"")));
        this.stateClassName = Model.of((Serializable)((Object)""));
        this.add(new Behavior[]{new AssertTagNameBehavior("div")});
        this.add(new Behavior[]{AttributeAppender.append((String)"class", this.stateClassName)});
        this.addToBorder(new Component[]{this.label, this.error});
    }

    protected void onConfigure() {
        super.onConfigure();
        Components.show(new Component[]{this.label, this.error});
        List<FormComponent<?>> formComponents = this.findFormComponents();
        for (FormComponent<?> fc : formComponents) {
            List messages = fc.getFeedbackMessages();
            if (!messages.isEmpty()) {
                this.stateClassName.setObject((Serializable)((Object)this.toClassName(((FeedbackMessage)messages.get(0)).getLevelAsString())));
                this.error.setDefaultModelObject((Object)((FeedbackMessage)messages.get(0)).getMessage());
                ((FeedbackMessage)messages.get(0)).markRendered();
                break;
            }
            this.stateClassName.setObject((Serializable)((Object)""));
            this.error.setDefaultModelObject((Object)"");
        }
        if (formComponents.isEmpty()) {
            this.stateClassName.setObject((Serializable)((Object)""));
            this.error.setDefaultModelObject((Object)"");
        }
        Components.hideIfModelIsEmpty((Component)this.error);
    }

    @Override
    public AbstractFormComponentBorder label(String label) {
        return this.label((IModel<String>)Model.of((Serializable)((Object)label)));
    }

    @Override
    public AbstractFormComponentBorder label(IModel<String> label) {
        this.label.setDefaultModel(label);
        return this;
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public AbstractFormComponentBorder help(String help) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractFormComponentBorder help(IModel<String> help) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractFormComponentBorder required(boolean required) {
        throw new UnsupportedOperationException();
    }

    public void onDetach() {
        if (this.stateClassName != null) {
            this.stateClassName.detach();
        }
        super.onDetach();
    }
}

