/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component.behavior;

import com.pmease.quickbuild.plugin.measurement.core.web.component.behavior.CssClassModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;

public class IterationCssBehavior
extends CssClassModifier {
    private static final long serialVersionUID = 1L;
    private final List<CssClass> classes = new ArrayList<CssClass>();

    public IterationCssBehavior(String ... classes) {
        for (String cls : classes) {
            this.classes.add(CssClass.valueOf(cls.toUpperCase()));
        }
    }

    public IterationCssBehavior(CssClass ... classes) {
        this.classes.addAll(Arrays.asList(classes));
    }

    @Override
    protected void modifyClasses(Component component, Set<String> values) {
        int iteration = this.getIndex(component) + 1;
        int size = this.getSize(component);
        for (CssClass cls : this.classes) {
            switch (cls) {
                case ODD: {
                    if (iteration % 2 != 1) break;
                    values.remove("even");
                    values.add("odd");
                    break;
                }
                case EVEN: {
                    if (iteration % 2 != 0) break;
                    values.remove("odd");
                    values.add("even");
                    break;
                }
                case FIRST: {
                    if (1 != iteration) break;
                    if (size > 1) {
                        values.remove("last");
                    }
                    values.add("first");
                    break;
                }
                case LAST: {
                    if (size != iteration) break;
                    if (size > 1) {
                        values.remove("first");
                    }
                    values.add("last");
                    break;
                }
                case ITERATION: {
                    values.add("iteration" + iteration);
                }
            }
        }
    }

    protected int getIndex(Component component) {
        if (component instanceof ListItem) {
            return ((ListItem)component).getIndex();
        }
        if (component instanceof LoopItem) {
            return ((LoopItem)component).getIndex();
        }
        if (component instanceof Item) {
            return ((Item)component).getIndex();
        }
        throw new UnsupportedOperationException(String.format("Don't know how to find the index of component %s (%s). Only list.ListItem, list.LoopItem and repeater.Item are supported. Perhaps you attached IterationCssBehavior to the wrong component?", component.getPath(), component.getClass()));
    }

    protected int getSize(Component component) {
        MarkupContainer parent = component.getParent();
        if (parent instanceof ListView) {
            return ((ListView)parent).getViewSize();
        }
        if (parent instanceof Loop) {
            return ((Loop)parent).getIterations();
        }
        if (parent instanceof RepeatingView) {
            int size = 0;
            Iterator iter = parent.iterator();
            while (iter.hasNext()) {
                iter.next();
                ++size;
            }
            return size;
        }
        throw new IllegalStateException(String.format("Don't know how to find the size of the repeater that contains component %s (%s). Only list.ListItem, list.LoopItem and repeater.Item are supported. Perhaps you attached IterationCssBehavior to the wrong component?", component.getPath(), component.getClass()));
    }

    public static enum CssClass {
        ODD,
        EVEN,
        FIRST,
        LAST,
        ITERATION;

    }
}

