/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component;

import com.pmease.quickbuild.plugin.measurement.core.web.event.WidthDetectedEvent;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;

public class WidthDetectorPanel
extends Panel {
    public WidthDetectorPanel(String id) {
        super(id);
    }

    public WidthDetectorPanel(String id, IModel<?> model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        final Component widthSpan = new WebMarkupContainer("widthSpan", this.getDefaultModel()).setOutputMarkupId(true);
        this.add(new Component[]{widthSpan});
        widthSpan.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected CharSequence getCallbackScript() {
                return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&ChartWidth=' + chartwidth");
            }

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.renderOnLoadJavaScript(this.getWidthScript());
            }

            private String getWidthScript() {
                StringBuffer script = new StringBuffer();
                script.append("var chartwidth = $('#").append(this.getComponent().getMarkupId()).append("').width();");
                script.append(this.getCallbackScript());
                return script.toString();
            }

            protected void respond(AjaxRequestTarget target) {
                double chartWidth = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("ChartWidth").toDouble(750.0);
                widthSpan.send((IEventSink)WidthDetectorPanel.this.getParent(), Broadcast.BREADTH, (Object)new WidthDetectedEvent(target, (int)chartWidth));
            }
        }});
    }
}

