/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component;

import com.google.common.base.Optional;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.measurement.core.trait.NodeTraits;
import com.pmease.quickbuild.plugin.measurement.core.web.AbstractNodePanel;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.util.quantity.Data;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;

public class NodeTraitsPanel
extends AbstractNodePanel {
    private static final long serialVersionUID = 1L;

    public NodeTraitsPanel(String id, String nodeAddress) {
        super(id, nodeAddress);
    }

    protected void onInitialize() {
        super.onInitialize();
        Optional<GridNode> node = this.getNode();
        NodeTraits traits = NodeTraits.getFromNodeData(node);
        this.add(new Component[]{new Label("nodeType", ((GridNode)node.get()).isServer() ? "QuickBuild Server" : "Build Agent")});
        if (traits.getOsName() == null) {
            this.add(new Component[]{new Label("os", "")});
        } else {
            this.add(new Component[]{new Label("os", traits.getOsName() + " (" + traits.getOsVersion() + ")")});
        }
        this.add(new Component[]{new Label("host", ((GridNode)node.get()).getHostName())});
        this.add(new Component[]{new Label("ip", ((GridNode)node.get()).getIp())});
        this.add(new Component[]{new Label("overssl", ((GridNode)node.get()).isOverSSL() ? "Yes" : "No")});
        if (traits.isSigarEnabled()) {
            this.add(new Component[]{new Label("cpu", DataTypes.DOUBLE.asString((Object)((double)traits.getCpuMhz() / 1000.0), "0.0") + " GHz " + traits.getCpuVendor() + " / " + traits.getAvailableProcessors() + " processors")});
        } else {
            this.add(new Component[]{new Label("cpu", "N/A")});
        }
        if (traits.getTotalMemory() == 0L) {
            this.add(new Component[]{new Label("memory", "")});
        } else {
            this.add(new Component[]{new Label("memory", Data.formatBytes((double)traits.getTotalMemory()))});
        }
        if (traits.getTotalSwap() == 0L) {
            this.add(new Component[]{new Label("swap", "")});
        } else {
            this.add(new Component[]{new Label("swap", Data.formatBytes((double)traits.getTotalSwap()))});
        }
        this.add(new Component[]{new Label("jvmMemInit", Data.formatBytes((double)traits.getJvmTotalInit()))});
        this.add(new Component[]{new Label("jvmMemTotal", Data.formatBytes((double)traits.getJvmTotalMax()))});
        this.add(new Component[]{new Label("heapInit", Data.formatBytes((double)traits.getJvmHeapInit()))});
        this.add(new Component[]{new Label("heapMax", Data.formatBytes((double)traits.getJvmHeapMax()))});
    }
}

