/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component;

import com.pmease.quickbuild.plugin.measurement.core.cache.LatestReportCache;
import com.pmease.quickbuild.plugin.measurement.core.cache.UpdatedTimeCache;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.NodeMeasurementReport;
import com.pmease.quickbuild.plugin.measurement.core.mock.GridMock;
import com.pmease.quickbuild.plugin.measurement.core.trait.NodeTraits;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.OsType;
import java.io.Serializable;
import java.util.Date;
import java.util.Random;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;

public class NodeInfoPanel
extends Panel {
    final String nodeAddress;
    private static final long serialVersionUID = 1L;

    public NodeInfoPanel(String id, String nodeAddress) {
        super(id);
        this.nodeAddress = nodeAddress;
    }

    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer container = new WebMarkupContainer("node");
        this.add(new Component[]{container});
        int alerts = this.getAlerts();
        container.add(new Component[]{new Label("alerts", String.valueOf(alerts)).setVisibilityAllowed(alerts > 0)});
        NodeTraits traits = this.getNodeTraits();
        WebMarkupContainer osLabel = new WebMarkupContainer("ostype");
        if (traits != null) {
            osLabel.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)("icon-os-" + traits.getOsType().name().toLowerCase())))});
            osLabel.add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)(traits.getOsType() == OsType.JAVA ? "Unknown" : traits.getOsType() + " " + traits.getOsVersion())))});
        } else {
            osLabel.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)"icon-os-java"))});
        }
        container.add(new Component[]{osLabel});
        container.add(new Component[]{new Label("address", this.nodeAddress)});
        long time = UpdatedTimeCache.INSTANCE.get(this.nodeAddress);
        if (time > 0L) {
            container.add(new Component[]{new Label("updatedTime", DateUtils.formatAge((Date)new Date(time)))});
        } else {
            container.add(new Component[]{new Label("updatedTime", "N/A")});
        }
        NodeMeasurementReport snapshot = (NodeMeasurementReport)LatestReportCache.INSTANCE.getUnchecked((Object)this.nodeAddress);
        double cpuPerc = snapshot.getCpuUsage();
        container.add(new Component[]{new Label("cpu", DataTypes.PERCENT.asString((Object)cpuPerc)).add(new Behavior[]{AttributeAppender.append((String)"style", (Serializable)((Object)("color: " + this.getColor(cpuPerc))))})});
        double memPerc = snapshot.getJvmMemoryUsage();
        container.add(new Component[]{new Label("memory", DataTypes.PERCENT.asString((Object)memPerc)).add(new Behavior[]{AttributeAppender.append((String)"style", (Serializable)((Object)("color: " + this.getColor(memPerc))))})});
        container.add(new Component[]{new Label("stepsRunning", String.valueOf(snapshot.getStepRunnings()))});
        container.add(new Component[]{new Label("brProcessings", String.valueOf(snapshot.getBuildRequestProcessings()))});
        container.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)this.getStatus(cpuPerc, memPerc)))});
    }

    String getStatus(double cpuPerc, double memPerc) {
        Status sCpu = Status.fromValue(cpuPerc);
        if (sCpu == Status.HIGH) {
            return "s-high";
        }
        Status sMem = Status.fromValue(memPerc);
        if (sMem == Status.HIGH) {
            return "s-high";
        }
        return "s-" + Status.values()[Math.min(sCpu.ordinal(), sMem.ordinal())].name().toLowerCase();
    }

    private String getColor(double percent) {
        if (percent > 0.9) {
            return "#ff1a00";
        }
        if (percent > 0.6) {
            return "#ff9900";
        }
        return "#00a300";
    }

    private int getAlerts() {
        return new Random().nextInt(100);
    }

    private NodeTraits getNodeTraits() {
        return NodeTraits.getFromNodeData(GridMock.getNode(this.nodeAddress));
    }

    static enum Status {
        HIGH(0.9),
        MEDIUM(0.6),
        NORMAL(0.4),
        LOW(0.0);

        final double threshold;

        private Status(double threshold) {
            this.threshold = threshold;
        }

        static Status fromValue(double value) {
            if (value >= Status.HIGH.threshold) {
                return HIGH;
            }
            if (value >= Status.MEDIUM.threshold) {
                return MEDIUM;
            }
            if (value >= Status.NORMAL.threshold) {
                return NORMAL;
            }
            return LOW;
        }
    }
}

