/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component;

import com.pmease.quickbuild.plugin.measurement.core.web.data.DataPoint;
import com.pmease.quickbuild.plugin.measurement.core.web.data.MetricsChartData;
import com.pmease.quickbuild.plugin.measurement.core.web.data.TimeSeries;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.PercentType;
import com.pmease.quickbuild.web.chart.ColorUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class MetricsColorTablePanel
extends Panel {
    private NameColumnType nameColumnType = NameColumnType.METRIC;
    private String timeFormatPattern;
    private boolean showValue;

    public MetricsColorTablePanel(String id, IModel<MetricsChartData> model) {
        super(id, model);
    }

    public MetricsColorTablePanel(String id, IModel<MetricsChartData> model, String fmt, boolean showValue) {
        super(id, model);
        this.timeFormatPattern = fmt;
        this.showValue = showValue;
        this.setOutputMarkupId(true);
    }

    protected MetricsChartData getMetricsData() {
        return (MetricsChartData)this.getDefaultModelObject();
    }

    protected TimeSeries getSeries(int idx) {
        return this.getMetricsData().getSeries(idx);
    }

    protected void onInitialize() {
        super.onInitialize();
        MetricsChartData data = this.getMetricsData();
        int length = 0;
        int count = data.getSeriesCount();
        if (count > 0) {
            length = data.getSeries(0).size();
            this.add(new Component[]{new Loop("times", length){

                protected void populateItem(LoopItem item) {
                    if (MetricsColorTablePanel.this.isShowTime()) {
                        int index = item.getIndex();
                        TimeSeries series = MetricsColorTablePanel.this.getSeries(0);
                        DataPoint point = series.getPoint(index);
                        Date date = new Date(point.getTimestamp());
                        item.add(new Component[]{new Label("time", DataTypes.DATE.asString((Object)date, MetricsColorTablePanel.this.timeFormatPattern))});
                    } else {
                        item.add(new Component[]{new WebMarkupContainer("time").setVisibilityAllowed(false)});
                    }
                }
            }});
            this.add(new Component[]{new Loop("metrics", count){

                protected void populateItem(LoopItem item) {
                    int idx = item.getIndex();
                    TimeSeries series = MetricsColorTablePanel.this.getSeries(idx);
                    if (MetricsColorTablePanel.this.isShowName()) {
                        item.add(new Component[]{MetricsColorTablePanel.this.createNameComponent("name", idx)});
                    } else {
                        item.add(new Component[]{new WebMarkupContainer("name").setVisibilityAllowed(false)});
                    }
                    item.add(new Component[]{new DataListView("values", idx, series.getPoints())});
                }
            }});
        } else {
            this.add(new Component[]{new WebMarkupContainer("times").setVisible(false)});
            this.add(new Component[]{new WebMarkupContainer("metrics").setVisible(false)});
        }
    }

    protected Component createNameComponent(String id, int idx) {
        return new Label("name", this.getNameLabel(idx));
    }

    protected String getNameLabel(int idx) {
        String label;
        TimeSeries series = this.getSeries(idx);
        switch (this.nameColumnType) {
            case SOURCE: {
                label = series.getKey().getSource();
                break;
            }
            case METRIC: {
                label = series.getDisplayName();
                break;
            }
            case BOTH: {
                label = series.getDisplayName() + "@" + series.getKey().getSource();
                break;
            }
            default: {
                label = "";
            }
        }
        return label;
    }

    protected boolean isShowName() {
        return true;
    }

    protected boolean isShowTime() {
        return true;
    }

    private Component createValueComponent(String id, int index, DataPoint point) {
        TimeSeries series = this.getSeries(index);
        String label = series.getDataType() instanceof PercentType ? (this.showValue ? series.getDataType().asString((Object)point.getValue()) : "") : (point.getValue().isNaN() ? "" : series.getDataType().asString((Object)point.getValue()));
        Label c = new Label(id, label);
        if (series.getDataType() instanceof PercentType) {
            StringBuffer sb = new StringBuffer();
            sb.append("background: ");
            if (point.getValue().isNaN()) {
                sb.append("#eee");
            } else {
                sb.append(ColorUtils.getCssHeatColor((int)((int)(point.getValue() * 100.0))));
            }
            if (point.getValue() > 0.85) {
                sb.append("; color: white;");
            }
            c.add(new Behavior[]{AttributeAppender.append((String)"style", (Serializable)((Object)sb.toString()))});
        }
        String title = series.getDisplayName() + "@" + DataTypes.DATE.asString((Object)new Date(point.getTimestamp()), "EEE MMM dd HH:mm") + " - " + series.getDataType().asString((Object)point.getValue());
        c.add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)title))});
        return c;
    }

    public NameColumnType getNameColumnType() {
        return this.nameColumnType;
    }

    public void setNameColumnType(NameColumnType nameColumnType) {
        this.nameColumnType = nameColumnType;
    }

    public String getTimeFormatPattern() {
        return this.timeFormatPattern;
    }

    public void setTimeFormatPattern(String timeFormatPattern) {
        this.timeFormatPattern = timeFormatPattern;
    }

    public boolean isShowValue() {
        return this.showValue;
    }

    public void setShowValue(boolean showValue) {
        this.showValue = showValue;
    }

    private class DataListView
    extends ListView<DataPoint> {
        final int index;

        public DataListView(String id, int index, List<? extends DataPoint> model) {
            super(id, model);
            this.index = index;
        }

        protected void populateItem(ListItem<DataPoint> item) {
            DataPoint point = (DataPoint)item.getModelObject();
            item.add(new Component[]{MetricsColorTablePanel.this.createValueComponent("value", this.index, point)});
        }
    }

    public static enum NameColumnType {
        SOURCE,
        METRIC,
        BOTH,
        NONE;

    }
}

