/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.web.MetricsChartSetting;
import com.pmease.quickbuild.plugin.measurement.core.web.data.MetricsChartData;
import com.pmease.quickbuild.plugin.measurement.core.web.data.TimeSeries;
import com.pmease.quickbuild.web.chart.JFreeChartPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.jfree.chart.JFreeChart;

public class MetricsChartPanel
extends Panel {
    private final Set<TimeSeries.Key> disabledMetas = Sets.newHashSet();
    private int chartWidth;
    private MetricsChartSetting.ChartType chartType;

    public MetricsChartPanel(String id, IModel<MetricsChartData> model, MetricsChartSetting.ChartType chartType, int chartWidth) {
        super(id, model);
        this.chartWidth = chartWidth <= 0 ? 750 : chartWidth;
        this.chartType = chartType;
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.createLegends()});
        this.add(new Component[]{this.createChart()});
    }

    private MetricsChartData getChartData() {
        MetricsChartData data = (MetricsChartData)this.getDefaultModelObject();
        for (TimeSeries each : data.getAllSeries()) {
            if (!this.disabledMetas.contains(each.getKey())) continue;
            each.setEnabled(false);
        }
        return data;
    }

    protected List<MetricMeta> getAvailableMetas() {
        return Collections.emptyList();
    }

    private Component createChart() {
        return new JFreeChartPanel("chart", this.chartWidth, 135, (IModel)new AbstractReadOnlyModel<JFreeChart>(){

            public JFreeChart getObject() {
                return MetricsChartPanel.this.getChartData().buildChart(MetricsChartPanel.this.chartType);
            }
        });
    }

    private Component createLegends() {
        AbstractReadOnlyModel<List<TimeSeries.Key>> metas = new AbstractReadOnlyModel<List<TimeSeries.Key>>(){

            public List<TimeSeries.Key> getObject() {
                ArrayList keys = Lists.newArrayList();
                for (TimeSeries.Key key : MetricsChartPanel.this.getChartData().getKeys()) {
                    keys.add(key);
                }
                return keys;
            }
        };
        return new ListView<TimeSeries.Key>("legends", (IModel)metas){

            protected void populateItem(ListItem<TimeSeries.Key> item) {
                final TimeSeries.Key key = (TimeSeries.Key)item.getModelObject();
                AjaxLink<Void> link = new AjaxLink<Void>("meta"){

                    public void onClick(AjaxRequestTarget target) {
                        if (MetricsChartPanel.this.disabledMetas.contains(key)) {
                            MetricsChartPanel.this.disabledMetas.remove(key);
                        } else {
                            MetricsChartPanel.this.disabledMetas.add(key);
                        }
                        MetricsChartPanel.this.onSeriesChanged(target);
                    }
                };
                final int index = item.getIndex();
                link.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return "legend-" + index + " " + (MetricsChartPanel.this.disabledMetas.contains(key) ? "disabled" : "");
                    }
                })});
                link.add(new Component[]{new Label("name", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        TimeSeries series = MetricsChartPanel.this.getChartData().getSeries(key);
                        return series.getDisplayName();
                    }
                })});
                item.add(new Component[]{link});
            }
        };
    }

    @Deprecated
    int getIndexOfMetric(TimeSeries.Key key) {
        MetricsChartData actual = this.getChartData();
        int i = 0;
        boolean found = false;
        for (TimeSeries.Key each : actual.getKeys()) {
            if (Objects.equal((Object)key, (Object)each)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    private void onSeriesChanged(AjaxRequestTarget target) {
        target.add(new Component[]{this});
    }
}

