/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.measurement.core.web.MeasurementHelper;
import com.pmease.quickbuild.plugin.measurement.core.web.MetricsChartSetting;
import com.pmease.quickbuild.plugin.measurement.core.web.component.MetricsChartPanel;
import com.pmease.quickbuild.plugin.measurement.core.web.component.MetricsColorTablePanel;
import com.pmease.quickbuild.plugin.measurement.core.web.data.MetricsChartData;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class MetricGroupPanel
extends Panel {
    private final String groupId;
    protected MetricsChartSetting.ChartType chartType;
    private IModel<MetricsChartData> dataModel;

    public MetricGroupPanel(String id, String groupId, IModel<MetricsChartSetting> settingModel, IModel<MetricsChartData> dataModel) {
        super(id, settingModel);
        this.setOutputMarkupId(true);
        this.groupId = groupId;
        this.dataModel = dataModel;
    }

    private MetricsChartSetting getChartSetting() {
        return (MetricsChartSetting)this.getDefaultModelObject();
    }

    protected void onInitialize() {
        super.onInitialize();
        if (this.chartType == null) {
            this.chartType = this.getChartSetting().getChartType();
        }
        this.add(new Component[]{this.createHeadSpan("span")});
        this.add(new Component[]{this.createContent("content")});
    }

    protected Component createHeadSpan(String id) {
        WebMarkupContainer span = new WebMarkupContainer(id);
        span.setVisibilityAllowed(this.getChartSetting().isShowMetricGroupControls());
        span.add(new Component[]{new Label("name", this.getSectionName()).setVisibilityAllowed(!Strings.isNullOrEmpty((String)this.getSectionName()))});
        span.add(new Component[]{new Loop("btns", (IModel)new AbstractReadOnlyModel<Integer>(){

            public Integer getObject() {
                return MetricGroupPanel.this.getChartTypes().length;
            }
        }){

            protected void populateItem(LoopItem item) {
                final MetricsChartSetting.ChartType type = MetricGroupPanel.this.getChartTypes()[item.getIndex()];
                AjaxLink<Void> link = new AjaxLink<Void>("btn"){

                    public void onClick(AjaxRequestTarget target) {
                        if (type == MetricGroupPanel.this.chartType) {
                            return;
                        }
                        MetricGroupPanel.this.chartType = type;
                        MetricGroupPanel.this.getChartSetting().setChartTypes(type);
                        MetricGroupPanel.this.onChartSettingChanged(target);
                    }
                };
                link.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return type == MetricGroupPanel.this.chartType ? "checked" : "";
                    }
                })});
                link.add(new Component[]{new WebMarkupContainer("icon").add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return "icon-chart-" + type.name().toLowerCase();
                    }
                })})});
                item.add(new Component[]{link});
            }
        }.setVisibilityAllowed(this.isShowChartButtons())});
        return span;
    }

    protected boolean isShowChartButtons() {
        return this.getChartSetting().isShowChartButtons();
    }

    protected Component createContent(String id) {
        switch (this.chartType) {
            case TABLE: {
                return new MetricsColorTablePanel(id, this.dataModel, this.getTimeFormatPattern(), this.isShowPercentValue());
            }
        }
        return new MetricsChartPanel(id, this.dataModel, this.chartType, this.getChartSetting().getChartWidth());
    }

    private String getTimeFormatPattern() {
        return MeasurementHelper.getTimeFormatPattern(this.getChartSetting().getTimespan(), this.getChartSetting().isShowDetails());
    }

    protected boolean isShowPercentValue() {
        return true;
    }

    private void onChartSettingChanged(AjaxRequestTarget target) {
        this.addOrReplace(new Component[]{this.createContent("content")});
        target.add(new Component[]{this});
    }

    protected String getSectionName() {
        return MetricMetaRegistry.instance.getCategory(this.groupId).getName();
    }

    private MetricsChartSetting.ChartType[] getChartTypes() {
        return new MetricsChartSetting.ChartType[]{MetricsChartSetting.ChartType.TABLE, MetricsChartSetting.ChartType.LINE, MetricsChartSetting.ChartType.AREA};
    }

    public MetricsChartSetting.ChartType getChartType() {
        return this.chartType;
    }

    public void setChartType(MetricsChartSetting.ChartType chartType) {
        this.chartType = chartType;
    }

    public void onDetach() {
        if (this.dataModel != null) {
            this.dataModel.detach();
        }
        super.onDetach();
    }
}

