/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.component;

import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.report.engine.web.AjaxTextLink;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class MenuItems {
    public static MenuItem labelItem(String label) {
        return new LabelMenuItem((IModel<String>)Model.of((Serializable)((Object)label)));
    }

    public static MenuItem labelItem(IModel<String> label) {
        return new LabelMenuItem(label);
    }

    public static MenuItem separator() {
        return new SeparatorItem();
    }

    public static abstract class MetricMenuItem
    extends MenuItem {
        private static final long serialVersionUID = 1L;
        final String metricName;

        public MetricMenuItem(String metricName) {
            this.metricName = metricName;
        }

        public Component render(String componentId) {
            MetricMeta meta = MetricMetaRegistry.instance.getMeta(this.metricName);
            return new AjaxTextLink(componentId, meta.getDisplayName()){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    MetricMenuItem.this.onSelect(target);
                }
            };
        }

        public String getMetricName() {
            return this.metricName;
        }

        protected abstract void onSelect(AjaxRequestTarget var1);
    }

    public static class SeparatorItem
    extends MenuItem {
        private static final long serialVersionUID = 1L;

        public Component render(String componentId) {
            return new WebMarkupContainer(componentId).setVisibilityAllowed(false);
        }

        public String getCssClass() {
            return "separator";
        }
    }

    public static class LabelMenuItem
    extends MenuItem {
        private static final long serialVersionUID = 1L;
        final IModel<String> label;

        public LabelMenuItem(IModel<String> label) {
            this.label = label;
        }

        public Component render(String componentId) {
            return new Label(componentId, this.label);
        }
    }
}

