/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.chart;

import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.pmease.quickbuild.plugin.measurement.core.web.data.TimeSeries;
import com.pmease.quickbuild.plugin.measurement.core.web.data.XYChartData;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.DurationType;
import com.pmease.quickbuild.plugin.report.engine.datatype.PercentType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.web.chart.ChartUtils;
import com.pmease.quickbuild.web.chart.ColorUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.velocity.runtime.parser.node.MathUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;

public class LineChartBuilder
implements Serializable {
    protected final XYChartData chartData;
    static final double[] PERCENT_RANGE = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};

    public LineChartBuilder(XYChartData data) {
        this.chartData = data;
    }

    public JFreeChart build() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return null;
        }
        JFreeChart chart = new JFreeChart(null, null, plot, false);
        this.customizeChart(chart);
        return chart;
    }

    protected void customizeChart(JFreeChart chart) {
        chart.setBackgroundPaint((Paint)Color.WHITE);
    }

    protected DatasetRenderingOrder getPlotRenderingOrder() {
        return DatasetRenderingOrder.FORWARD;
    }

    protected Plot getPlot() {
        XYPlot plot = new XYPlot();
        plot.setBackgroundAlpha(0.5f);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setNoDataMessage("No Data Available");
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setDatasetRenderingOrder(this.getPlotRenderingOrder());
        plot.setForegroundAlpha(0.8f);
        plot.setOutlineVisible(false);
        plot.setDomainZeroBaselineVisible(false);
        this.createXAxis(plot);
        this.createYAxes(plot);
        this.addPlotDataset(plot);
        this.createRenderers(plot);
        return plot;
    }

    protected void addPlotDataset(XYPlot plot) {
        for (int i = 0; i < this.chartData.getSeriesCount(); ++i) {
            TimeSeries series = this.chartData.getSeries(i);
            if (series.isEnabled()) {
                plot.setDataset(i, this.getDataset(series));
                continue;
            }
            plot.setDataset(i, null);
        }
    }

    protected XYDataset getDataset(TimeSeries series) {
        return series.toXYSeries();
    }

    protected void createXAxis(XYPlot plot) {
        NumberAxis xaxis = new NumberAxis("");
        xaxis.setTickUnit((NumberTickUnit)new DomainTickUnit(this.chartData.getStep()));
        xaxis.setTickMarksVisible(true);
        xaxis.setAxisLineVisible(false);
        xaxis.setRange(((Double)this.chartData.getXAxisRange().lowerEndpoint()).doubleValue(), ((Double)this.chartData.getXAxisRange().upperEndpoint()).doubleValue());
        xaxis.setTickLabelPaint((Paint)new Color(102, 102, 102));
        plot.setDomainAxis(0, (ValueAxis)xaxis);
        plot.mapDatasetToDomainAxis(0, 0);
    }

    protected String domainValueToString(double value) {
        return this.chartData.domainLabel(value);
    }

    private static Double nanSafeValue(Double d) {
        if (d.isInfinite() || d.isNaN()) {
            return 0.0;
        }
        return d;
    }

    protected void createYAxes(XYPlot plot) {
        HashMap dataTypeRangeMap = Maps.newHashMap();
        for (int i = 0; i < this.chartData.getSeriesCount(); ++i) {
            TimeSeries series = this.chartData.getSeries(i);
            if (!series.isEnabled()) continue;
            Range<Double> range = this.getRange(i);
            Range existed = (Range)dataTypeRangeMap.get(series.getDataType());
            if (existed == null) {
                dataTypeRangeMap.put(series.getDataType(), range);
                continue;
            }
            dataTypeRangeMap.put(series.getDataType(), Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(Math.max(LineChartBuilder.nanSafeValue((Double)range.upperEndpoint()), LineChartBuilder.nanSafeValue((Double)existed.upperEndpoint())))));
        }
        int axisIndex = 0;
        HashMap dataTypeAxisMap = Maps.newHashMap();
        for (int i = 0; i < this.chartData.getSeriesCount(); ++i) {
            TimeSeries series = this.chartData.getSeries(i);
            if (!series.isEnabled()) continue;
            Integer idx = (Integer)dataTypeAxisMap.get(series.getDataType());
            if (idx == null) {
                NumberAxis axis = this.createYAxis(series.getDataType(), (Range<Double>)((Range)dataTypeRangeMap.get(series.getDataType())));
                plot.setRangeAxis(axisIndex, (ValueAxis)axis);
                plot.mapDatasetToRangeAxis(i, axisIndex);
                dataTypeAxisMap.put(series.getDataType(), axisIndex);
                axis.setVisible(axisIndex < 2);
                ++axisIndex;
                continue;
            }
            plot.mapDatasetToRangeAxis(i, idx.intValue());
        }
    }

    private Range<Double> getRange(int index) {
        TimeSeries series = this.chartData.getSeries(index);
        if (series.getDataType() instanceof PercentType) {
            return Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0));
        }
        Range range = Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(series.getMaxValue()));
        return range;
    }

    protected NumberAxis createYAxis(DataType dataType, Range<Double> range) {
        double max;
        double yMax = (Double)range.upperEndpoint();
        double d = max = ((Double)range.upperEndpoint()).isNaN() ? 0.0 : (Double)range.upperEndpoint();
        if (dataType instanceof PercentType) {
            yMax = 1.0;
        } else if (max < 1.0 || MathUtils.isZero((Number)max)) {
            yMax = 1.0;
        } else {
            long l = (long)(max / 10.0);
            yMax = (l + 1L) * 10L;
        }
        NumberAxis axis = new NumberAxis("");
        axis.setRangeWithMargins(0.0, yMax);
        axis.setAxisLineVisible(false);
        axis.setTickUnit(this.createRangeTickUnit(yMax, dataType));
        axis.setTickLabelPaint((Paint)new Color(102, 102, 102));
        return axis;
    }

    protected NumberTickUnit createRangeTickUnit(double max, final DataType dataType) {
        return new NumberTickUnit(max / 2.0){
            private static final long serialVersionUID = 1L;

            public String valueToString(double value) {
                if (dataType instanceof BooleanType || dataType instanceof PercentType) {
                    return DataTypes.PERCENT.asString((Object)value, "#%");
                }
                if (dataType instanceof DurationType) {
                    return dataType.asString((Object)value, "HH:mm:ss");
                }
                return dataType.asString((Object)value);
            }
        };
    }

    protected void createRenderers(XYPlot plot) {
        for (int i = 0; i < this.chartData.getSeriesCount(); ++i) {
            XYItemRenderer renderer = this.createRenderer(i);
            plot.setRenderer(i, renderer);
        }
    }

    protected XYItemRenderer createRenderer(int index) {
        long points = this.chartData.getSeries(index).size();
        boolean withShape = points <= 50L;
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesStroke(0, ChartUtils.getSecondaryStroke());
        renderer.setSeriesPaint(0, (Paint)ColorUtils.DEFAULT_COLORS[index % ColorUtils.DEFAULT_COLORS.length]);
        renderer.setSeriesFillPaint(0, (Paint)ColorUtils.DEFAULT_COLORS[index % ColorUtils.DEFAULT_COLORS.length]);
        if (withShape) {
            renderer.setUseFillPaint(true);
            renderer.setSeriesShapesVisible(0, true);
            renderer.setSeriesShape(0, ChartUtils.getSecondaryShape());
            renderer.setUseOutlinePaint(true);
            renderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(1.0f));
            renderer.setSeriesOutlinePaint(0, (Paint)Color.white);
        } else {
            renderer.setBaseShapesVisible(false);
        }
        renderer.setBaseToolTipGenerator(this.createTooltipGenerator(index));
        return renderer;
    }

    protected XYToolTipGenerator createTooltipGenerator(int index) {
        return new CustomTooltipGenerator();
    }

    protected class LineRenderer
    extends XYLineAndShapeRenderer {
        private boolean withShape;

        LineRenderer(boolean withShape) {
            this.withShape = withShape;
        }

        public Paint getItemFillPaint(int series, int item) {
            if (this.withShape) {
                return super.getItemFillPaint(series, item);
            }
            return super.getItemOutlinePaint(series, item);
        }

        public Paint getItemOutlinePaint(int series, int item) {
            if (this.withShape) {
                return super.getItemOutlinePaint(series, item);
            }
            return super.getItemFillPaint(series, item);
        }
    }

    private class CustomTooltipGenerator
    extends StandardXYToolTipGenerator {
        private CustomTooltipGenerator() {
        }

        public String generateLabelString(XYDataset dataset, int series, int item) {
            return LineChartBuilder.this.chartData.getTooltip(series, item);
        }
    }

    private class DomainTickUnit
    extends NumberTickUnit {
        private static final long serialVersionUID = 1L;

        public DomainTickUnit(double size) {
            super(size);
        }

        public String valueToString(double value) {
            return LineChartBuilder.this.domainValueToString(value);
        }
    }
}

