/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web.chart;

import com.pmease.quickbuild.plugin.measurement.core.web.chart.LineChartBuilder;
import com.pmease.quickbuild.plugin.measurement.core.web.data.TimeSeries;
import com.pmease.quickbuild.plugin.measurement.core.web.data.XYChartData;
import com.pmease.quickbuild.web.chart.ColorUtils;
import java.awt.Paint;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class AreaChartBuilder
extends LineChartBuilder {
    public AreaChartBuilder(XYChartData data) {
        super(data);
    }

    @Override
    protected DatasetRenderingOrder getPlotRenderingOrder() {
        return DatasetRenderingOrder.REVERSE;
    }

    @Override
    protected XYDataset getDataset(TimeSeries series) {
        return series.toCategoryTableXYDataset();
    }

    @Override
    protected XYItemRenderer createRenderer(int index) {
        StackedXYAreaRenderer2 renderer = new StackedXYAreaRenderer2();
        renderer.setSeriesPaint(0, (Paint)ColorUtils.DEFAULT_COLORS[index % ColorUtils.DEFAULT_COLORS.length]);
        renderer.setSeriesFillPaint(0, (Paint)ColorUtils.DEFAULT_COLORS[index % ColorUtils.DEFAULT_COLORS.length]);
        renderer.setBaseToolTipGenerator(this.createTooltipGenerator(index));
        return renderer;
    }
}

