/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.web;

import com.google.common.collect.Range;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.measurement.MeasurementUtils;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import org.joda.time.Period;

public class MeasurementHelper {
    public static MeasurementDataManager.TableType timespanToTableType(TimeSpan timespan, boolean detailed) {
        if (detailed) {
            switch (timespan) {
                case LAST_DAY: {
                    return MeasurementDataManager.TableType.RAW;
                }
                case LAST_WEEK: {
                    return MeasurementDataManager.TableType.ONE_HOUR;
                }
                case LAST_MONTH: {
                    return MeasurementDataManager.TableType.SIX_HOURS;
                }
            }
            return MeasurementUtils.getTableType((long)((Long)timespan.range().lowerEndpoint()), (long)((Long)timespan.range().upperEndpoint()));
        }
        switch (timespan) {
            case LAST_DAY: {
                return MeasurementDataManager.TableType.ONE_HOUR;
            }
            case LAST_WEEK: 
            case LAST_MONTH: {
                return MeasurementDataManager.TableType.ONE_DAY;
            }
        }
        return MeasurementUtils.getTableType((long)((Long)timespan.range().lowerEndpoint()), (long)((Long)timespan.range().upperEndpoint()));
    }

    public static MeasurementDataManager.TableType periodToTableType(Range<Long> times, boolean detailed) {
        Period period = new Period((Long)times.upperEndpoint() - (Long)times.lowerEndpoint());
        if (period.getDays() <= 2) {
            if (detailed) {
                return MeasurementDataManager.TableType.RAW;
            }
            return MeasurementDataManager.TableType.ONE_HOUR;
        }
        if (period.getDays() <= 7) {
            if (detailed) {
                return MeasurementDataManager.TableType.ONE_HOUR;
            }
            return MeasurementDataManager.TableType.ONE_DAY;
        }
        if (period.getDays() <= 31) {
            if (detailed) {
                return MeasurementDataManager.TableType.SIX_HOURS;
            }
            return MeasurementDataManager.TableType.ONE_DAY;
        }
        return MeasurementUtils.getTableType((long)((Long)times.lowerEndpoint()), (long)((Long)times.upperEndpoint()));
    }

    public static String getTimeFormatPattern(TimeSpan timespan, boolean detailed) {
        if (detailed) {
            switch (timespan) {
                case LAST_DAY: {
                    return "HH:mm";
                }
                case LAST_WEEK: 
                case LAST_MONTH: {
                    return "M/d HH";
                }
            }
            return "HH:mm";
        }
        switch (timespan) {
            case LAST_DAY: {
                return "HH";
            }
            case LAST_WEEK: {
                return "EEE MM/dd";
            }
            case LAST_MONTH: {
                return "dd";
            }
        }
        return "HH:mm";
    }
}

