/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.util;

import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.measurement.MeasurementUtils;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.model.MeasurementData1D;
import com.pmease.quickbuild.model.MeasurementData1H;
import com.pmease.quickbuild.model.MeasurementData6H;
import com.pmease.quickbuild.util.ClassUtils;

public class MeasurementDataBuilder {
    public static MeasurementData of(long timestamp, String source, String metricId, Number value) {
        return MeasurementDataBuilder.of(MeasurementDataManager.TableType.RAW, timestamp, source, metricId, value);
    }

    public static MeasurementData of(MeasurementDataManager.TableType type, long timestamp, String source, String metricId, Number value) {
        MeasurementData1H data;
        switch (type) {
            case RAW: {
                Class clazz = MeasurementUtils.getRawTableClass((long)timestamp);
                data = (MeasurementData)ClassUtils.instantiateClass((Class)clazz, (Object[])new Object[0]);
                break;
            }
            case ONE_HOUR: {
                data = new MeasurementData1H();
                break;
            }
            case SIX_HOURS: {
                data = new MeasurementData6H();
                break;
            }
            case ONE_DAY: {
                data = new MeasurementData1D();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        data.setTimestamp(timestamp);
        data.setSource(source);
        data.setMetricName(metricId);
        data.setValue(Double.valueOf(value == null ? Double.NaN : value.doubleValue()));
        return data;
    }
}

