/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.trait;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.measurement.core.mock.GridMock;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.MemoryUsage;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SwapUsage;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SystemInfo;
import com.pmease.quickbuild.util.OsType;
import com.yammer.metrics.core.VirtualMachineMetrics;
import java.io.Serializable;
import org.hyperic.sigar.CpuInfo;

public class NodeTraits
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final NodeTraits NULL_TRAITS = new NodeTraits();
    private double jvmTotalInit;
    private double jvmTotalMax;
    private double jvmHeapInit;
    private double jvmHeapMax;
    private String jvmName;
    private String javaVersion;
    private String javaVendor;
    private String nodeId;
    public OsType osType = OsType.JAVA;
    private String osName;
    private String osArchitecture;
    private String osVersion;
    private int availableProcessors;
    private String cpuModel;
    private String cpuVendor;
    private int cpuMhz;
    private long totalMemory;
    private long totalSwap;
    private boolean updated = false;
    private boolean sigarEnabled = true;
    public static final String KEY = NodeTraits.class.getName();

    private SystemInfo getSystemInfo() {
        return (SystemInfo)Quickbuild.getInstance(SystemInfo.class);
    }

    public synchronized void update() {
        if (this.updated) {
            return;
        }
        this.sigarEnabled = this.getSystemInfo().isNative();
        this.jvmTotalInit = VirtualMachineMetrics.getInstance().totalInit();
        this.jvmTotalMax = VirtualMachineMetrics.getInstance().totalMax();
        this.jvmHeapInit = VirtualMachineMetrics.getInstance().heapInit();
        this.jvmHeapMax = VirtualMachineMetrics.getInstance().heapMax();
        this.jvmName = VirtualMachineMetrics.getInstance().name();
        SystemInfo sysInfo = this.getSystemInfo();
        this.javaVersion = sysInfo.getJavaVersion();
        this.javaVendor = sysInfo.getJavaVendor();
        this.nodeId = Grid.instance.getLocalNode().getAddress();
        this.osName = sysInfo.getOsName();
        this.osArchitecture = sysInfo.getOsArch();
        this.osVersion = sysInfo.getOsVersion();
        this.osType = sysInfo.getOsType();
        if (this.osType == null) {
            this.osType = OsType.JAVA;
        }
        this.availableProcessors = sysInfo.getAvailableProcessors();
        try {
            MemoryUsage mem = sysInfo.getMemoryUsage();
            this.totalMemory = mem.getTotal();
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            SwapUsage swap = sysInfo.getSwapUsage();
            this.totalSwap = swap.getTotal();
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            CpuInfo[] cpus = sysInfo.getCpuInfoList();
            if (cpus != null && cpus.length > 0) {
                CpuInfo first = cpus[0];
                this.cpuModel = first.getModel();
                this.cpuVendor = first.getVendor();
                this.cpuMhz = first.getMhz();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.updated = true;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    public OsType getOsType() {
        return this.osType;
    }

    @VisibleForTesting
    public void setOsType(OsType osType) {
        this.osType = osType;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public String getCpuModel() {
        return this.cpuModel;
    }

    public String getCpuVendor() {
        return this.cpuVendor;
    }

    public int getCpuMhz() {
        return this.cpuMhz;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getTotalSwap() {
        return this.totalSwap;
    }

    public double getJvmTotalInit() {
        return this.jvmTotalInit;
    }

    public double getJvmTotalMax() {
        return this.jvmTotalMax;
    }

    public double getJvmHeapInit() {
        return this.jvmHeapInit;
    }

    public double getJvmHeapMax() {
        return this.jvmHeapMax;
    }

    public String getJvmName() {
        return this.jvmName;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isSigarEnabled() {
        return this.sigarEnabled;
    }

    public static NodeTraits getFromNodeData(Optional<GridNode> node) {
        if (node.isPresent()) {
            if (GridMock.isEnabled()) {
                return GridMock.getTraits((GridNode)node.get());
            }
            NodeTraits traits = (NodeTraits)((GridNode)node.get()).getCharacteristics().getExtraCharacteristics().get(KEY);
            return traits == null ? NULL_TRAITS : traits;
        }
        return NULL_TRAITS;
    }
}

