/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.sysinfo;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.JavaSystemInfo;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.NativeSystemInfo;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SystemInfo;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfoFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SystemInfoFactory.class);
    private static final String SIGAR_CLASS_NAME = "org.hyperic.sigar.Sigar";
    private static boolean nativeLibraryLoadable;
    private static Throwable nativeLibraryLoadThrowable;
    private static boolean disabled;
    private static boolean initialized;
    private static SystemInfo cachedSystemInfo;
    private static Map<NativeApi, AccessibleObject> nativeApis;

    public static synchronized String getNativeSystemInfoVersion() {
        String version = null;
        Throwable error = null;
        SystemInfoFactory.initialize();
        if (SystemInfoFactory.isNativeSystemInfoAvailable() && !SystemInfoFactory.isNativeSystemInfoDisabled()) {
            try {
                version = "Version=" + SystemInfoFactory.invokeApi(NativeApi.VERSION_STRING, new Object[0]) + " (" + SystemInfoFactory.invokeApi(NativeApi.BUILD_DATE, new Object[0]) + "); Native version=" + SystemInfoFactory.invokeApi(NativeApi.NATIVE_VERSION_STRING, new Object[0]) + " (" + SystemInfoFactory.invokeApi(NativeApi.NATIVE_BUILD_DATE, new Object[0]) + ")";
            }
            catch (Throwable t) {
                error = t;
            }
        }
        if (version == null) {
            version = "Native system not supported - Java version is " + System.getProperty("java.version");
            if (error != null) {
                version = version + " : " + error;
            }
        }
        return version;
    }

    public static synchronized void disableNativeSystemInfo() {
        if (!disabled) {
            cachedSystemInfo = null;
        }
        disabled = true;
    }

    public static synchronized void enableNativeSystemInfo() {
        if (disabled) {
            cachedSystemInfo = null;
        }
        disabled = false;
    }

    public static synchronized boolean isNativeSystemInfoDisabled() {
        return disabled;
    }

    public static boolean isNativeSystemInfoAvailable() {
        return nativeLibraryLoadable;
    }

    public static Throwable getNativeLibraryLoadThrowable() {
        return nativeLibraryLoadThrowable;
    }

    public static synchronized boolean isNativeSystemInfoInitialized() {
        return initialized;
    }

    private static synchronized void initialize() {
        if (!initialized && SystemInfoFactory.isNativeSystemInfoAvailable() && !SystemInfoFactory.isNativeSystemInfoDisabled()) {
            try {
                SystemInfoFactory.invokeApi(NativeApi.load, new Object[0]);
                initialized = true;
            }
            catch (Throwable t) {
                LOG.warn("Native library not available on this platform: " + Throwables.getStackTraceAsString((Throwable)t));
                LOG.debug("Native library failure stack trace follows: ", t);
                nativeLibraryLoadable = false;
                disabled = true;
            }
        }
    }

    private static final Object invokeApi(NativeApi api, Object ... args) throws Throwable {
        AccessibleObject accessibleObject = nativeApis.get((Object)api);
        if (accessibleObject instanceof Method) {
            return ((Method)accessibleObject).invoke(null, args);
        }
        return ((Field)accessibleObject).get(null);
    }

    public static SystemInfo createJavaSystemInfo() {
        return new JavaSystemInfo();
    }

    public static synchronized void shutdown() {
        if (initialized) {
            initialized = false;
            cachedSystemInfo = null;
        }
    }

    public static synchronized SystemInfo createSystemInfo() {
        if (cachedSystemInfo == null) {
            SystemInfoFactory.initialize();
            JavaSystemInfo nativePlatform = null;
            if (SystemInfoFactory.isNativeSystemInfoAvailable() && !SystemInfoFactory.isNativeSystemInfoDisabled()) {
                nativePlatform = new NativeSystemInfo();
            }
            if (nativePlatform == null) {
                nativePlatform = new JavaSystemInfo();
            }
            if (!(cachedSystemInfo = nativePlatform).isNative()) {
                LOG.info("Native system info not supported on this platform, using Java based system info instead");
            }
        }
        return cachedSystemInfo;
    }

    static {
        initialized = false;
        try {
            Class<?> clazz = Class.forName(SIGAR_CLASS_NAME);
            nativeApis = ImmutableMap.builder().put((Object)NativeApi.load, (Object)clazz.getMethod(NativeApi.load.name(), new Class[0])).put((Object)NativeApi.VERSION_STRING, (Object)clazz.getField(NativeApi.VERSION_STRING.name())).put((Object)NativeApi.BUILD_DATE, (Object)clazz.getField(NativeApi.BUILD_DATE.name())).put((Object)NativeApi.NATIVE_VERSION_STRING, (Object)clazz.getField(NativeApi.NATIVE_VERSION_STRING.name())).put((Object)NativeApi.NATIVE_BUILD_DATE, (Object)clazz.getField(NativeApi.NATIVE_BUILD_DATE.name())).build();
            SystemInfoFactory.invokeApi(NativeApi.load, new Object[0]);
            nativeLibraryLoadable = true;
        }
        catch (Throwable t) {
            nativeLibraryLoadable = false;
            nativeLibraryLoadThrowable = t;
        }
        disabled = !nativeLibraryLoadable;
    }

    private static enum NativeApi {
        load,
        VERSION_STRING,
        BUILD_DATE,
        NATIVE_VERSION_STRING,
        NATIVE_BUILD_DATE;

    }
}

