/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.sysinfo;

import com.google.common.base.Throwables;
import java.io.File;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SigarHelper {
    public static final String COMPONENT = SigarHelper.class.getPackage().getName();
    static Logger logger = LoggerFactory.getLogger((String)COMPONENT);
    private static final double NOT_AVAILABLE = -1.0;
    private Object sigarInstance;
    private final Object sigarLock;
    private Method getCpuPercMethod;
    private Method getSysMethod;
    private Method getUserMethod;
    private Method getLoadAverageMethod;
    private Method getPercentMethod;
    private Method getProcCpuMethod;
    private Method getProcCpuSysMethod;
    private Method getProcCpuUserMethod;
    private Method getSizeMethod;
    private Method getProcMemMethod;
    private Method getResidentMethod;
    private Method getShareMethod;
    private Method getFileSystemUsageMethod;
    private Method fileSystemFreeMethod;
    private Method fileSystemUsedMethod;
    private Method fileSystemTotalMethod;
    private Method fileSystemUsedPercentMethod;
    private Method getMemMethod;
    private Method getUsedMemoryMethod;
    private Method getFreeMemoryMethod;
    private Method getFreeMemoryPercentMethod;
    private Method getUsedMemoryPercentMethod;
    private Method getSystemRAMMethod;
    private Method getSystemMemoryMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SigarHelper() {
        block7: {
            this.sigarLock = new Object();
            try {
                Class<?> sigarClass = Class.forName("org.hyperic.sigar.Sigar");
                Object sigar = sigarClass.newInstance();
                Class<?> sigarProxyClass = Class.forName("org.hyperic.sigar.SigarProxyCache");
                Method newInstance = sigarProxyClass.getMethod("newInstance", sigarClass, Integer.TYPE);
                Object object = this.sigarLock;
                synchronized (object) {
                    this.sigarInstance = newInstance.invoke(null, sigar, 5000);
                    try {
                        Method getPid = this.getMethod("getPid", new Class[0]);
                        getPid.invoke(this.sigarInstance, new Object[0]);
                    }
                    catch (Exception e) {
                        this.sigarInstance = null;
                    }
                }
            }
            catch (Throwable e) {
                if (!logger.isInfoEnabled()) break block7;
                logger.info("Could not load SIGAR");
            }
        }
    }

    public static synchronized SigarHelper getInstance() {
        SigarHelper helper = new SigarHelper();
        return helper.haveSigar() ? helper : null;
    }

    public static boolean sigarAvailable() {
        return SigarHelper.getInstance() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPid() {
        Long pid = -1L;
        try {
            Method getPid = this.getMethod("getPid", new Class[0]);
            Object object = this.sigarLock;
            synchronized (object) {
                pid = (Long)getPid.invoke(this.sigarInstance, new Object[0]);
            }
        }
        catch (Exception e) {
            this.log("Could not get PID from SIGAR", e);
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long matchChild(int ppid, String[] sPids) {
        long found = -1L;
        long[] pids = new long[sPids.length];
        for (int i = 0; i < sPids.length; ++i) {
            pids[i] = new Long(sPids[i]);
        }
        for (long pid : pids) {
            if (pid != (long)ppid) continue;
            found = pid;
            break;
        }
        if (found > 0L) {
            return found;
        }
        Method getProcState = null;
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < pids.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(pids[i]);
        }
        System.out.println("Parent PID: [" + ppid + "], JMX pids: [" + s.toString() + "]");
        try {
            for (String pid : sPids) {
                Object procState;
                long lPid = new Long(pid);
                if (lPid <= 0L) continue;
                if (getProcState == null) {
                    getProcState = this.getMethod("getProcState", String.class);
                }
                Object object = this.sigarLock;
                synchronized (object) {
                    procState = getProcState.invoke(this.sigarInstance, pid);
                }
                Method getPpid = procState.getClass().getMethod("getPpid", new Class[0]);
                long parentPID = (Long)getPpid.invoke(procState, new Object[0]);
                System.out.println("PID=[" + pid + "], PPID=[" + parentPID + "]");
                if (parentPID == (long)ppid) {
                    System.out.println("MATCHED!!! PID DETERMINED AS: " + pid);
                    found = new Long(pid);
                } else {
                    long parent = this.matchChild(ppid, new String[]{Long.toString(parentPID)});
                    if (parent != (long)ppid) continue;
                    System.out.println("Matched parent, PID is: " + parent);
                    found = parent;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log("Could not get PID from SIGAR", e);
        }
        return found;
    }

    public double getSystemCpuPercentage() {
        this.checkCpuPercMethod();
        if (this.getCpuPercMethod == null) {
            return -1.0;
        }
        if (this.getSysMethod == null) {
            try {
                this.getSysMethod = this.getCpuPercMethod.getReturnType().getMethod("getSys", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getSys method from SIGAR", e);
                return -1.0;
            }
        }
        double systemPercentage = -1.0;
        try {
            systemPercentage = (Double)this.getSysMethod.invoke(this.getCpuPerc(), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getSys method", e);
        }
        return systemPercentage;
    }

    public double getUserCpuPercentage() {
        this.checkCpuPercMethod();
        if (this.getCpuPercMethod == null) {
            return -1.0;
        }
        if (this.getUserMethod == null) {
            try {
                this.getUserMethod = this.getCpuPercMethod.getReturnType().getMethod("getUser", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getUser method from SIGAR", e);
                return -1.0;
            }
        }
        double userPercentage = -1.0;
        try {
            userPercentage = (Double)this.getUserMethod.invoke(this.getCpuPerc(), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getUser method", e);
        }
        return userPercentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getLoadAverage() {
        double[] loadAverage;
        if (this.getLoadAverageMethod == null) {
            try {
                this.getLoadAverageMethod = this.getMethod("getLoadAverage", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getLoadAverage method from SIGAR", e);
                return new double[]{-1.0};
            }
        }
        try {
            Object object = this.sigarLock;
            synchronized (object) {
                loadAverage = (double[])this.getLoadAverageMethod.invoke(this.sigarInstance, new Object[0]);
            }
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed invoking getLoadAverage method, load average is not available");
            }
            loadAverage = new double[]{-1.0};
        }
        return loadAverage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getProcessCpuPercentage(long pid) {
        this.checkProcCPU();
        if (this.getProcCpuMethod == null) {
            return -1.0;
        }
        if (this.getPercentMethod == null) {
            Object procCpu;
            try {
                Object object = this.sigarLock;
                synchronized (object) {
                    procCpu = this.getProcCpuMethod.invoke(this.sigarInstance, pid);
                }
            }
            catch (Exception e) {
                this.log("Failed invoking getProcCpu method", e);
                return -1.0;
            }
            try {
                this.getPercentMethod = procCpu.getClass().getMethod("getPercent", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getPercent method from SIGAR ProcCPU class", e);
                return -1.0;
            }
        }
        double percent = -1.0;
        try {
            Object object = this.sigarLock;
            synchronized (object) {
                percent = (Double)this.getPercentMethod.invoke(this.getProcCpuMethod.invoke(this.sigarInstance, pid), new Object[0]);
            }
        }
        catch (Exception e) {
            this.log("Failed invoking getPercent method", e);
        }
        return percent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getProcessCpuUser(long pid) {
        this.checkProcCPU();
        if (this.getProcCpuMethod == null) {
            return -1L;
        }
        if (this.getProcCpuUserMethod == null) {
            Object procCpu;
            try {
                Object object = this.sigarLock;
                synchronized (object) {
                    procCpu = this.getProcCpuMethod.invoke(this.sigarInstance, pid);
                }
            }
            catch (Exception e) {
                this.log("Failed invoking getProcCpu method", e);
                return -1L;
            }
            try {
                this.getProcCpuUserMethod = procCpu.getClass().getMethod("getUser", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getUser method from SIGAR ProcCPU class", e);
                return -1L;
            }
        }
        long user = -1L;
        try {
            Object object = this.sigarLock;
            synchronized (object) {
                user = (Long)this.getProcCpuUserMethod.invoke(this.getProcCpuMethod.invoke(this.sigarInstance, pid), new Object[0]);
            }
        }
        catch (Exception e) {
            this.log("Failed invoking getUser method", e);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getProcessCpuSys(long pid) {
        this.checkProcCPU();
        if (this.getProcCpuMethod == null) {
            return -1L;
        }
        if (this.getProcCpuSysMethod == null) {
            Object procCpu;
            try {
                Object object = this.sigarLock;
                synchronized (object) {
                    procCpu = this.getProcCpuMethod.invoke(this.sigarInstance, pid);
                }
            }
            catch (Exception e) {
                this.log("Failed invoking getProcCpu method", e);
                return -1L;
            }
            try {
                this.getProcCpuSysMethod = procCpu.getClass().getMethod("getSys", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getSys method from SIGAR ProcCPU class", e);
                return -1L;
            }
        }
        long sys = -1L;
        try {
            Object object = this.sigarLock;
            synchronized (object) {
                sys = (Long)this.getProcCpuSysMethod.invoke(this.getProcCpuMethod.invoke(this.sigarInstance, pid), new Object[0]);
            }
        }
        catch (Exception e) {
            this.log("Failed invoking getSys method", e);
        }
        return sys;
    }

    private void checkProcCPU() {
        if (this.getProcCpuMethod == null) {
            try {
                this.getProcCpuMethod = this.getMethod("getProcCpu", Long.TYPE);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getProcCpu method from SIGAR", e);
            }
        }
    }

    public long getProcessVirtualMemorySize(long pid) {
        this.checkProcMemMethod();
        if (this.getProcMemMethod == null) {
            return -1L;
        }
        if (this.getSizeMethod == null) {
            Object procMem = this.getProcMem(pid);
            if (procMem == null) {
                return -1L;
            }
            try {
                this.getSizeMethod = procMem.getClass().getMethod("getSize", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getSize method from SIGAR ProcMem class", e);
                return -1L;
            }
        }
        long size = -1L;
        try {
            size = (Long)this.getSizeMethod.invoke(this.getProcMem(pid), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getSize method", e);
        }
        return size;
    }

    public long getProcessResidentMemory(long pid) {
        this.checkProcMemMethod();
        if (this.getProcMemMethod == null) {
            return -1L;
        }
        if (this.getResidentMethod == null) {
            Object procMem = this.getProcMem(pid);
            if (procMem == null) {
                return -1L;
            }
            try {
                this.getResidentMethod = procMem.getClass().getMethod("getResident", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getResident method from SIGAR ProcMem class", e);
                return -1L;
            }
        }
        long resident = -1L;
        try {
            resident = (Long)this.getResidentMethod.invoke(this.getProcMem(pid), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getSize method", e);
        }
        return resident;
    }

    public long getProcessSharedMemory(long pid) {
        this.checkProcMemMethod();
        if (this.getProcMemMethod == null) {
            return -1L;
        }
        if (this.getShareMethod == null) {
            Object procMem = this.getProcMem(pid);
            if (procMem == null) {
                return -1L;
            }
            try {
                this.getShareMethod = procMem.getClass().getMethod("getShare", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getShare method from SIGAR ProcMem class", e);
                return -1L;
            }
        }
        long shared = -1L;
        try {
            shared = (Long)this.getShareMethod.invoke(this.getProcMem(pid), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getShare method", e);
        }
        return shared;
    }

    public long getFileSystemFree(String fileSystem) {
        this.checkFileSysemUsageMethods(fileSystem);
        if (this.fileSystemFreeMethod == null) {
            return -1L;
        }
        long free = -1L;
        try {
            free = (Long)this.fileSystemFreeMethod.invoke(this.getFileSystemUsage(fileSystem), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getFree method", e);
        }
        return free;
    }

    public long getFileSystemUsed(String fileSystem) {
        this.checkFileSysemUsageMethods(fileSystem);
        if (this.fileSystemUsedMethod == null) {
            return -1L;
        }
        long used = -1L;
        try {
            used = (Long)this.fileSystemUsedMethod.invoke(this.getFileSystemUsage(fileSystem), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getUsed method", e);
        }
        return used;
    }

    public long getFileSystemTotal(String fileSystem) {
        this.checkFileSysemUsageMethods(fileSystem);
        if (this.fileSystemTotalMethod == null) {
            return -1L;
        }
        long total = -1L;
        try {
            total = (Long)this.fileSystemTotalMethod.invoke(this.getFileSystemUsage(fileSystem), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getUsed method", e);
        }
        return total;
    }

    public double getFileSystemUsedPercent(String fileSystem) {
        this.checkFileSysemUsageMethods(fileSystem);
        if (this.fileSystemUsedPercentMethod == null) {
            return -1.0;
        }
        double percent = -1.0;
        try {
            percent = (Double)this.fileSystemUsedPercentMethod.invoke(this.getFileSystemUsage(fileSystem), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getUsePercent method", e);
        }
        return percent;
    }

    public long getRam() {
        this.checkSystemMemoryMethods();
        if (this.getSystemRAMMethod == null) {
            return -1L;
        }
        long ram = -1L;
        try {
            ram = (Long)this.getSystemRAMMethod.invoke(this.getMem(), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getRam method", e);
        }
        return ram;
    }

    public long getTotalSystemMemory() {
        this.checkSystemMemoryMethods();
        if (this.getSystemMemoryMethod == null) {
            return -1L;
        }
        long totalMem = -1L;
        try {
            totalMem = (Long)this.getSystemMemoryMethod.invoke(this.getMem(), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getTotal method", e);
        }
        return totalMem;
    }

    public double getFreeSystemMemoryPercent() {
        this.checkSystemMemoryMethods();
        if (this.getFreeMemoryPercentMethod == null) {
            return -1.0;
        }
        double free = -1.0;
        try {
            free = (Double)this.getFreeMemoryPercentMethod.invoke(this.getMem(), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getFreePercent method", e);
        }
        return free;
    }

    public long getFreeSystemMemory() {
        this.checkSystemMemoryMethods();
        if (this.getFreeMemoryMethod == null) {
            return -1L;
        }
        long free = -1L;
        try {
            free = (Long)this.getFreeMemoryMethod.invoke(this.getMem(), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getFreePercent method", e);
        }
        return free;
    }

    public double getUsedSystemMemoryPercent() {
        this.checkSystemMemoryMethods();
        if (this.getUsedMemoryPercentMethod == null) {
            return -1.0;
        }
        double used = -1.0;
        try {
            used = (Double)this.getUsedMemoryPercentMethod.invoke(this.getMem(), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getUsedPercent method", e);
        }
        return used;
    }

    public long getUsedSystemMemory() {
        this.checkSystemMemoryMethods();
        if (this.getUsedMemoryMethod == null) {
            return -1L;
        }
        long used = -1L;
        try {
            used = (Long)this.getUsedMemoryMethod.invoke(this.getMem(), new Object[0]);
        }
        catch (Exception e) {
            this.log("Failed invoking getUsed method", e);
        }
        return used;
    }

    private void checkCpuPercMethod() {
        if (this.getCpuPercMethod == null) {
            try {
                this.getCpuPercMethod = this.getMethod("getCpuPerc", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getCpuPerc method from SIGAR", e);
            }
        }
    }

    private void checkProcMemMethod() {
        if (this.getProcMemMethod == null) {
            try {
                this.getProcMemMethod = this.getMethod("getProcMem", Long.TYPE);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getProcMem method from SIGAR", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCpuPerc() {
        Object cpuPerc;
        try {
            Object object = this.sigarLock;
            synchronized (object) {
                cpuPerc = this.getCpuPercMethod.invoke(this.sigarInstance, new Object[0]);
            }
        }
        catch (Exception e) {
            this.log("Failed invoking getCpuPerc method", e);
            return null;
        }
        return cpuPerc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getProcMem(long pid) {
        Object procMem;
        try {
            Object object = this.sigarLock;
            synchronized (object) {
                procMem = this.getProcMemMethod.invoke(this.sigarInstance, pid);
            }
        }
        catch (Exception e) {
            this.log("Failed invoking getProcMem method", e);
            return null;
        }
        return procMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFileSystemUsage(String fileSystem) {
        Object fsu;
        try {
            Object object = this.sigarLock;
            synchronized (object) {
                fsu = this.getFileSystemUsageMethod.invoke(this.sigarInstance, fileSystem == null ? File.separator : fileSystem);
            }
        }
        catch (Exception e) {
            this.log("Failed invoking getFileSystemUsage method", e);
            return null;
        }
        return fsu;
    }

    private void checkFileSysemUsageMethods(String fileSystem) {
        Object fsu;
        this.checkFileSystemUsageMethod();
        if (this.getFileSystemUsageMethod == null) {
            return;
        }
        if (this.fileSystemFreeMethod == null) {
            try {
                fsu = this.getFileSystemUsage(fileSystem);
                if (fsu != null) {
                    this.fileSystemFreeMethod = fsu.getClass().getMethod("getFree", new Class[0]);
                }
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getFree method", e);
                return;
            }
        }
        if (this.fileSystemUsedMethod == null) {
            try {
                fsu = this.getFileSystemUsage(fileSystem);
                if (fsu != null) {
                    this.fileSystemUsedMethod = fsu.getClass().getMethod("getUsed", new Class[0]);
                }
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getUsed method", e);
                return;
            }
        }
        if (this.fileSystemTotalMethod == null) {
            try {
                fsu = this.getFileSystemUsage(fileSystem);
                if (fsu != null) {
                    this.fileSystemTotalMethod = fsu.getClass().getMethod("getTotal", new Class[0]);
                }
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getTotal method", e);
                return;
            }
        }
        if (this.fileSystemUsedPercentMethod == null) {
            try {
                fsu = this.getFileSystemUsage(fileSystem);
                if (fsu != null) {
                    this.fileSystemUsedPercentMethod = fsu.getClass().getMethod("getUsePercent", new Class[0]);
                }
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getUsePercent method", e);
            }
        }
    }

    private void checkFileSystemUsageMethod() {
        if (this.getFileSystemUsageMethod == null) {
            try {
                this.getFileSystemUsageMethod = this.getMethod("getFileSystemUsage", String.class);
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getFileSystemUsage method from SIGAR", e);
            }
        }
    }

    private void checkSystemMemoryMethods() {
        Object mem;
        this.checkGetMemMethod();
        if (this.getFreeMemoryPercentMethod == null) {
            try {
                mem = this.getMem();
                if (mem != null) {
                    this.getFreeMemoryPercentMethod = mem.getClass().getMethod("getFreePercent", new Class[0]);
                }
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getFreePercent method from " + this.getMem().getClass().getName(), e);
            }
        }
        if (this.getUsedMemoryPercentMethod == null) {
            try {
                mem = this.getMem();
                if (mem != null) {
                    this.getUsedMemoryPercentMethod = mem.getClass().getMethod("getUsedPercent", new Class[0]);
                }
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getUsePercent method from " + this.getMem().getClass().getName(), e);
            }
        }
        if (this.getSystemRAMMethod == null) {
            try {
                mem = this.getMem();
                if (mem != null) {
                    this.getSystemRAMMethod = mem.getClass().getMethod("getRam", new Class[0]);
                }
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getRam method from " + this.getMem().getClass().getName(), e);
            }
        }
        if (this.getSystemMemoryMethod == null) {
            try {
                mem = this.getMem();
                if (mem != null) {
                    this.getSystemMemoryMethod = mem.getClass().getMethod("getTotal", new Class[0]);
                }
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getTotal method from " + this.getMem().getClass().getName(), e);
            }
        }
        if (this.getUsedMemoryMethod == null) {
            try {
                mem = this.getMem();
                if (mem != null) {
                    this.getUsedMemoryMethod = mem.getClass().getMethod("getUsed", new Class[0]);
                }
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getTotal method from " + this.getMem().getClass().getName(), e);
            }
        }
        if (this.getFreeMemoryMethod == null) {
            try {
                mem = this.getMem();
                if (mem != null) {
                    this.getFreeMemoryMethod = mem.getClass().getMethod("getFree", new Class[0]);
                }
            }
            catch (NoSuchMethodException e) {
                this.log("Could not obtain getFree method from " + this.getMem().getClass().getName(), e);
            }
        }
    }

    private void checkGetMemMethod() {
        try {
            if (this.getMemMethod == null) {
                this.getMemMethod = this.getMethod("getMem", new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            this.log("Could not obtain getMem method from SIGAR", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMem() {
        Object mem;
        this.checkGetMemMethod();
        try {
            Object object = this.sigarLock;
            synchronized (object) {
                mem = this.getMemMethod.invoke(this.sigarInstance, new Object[0]);
            }
        }
        catch (Exception e) {
            this.log("Failed invoking getMem method", e);
            return null;
        }
        return mem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haveSigar() {
        boolean have;
        Object object = this.sigarLock;
        synchronized (object) {
            have = this.sigarInstance != null;
        }
        return have;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getMethod(String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method m;
        Object object = this.sigarLock;
        synchronized (object) {
            m = this.sigarInstance.getClass().getMethod(methodName, parameterTypes);
        }
        return m;
    }

    private void log(String s, Throwable t) {
        Throwable cause = Throwables.getRootCause((Throwable)t);
        if (logger.isInfoEnabled()) {
            logger.info(s, t);
        } else {
            logger.warn(s + ". Caused by: " + cause.getClass().getName() + ": " + cause.getMessage());
        }
    }
}

