/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.sysinfo;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.hyperic.sigar.NetStat;

public class NetworkStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] tcpStates = new int[14];
    private int allInboundTotal;
    private int allOutboundTotal;
    private int tcpInboundTotal;
    private int tcpOutboundTotal;

    public NetworkStats() {
    }

    public NetworkStats(NetStat stat) {
        this.allInboundTotal = stat.getAllInboundTotal();
        this.allOutboundTotal = stat.getAllOutboundTotal();
        this.tcpInboundTotal = stat.getTcpInboundTotal();
        this.tcpOutboundTotal = stat.getTcpOutboundTotal();
        this.tcpStates = stat.getTcpStates();
    }

    public int getAllInboundTotal() {
        return this.allInboundTotal;
    }

    public void setAllInboundTotal(int allInboundTotal) {
        this.allInboundTotal = allInboundTotal;
    }

    public int getAllOutboundTotal() {
        return this.allOutboundTotal;
    }

    public void setAllOutboundTotal(int allOutboundTotal) {
        this.allOutboundTotal = allOutboundTotal;
    }

    public int getTcpInboundTotal() {
        return this.tcpInboundTotal;
    }

    public void setTcpInboundTotal(int tcpInboundTotal) {
        this.tcpInboundTotal = tcpInboundTotal;
    }

    public int getTcpOutboundTotal() {
        return this.tcpOutboundTotal;
    }

    public void setTcpOutboundTotal(int tcpOutboundTotal) {
        this.tcpOutboundTotal = tcpOutboundTotal;
    }

    public int[] getTcpStates() {
        return this.tcpStates;
    }

    public void setTcpStates(int[] tcpStates) {
        this.tcpStates = tcpStates;
    }

    public int getTcpEstablished() {
        return this.tcpStates[1];
    }

    public int getTcpSynSent() {
        return this.tcpStates[2];
    }

    public int getTcpSynRecv() {
        return this.tcpStates[3];
    }

    public int getTcpFinWait1() {
        return this.tcpStates[4];
    }

    public int getTcpFinWait2() {
        return this.tcpStates[5];
    }

    public int getTcpTimeWait() {
        return this.tcpStates[6];
    }

    public int getTcpClose() {
        return this.tcpStates[7];
    }

    public int getTcpCloseWait() {
        return this.tcpStates[8];
    }

    public int getTcpLastAck() {
        return this.tcpStates[9];
    }

    public int getTcpListen() {
        return this.tcpStates[10];
    }

    public int getTcpClosing() {
        return this.tcpStates[11];
    }

    public int getTcpIdle() {
        return this.tcpStates[12];
    }

    public int getTcpBound() {
        return this.tcpStates[13];
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tcpInboundTotal", this.tcpInboundTotal).add("tcpOutboundTotal", this.tcpOutboundTotal).add("allInboundTotal", this.allInboundTotal).add("allOutboundTotal", this.allOutboundTotal).add("tcpEstablished", this.getTcpEstablished()).add("tcpSynSent", this.getTcpSynSent()).add("tcpSynRecv", this.getTcpSynRecv()).add("tcpFinWait1", this.getTcpFinWait1()).add("tcpFinWait2", this.getTcpFinWait2()).add("tcpIdle", this.getTcpIdle()).add("tcpBound", this.getTcpBound()).toString();
    }
}

