/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.sysinfo;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.NetInterfaceConfig;

public class NetworkAdapterInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String displayName;
    private final String description;
    private final String address;
    private final String macAddress;
    private final String type;
    private final OperationState operationalStatus;
    private final Boolean dhcpEnabled;
    private final List<InetAddress> dnsServers;
    private List<InetAddress> unicastAddresses;
    private List<InetAddress> multicastAddresses;
    private long flags;

    public NetworkAdapterInfo(String name, String displayName, String description, String macAddress, String type, String operationalStatus, Boolean dhcpEnabled, List<InetAddress> dnsServers, String address, List<InetAddress> unicastAddresses, List<InetAddress> multicastAddresses) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.macAddress = macAddress;
        this.type = type;
        this.operationalStatus = OperationState.valueOf(operationalStatus);
        this.dhcpEnabled = dhcpEnabled;
        this.dnsServers = dnsServers;
        this.unicastAddresses = unicastAddresses;
        this.multicastAddresses = multicastAddresses;
        this.address = address;
    }

    public NetworkAdapterInfo(NetInterfaceConfig a) {
        long flags = a.getFlags();
        OperationState state = OperationState.UP;
        if ((flags & 1L) <= 0L) {
            state = OperationState.DOWN;
        }
        this.name = a.getName();
        this.displayName = a.getName();
        this.description = a.getDescription();
        this.macAddress = a.getHwaddr();
        this.type = a.getType();
        this.operationalStatus = state;
        this.dhcpEnabled = Boolean.FALSE;
        this.dnsServers = null;
        this.flags = a.getFlags();
        this.address = a.getAddress();
        try {
            this.unicastAddresses = Collections.singletonList(InetAddress.getByName(a.getAddress()));
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        try {
            this.multicastAddresses = Collections.singletonList(InetAddress.getByName(a.getBroadcast()));
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAllFlags() {
        return NetFlags.getIfFlagsString((long)this.flags);
    }

    public String getMacAddressString() {
        return this.macAddress;
    }

    public byte[] getMacAddressBytes() {
        if (this.macAddress == null) {
            return null;
        }
        byte[] bytes = new byte[6];
        String[] hex = this.macAddress.split("(\\:|\\-)");
        if (hex.length != 6) {
            throw new IllegalArgumentException("Invalid MAC address: " + this.macAddress);
        }
        for (int i = 0; i < 6; ++i) {
            try {
                bytes[i] = (byte)Integer.parseInt(hex[i], 16);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid hex digit [" + hex[i] + "] in MAC address: " + this.macAddress);
            }
        }
        return bytes;
    }

    public String getType() {
        return this.type;
    }

    public OperationState getOperationalStatus() {
        return this.operationalStatus;
    }

    public Boolean isDhcpEnabled() {
        return this.dhcpEnabled;
    }

    public List<InetAddress> getDnsServers() {
        return this.dnsServers;
    }

    public List<InetAddress> getUnicastAddresses() {
        return this.unicastAddresses;
    }

    public List<InetAddress> getMulticastAddresses() {
        return this.multicastAddresses;
    }

    public String getAddress() {
        return this.address;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("NetworkAdapterInfo: ");
        s.append("name=[" + this.name);
        s.append("], display-name=[" + this.displayName);
        s.append("], description=[" + this.description);
        s.append("], mac-address=[" + this.macAddress);
        s.append("], type=[" + this.type);
        s.append("], operational-status=[" + (Object)((Object)this.operationalStatus));
        s.append("], dhcp-enabled=[" + this.dhcpEnabled);
        s.append("], dns-servers=" + this.dnsServers);
        s.append("], address=" + this.address);
        s.append(", unicast-addresses=" + this.unicastAddresses);
        s.append(", multicast-addresses=" + this.multicastAddresses);
        return s.toString();
    }

    public static enum OperationState {
        UP,
        DOWN,
        TESTING,
        UNKNOWN,
        DORMANT,
        NOTPRESENT,
        LOWERLAYERDOWN;

    }
}

