/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.sysinfo;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.CpuUsage;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.FileSystemInfo;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.JavaSystemInfo;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.MemoryUsage;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.NetworkAdapterInfo;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.NetworkAdapterStats;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.NetworkStats;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SigarAccess;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SwapUsage;
import com.pmease.quickbuild.plugin.report.engine.util.quantity.Amount;
import com.pmease.quickbuild.plugin.report.engine.util.quantity.Data;
import com.pmease.quickbuild.plugin.report.engine.util.quantity.Unit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeSystemInfo
extends JavaSystemInfo {
    private static final Logger logger = LoggerFactory.getLogger(NativeSystemInfo.class);
    private SigarProxy sigar = SigarAccess.getSigar();

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public long getProcessId() {
        try {
            return this.sigar.getPid();
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    @Override
    public long getProcessCpuTime() {
        try {
            return this.sigar.getProcCpu(this.getProcessId()).getTotal();
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    @Override
    public MemoryUsage getMemoryUsage() {
        try {
            return new MemoryUsage(this.sigar.getMem());
        }
        catch (SigarException e) {
            return super.getMemoryUsage();
        }
    }

    @Override
    public SwapUsage getSwapUsage() {
        try {
            return new SwapUsage(this.sigar.getSwap());
        }
        catch (SigarException e) {
            return super.getSwapUsage();
        }
    }

    @Override
    public CpuInfo[] getCpuInfoList() {
        try {
            return this.sigar.getCpuInfoList();
        }
        catch (SigarException e) {
            return super.getCpuInfoList();
        }
    }

    @Override
    public CpuUsage getCpuUsage() {
        try {
            return new CpuUsage(this.sigar.getCpuPerc());
        }
        catch (SigarException e) {
            return super.getCpuUsage();
        }
    }

    @Override
    public List<NetworkAdapterInfo> getAllNetworkAdapters() {
        ArrayList adapters = Lists.newArrayList();
        try {
            String[] interfaceNames = this.sigar.getNetInterfaceList();
            if (interfaceNames != null) {
                for (String interfaceName : interfaceNames) {
                    if (interfaceName.indexOf(58) != -1) continue;
                    adapters.add(new NetworkAdapterInfo(this.sigar.getNetInterfaceConfig(interfaceName)));
                }
            }
        }
        catch (SigarException e) {
            return super.getAllNetworkAdapters();
        }
        return Collections.unmodifiableList(adapters);
    }

    @Override
    public NetworkStats getNetworkUsage() {
        try {
            return new NetworkStats(this.sigar.getNetStat());
        }
        catch (SigarException e) {
            return super.getNetworkUsage();
        }
    }

    @Override
    public NetworkAdapterStats getNetworkAdapterStats(String interfaceName) {
        Preconditions.checkArgument((interfaceName != null ? 1 : 0) != 0);
        try {
            return new NetworkAdapterStats(this.sigar.getNetInterfaceStat(interfaceName));
        }
        catch (SigarException e) {
            return super.getNetworkAdapterStats(interfaceName);
        }
    }

    @Override
    public List<FileSystemInfo> getFileSystems() {
        ArrayList mountPoints = Lists.newArrayList();
        try {
            FileSystemMap map = this.sigar.getFileSystemMap();
            mountPoints.addAll(map.keySet());
        }
        catch (SigarException e) {
            return super.getFileSystems();
        }
        ArrayList infos = Lists.newArrayList();
        for (String mountPoint : mountPoints) {
            infos.add(this.getFileSystem(mountPoint));
        }
        return infos;
    }

    @Override
    public FileSystemInfo getFileSystem(String path) {
        FileSystemInfo info;
        try {
            FileSystem[] disks = this.sigar.getFileSystemList();
            String mountPoint = null;
            File file = new File(path);
            String absolutePath = file.getCanonicalPath();
            for (FileSystem each : disks) {
                if (!absolutePath.startsWith(each.getDirName()) || mountPoint != null && mountPoint.length() >= each.getDirName().length()) continue;
                mountPoint = each.getDirName();
            }
            if (mountPoint == null) {
                return super.getFileSystem(absolutePath);
            }
            info = new FileSystemInfo(mountPoint);
            FileSystemUsage usage = this.sigar.getMountedFileSystemUsage(mountPoint);
            info.setFree((Long)Amount.of((long)usage.getAvail(), (Unit)Data.KB).as((Unit)Data.BYTES));
            info.setUsed((Long)Amount.of((long)usage.getUsed(), (Unit)Data.KB).as((Unit)Data.BYTES));
            info.setTotal((Long)Amount.of((long)usage.getTotal(), (Unit)Data.KB).as((Unit)Data.BYTES));
            info.setReads(usage.getDiskReads());
            info.setWrites(usage.getDiskWrites());
            info.setReadBytes(usage.getDiskReadBytes());
            info.setWriteBytes(usage.getDiskWriteBytes());
        }
        catch (SigarException e) {
            if (!"The device is not ready".equals(e.getMessage())) {
                logger.debug("Unable to gather file system usage for mount point [" + path + "]", (Throwable)e);
            }
            info = super.getFileSystem(path);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return info;
    }
}

