/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.sysinfo;

import com.google.common.base.Throwables;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.CpuUsage;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.DiskUsage;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.FileSystemInfo;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.MemoryUsage;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.NetworkAdapterInfo;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.NetworkAdapterStats;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.NetworkStats;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SwapUsage;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SystemInfo;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.OsType;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.hyperic.sigar.CpuInfo;

public class JavaSystemInfo
implements SystemInfo {
    final OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public long getProcessId() {
        return -1L;
    }

    private static Object invokeMethod(String methodName, Object object) {
        Method method = ClassUtils.getMethodIfAvailable(object.getClass(), (String)methodName, (Class[])new Class[0]);
        if (method == null) {
            throw new UnsupportedOperationException("No method [" + methodName + "] found in class " + object.getClass());
        }
        boolean old = method.isAccessible();
        try {
            method.setAccessible(true);
            Object object2 = method.invoke(object, new Object[0]);
            return object2;
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
        finally {
            method.setAccessible(old);
        }
    }

    @Override
    public long getProcessCpuTime() {
        long nanos = (Long)JavaSystemInfo.invokeMethod("getProcessCpuTime", this.os);
        return TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public OsType getOsType() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return OsType.fromOsName((String)osName);
    }

    @Override
    public String getOsName() {
        return System.getProperty("os.name");
    }

    @Override
    public String getOsVersion() {
        return System.getProperty("os.version");
    }

    @Override
    public String getOsArch() {
        return System.getProperty("os.arch");
    }

    @Override
    public int getAvailableProcessors() {
        if (JavaSystemInfo.getJdkVersion() >= 1.6) {
            try {
                Method m = Runtime.class.getMethod("availableProcessors", new Class[0]);
                return (Integer)m.invoke((Object)Runtime.getRuntime(), new Object[0]);
            }
            catch (SecurityException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        throw new UnsupportedOperationException("Cannot get available processors");
    }

    @Override
    public String getNodeId() {
        return Grid.instance.getLocalNode().getAddress();
    }

    @Override
    public String getJvmName() {
        return System.getProperty("java.vm.name");
    }

    @Override
    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    @Override
    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    @Override
    public String getJavaHome() {
        return System.getProperty("java.home");
    }

    private static double parse(String version) {
        if (version == null || version.length() == 0) {
            return 0.0;
        }
        try {
            int fd = version.indexOf(46);
            int sd = version.indexOf(46, fd + 1);
            if (0 < sd) {
                version = version.substring(0, sd);
            }
            return Double.parseDouble(version);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static double getJdkVersion() {
        return JavaSystemInfo.parse(System.getProperty("java.version"));
    }

    @Override
    public MemoryUsage getMemoryUsage() {
        long total = (Long)JavaSystemInfo.invokeMethod("getTotalPhysicalMemorySize", this.os);
        long frees = (Long)JavaSystemInfo.invokeMethod("getFreePhysicalMemorySize", this.os);
        MemoryUsage mem = new MemoryUsage();
        mem.setTotal(total);
        mem.setFree(frees);
        mem.setUsed(total - frees);
        return mem;
    }

    @Override
    public SwapUsage getSwapUsage() {
        long totals = (Long)JavaSystemInfo.invokeMethod("getTotalSwapSpaceSize", this.os);
        long frees = (Long)JavaSystemInfo.invokeMethod("getFreeSwapSpaceSize", this.os);
        SwapUsage swap = new SwapUsage();
        swap.setTotal(totals);
        swap.setFree(frees);
        swap.setUsed(totals - frees);
        return swap;
    }

    @Override
    public DiskUsage getDiskUsage(File path) {
        if (JavaSystemInfo.getJdkVersion() >= 1.6) {
            File root = path;
            while (root.getParentFile() != null) {
                root = root.getParentFile();
            }
            DiskUsage disk = new DiskUsage(root.getAbsolutePath());
            disk.setTotal(root.getTotalSpace());
            disk.setFree(root.getUsableSpace());
            disk.setUsed(root.getTotalSpace() - root.getUsableSpace());
            return disk;
        }
        throw new UnsupportedOperationException("Cannot get disk info");
    }

    @Override
    public CpuInfo[] getCpuInfoList() {
        throw new UnsupportedOperationException("Cannot get cpu info");
    }

    @Override
    public CpuUsage getCpuUsage() {
        throw new UnsupportedOperationException("Cannot get cpu percentage");
    }

    @Override
    public NetworkStats getNetworkUsage() {
        throw new UnsupportedOperationException("Cannot get network usage");
    }

    @Override
    public List<NetworkAdapterInfo> getAllNetworkAdapters() {
        throw new UnsupportedOperationException("Cannot get network adapter info");
    }

    @Override
    public NetworkAdapterStats getNetworkAdapterStats(String name) {
        throw new UnsupportedOperationException("Cannot get stats for network interface [" + name + "]");
    }

    @Override
    public List<FileSystemInfo> getFileSystems() {
        return Collections.singletonList(this.getFileSystem(Bootstrap.installDir.getAbsolutePath()));
    }

    @Override
    public FileSystemInfo getFileSystem(String path) {
        File root = new File(path);
        while (root.getParentFile() != null) {
            root = root.getParentFile();
        }
        try {
            FileSystemInfo disk = new FileSystemInfo(root.getCanonicalPath());
            disk.setTotal(root.getTotalSpace());
            disk.setFree(root.getUsableSpace());
            disk.setUsed(root.getTotalSpace() - root.getFreeSpace());
            return disk;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

