/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.supplier;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.measurement.WebMeasurements;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementSupplier;
import com.pmease.quickbuild.plugin.measurement.core.meta.JettyMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.setting.PluginSetting;
import com.pmease.quickbuild.plugin.measurement.core.util.MeasurementDataBuilder;
import com.pmease.quickbuild.plugin.measurement.core.util.NodeId;
import com.yammer.metrics.core.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

class WebMetricsSupplier
implements MeasurementSupplier {
    private long previousUiRequests = -1L;
    private long previousRestRequests = -1L;
    private long previousRpcRequests = -1L;
    private long previousDownloadRequests = -1L;
    private long previousUploadRequests = -1L;
    final String nodeId;

    @Inject
    WebMetricsSupplier(@NodeId String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public String getId() {
        return "web";
    }

    @Override
    public String getName() {
        return "Web Server";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasurementData> get() {
        if (!Bootstrap.isServer()) {
            return Collections.emptyList();
        }
        if (!PluginSetting.get().isWebMeasurementsEnabled()) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        this.addData(list, "ui", WebMeasurements.INSTANCE.getUiTimer(), this.previousUiRequests);
        this.addData(list, "rest", WebMeasurements.INSTANCE.getRestTimer(), this.previousRestRequests);
        this.addData(list, "rpc", WebMeasurements.INSTANCE.getRpcTimer(), this.previousRpcRequests);
        this.addData(list, "download", WebMeasurements.INSTANCE.getDownloadTimer(), this.previousDownloadRequests);
        this.addData(list, "upload", WebMeasurements.INSTANCE.getUploadTimer(), this.previousUploadRequests);
        list.add(MeasurementDataBuilder.of(System.currentTimeMillis(), this.nodeId, JettyMetricGroup.USED_CONNECTIONS.getMetricName(), (Number)WebMeasurements.INSTANCE.getUsedHttpConnections().value()));
        list.add(MeasurementDataBuilder.of(System.currentTimeMillis(), this.nodeId, JettyMetricGroup.TOTAL_CONNECTIONS.getMetricName(), (Number)WebMeasurements.INSTANCE.getTotalHttpConnections().value()));
        this.previousUiRequests = WebMeasurements.INSTANCE.getUiTimer().count();
        this.previousRestRequests = WebMeasurements.INSTANCE.getRestTimer().count();
        this.previousDownloadRequests = WebMeasurements.INSTANCE.getDownloadTimer().count();
        this.previousRpcRequests = WebMeasurements.INSTANCE.getRpcTimer().count();
        this.previousUploadRequests = WebMeasurements.INSTANCE.getUploadTimer().count();
        ArrayList arrayList = list;
        return arrayList;
    }

    private void addData(List<MeasurementData> list, String name, Timer timer, long previous) {
        long timestamp = System.currentTimeMillis();
        list.add(MeasurementDataBuilder.of(timestamp, this.nodeId, "web." + name + ".oneMinuteRate", timer.oneMinuteRate()));
        list.add(MeasurementDataBuilder.of(timestamp, this.nodeId, "web." + name + ".fiveMinuteRate", timer.fiveMinuteRate()));
        list.add(MeasurementDataBuilder.of(timestamp, this.nodeId, "web." + name + ".fifteenMinuteRate", timer.fifteenMinuteRate()));
        if (previous >= 0L) {
            long count = timer.count();
            if ((count -= previous) < 0L) {
                count = 0L;
            }
            list.add(MeasurementDataBuilder.of(timestamp, this.nodeId, "web." + name + ".requests", count));
            list.add(MeasurementDataBuilder.of(timestamp, this.nodeId, "web." + name + ".averageDuration", timer.mean()));
        } else {
            list.add(MeasurementDataBuilder.of(timestamp, this.nodeId, "web." + name + ".requests", timer.count()));
            list.add(MeasurementDataBuilder.of(timestamp, this.nodeId, "web." + name + ".averageDuration", timer.mean()));
        }
    }
}

