/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.supplier;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.plugin.measurement.core.manager.MeasurementCompressionManager;
import com.pmease.quickbuild.plugin.measurement.core.meta.BuildRequestMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.BuildsMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.DiskMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricCategory;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricGroupEnum;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricType;
import com.pmease.quickbuild.plugin.measurement.core.meta.ResourceMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.StepMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.mock.GridMock;
import com.pmease.quickbuild.plugin.measurement.core.mock.ResourceMock;
import com.pmease.quickbuild.plugin.measurement.core.util.MeasurementDataBuilder;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.IntegerType;
import com.pmease.quickbuild.plugin.report.engine.datatype.LongType;
import com.pmease.quickbuild.plugin.report.engine.datatype.PercentType;
import com.pmease.quickbuild.util.TimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class TestDataGenerator {
    public static TestDataGenerator instance = (TestDataGenerator)Quickbuild.getInstance(TestDataGenerator.class);
    private final MeasurementDataManager dataManager;
    private final MeasurementCompressionManager compressionManager;
    private static final Set<String> PATHS = ImmutableSet.of((Object)"C:", (Object)"D:", (Object)"E:");
    private static Set<MetricCategory> disabled = ImmutableSet.of();
    Random rand = new Random();

    @Inject
    TestDataGenerator(MeasurementDataManager dataManager, MeasurementCompressionManager compressionManager) {
        this.dataManager = dataManager;
        this.compressionManager = compressionManager;
    }

    public void run() {
        this.dataManager.clearAll();
        long now = System.currentTimeMillis();
        long from = this.dataManager.getLastTimestamp(null);
        if (from == 0L) {
            long begin = TimeUtils.ago((long)now, (long)259200000L);
            while (begin < now) {
                long end = begin + 86400000L + (long)this.rand.nextInt(4000);
                this.generateData(begin, end);
                this.compressionManager.compressAndPurge(end);
                begin = end;
            }
        } else {
            from = from + (long)(new Random().nextDouble() * 1000.0) + this.dataManager.getPollingInterval();
            this.generateData(from, now);
            this.compressionManager.compressAndPurge();
        }
    }

    void generateData(long beginTime, long endTime) {
        List<GridNode> nodes = GridMock.getNodes();
        for (long start = beginTime; start < endTime; start += MeasurementDataManager.instance.getPollingInterval()) {
            Stopwatch watch = new Stopwatch().start();
            ArrayList measurements = Lists.newArrayList();
            measurements.addAll(this.generateNodeData(MetricType.SERVER, nodes.get(0).getAddress(), start));
            for (int i = 1; i < nodes.size(); ++i) {
                measurements.addAll(this.generateNodeData(MetricType.NODE, nodes.get(i).getAddress(), start));
            }
            measurements.addAll(this.generateSystemData(nodes.get(0).getAddress(), start));
            this.dataManager.save((List)measurements);
            System.out.println("Generating data [" + measurements.size() + "] rows at " + DataTypes.DATE.asString((Object)new Date(start), "yyyy-MM-dd HH:mm:ss") + " in " + watch.elapsed(TimeUnit.MILLISECONDS) + " millis");
        }
    }

    List<MeasurementData> generateNodeData(MetricType types, String nodeId, long timestamp) {
        ArrayList list = Lists.newArrayList();
        for (MetricCategory each : MetricMetaRegistry.instance.getCategories()) {
            if (each instanceof DiskMetricGroup || disabled.contains(each)) continue;
            list.addAll(this.generateGroupData(types, nodeId, timestamp, each));
        }
        for (MetricMeta meta : MetricGroupEnum.DISK.getMetricGroup().getMetas()) {
            for (String path : PATHS) {
                list.add(this.generateCommonData(nodeId, timestamp, meta, path));
            }
        }
        return list;
    }

    private List<MeasurementData> generateSystemData(String serverId, long timestamp) {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.generateResourceData(serverId, timestamp));
        list.addAll(this.generateBuildsData(serverId, timestamp));
        list.addAll(this.generateBuildRequestsData(serverId, timestamp));
        list.addAll(this.generateStepsData(serverId, timestamp));
        return list;
    }

    private List<MeasurementData> generateBuildsData(String serverId, long timestamp) {
        ArrayList list = Lists.newArrayList();
        long totals = this.rand.nextInt(10);
        if (totals <= 0L) {
            totals = 1L;
        }
        list.add(MeasurementDataBuilder.of(timestamp, serverId, BuildsMetricGroup.TOTALS.getMetricName(), totals));
        long failed = this.rand.nextInt((int)totals);
        if (failed > totals) {
            failed = totals;
        }
        list.add(MeasurementDataBuilder.of(timestamp, serverId, BuildsMetricGroup.FAILED.getMetricName(), failed));
        list.add(MeasurementDataBuilder.of(timestamp, serverId, BuildsMetricGroup.SUCCESSFUL_RATE.getMetricName(), (double)(totals - failed) / new Double(totals)));
        list.add(this.generateCommonData(serverId, timestamp, BuildsMetricGroup.AVERAGE_DURATION));
        list.add(this.generateCommonData(serverId, timestamp, BuildsMetricGroup.AVERAGE_WAITING_DURATION));
        return list;
    }

    private List<MeasurementData> generateBuildRequestsData(String serverId, long timestamp) {
        ArrayList list = Lists.newArrayList();
        list.add(MeasurementDataBuilder.of(timestamp, serverId, BuildRequestMetricGroup.PROCESSED_TOTAL.getMetricName(), this.rand.nextInt(10)));
        list.add(MeasurementDataBuilder.of(timestamp, serverId, BuildRequestMetricGroup.PROCESSINGS_TOTAL.getMetricName(), this.rand.nextInt(10)));
        return list;
    }

    private List<MeasurementData> generateStepsData(String serverId, long timestamp) {
        ArrayList list = Lists.newArrayList();
        list.add(MeasurementDataBuilder.of(timestamp, serverId, StepMetricGroup.RUNNINGS_TOTAL.getMetricName(), this.rand.nextInt(10000)));
        list.add(MeasurementDataBuilder.of(timestamp, serverId, StepMetricGroup.WAITINGS_TOTAL.getMetricName(), this.rand.nextInt(10000)));
        return list;
    }

    private List<MeasurementData> generateResourceData(String serverId, long timestamp) {
        ArrayList list = Lists.newArrayList();
        for (Resource res : ResourceMock.getResources()) {
            int used = this.rand.nextInt(100);
            int frees = res.getCount() - used;
            list.add(MeasurementDataBuilder.of(timestamp, serverId, MetricMeta.of(ResourceMetricGroup.USED_BY_NAME, res.getName()).getMetricName(), used));
            list.add(MeasurementDataBuilder.of(timestamp, serverId, MetricMeta.of(ResourceMetricGroup.FREES_BY_NAME, res.getName()).getMetricName(), frees));
        }
        return list;
    }

    private Number generateValue(MetricMeta meta) {
        Number value = meta.getDataType() instanceof LongType ? (Number)this.rand.nextInt(10000) : (Number)(meta.getDataType() instanceof IntegerType ? (Number)this.rand.nextInt(10000) : (Number)(meta.getDataType() instanceof PercentType ? Double.valueOf(this.rand.nextDouble()) : Double.valueOf(this.rand.nextDouble() * 1000.0)));
        return value;
    }

    List<MeasurementData> generateGroupData(MetricType type, String source, long timestamp, MetricCategory group) {
        ArrayList list = Lists.newArrayList();
        for (MetricMeta each : group.getMetas()) {
            if (!type.includes(each.getMetricType())) continue;
            list.add(this.generateCommonData(source, timestamp, each));
        }
        return list;
    }

    MeasurementData generateCommonData(String nodeId, long timestamp, MetricMeta meta, String scope) {
        return MeasurementDataBuilder.of(timestamp, nodeId, MetricMeta.of(meta, scope).getMetricName(), this.generateValue(meta));
    }

    MeasurementData generateCommonData(String nodeId, long timestamp, MetricMeta meta) {
        return MeasurementDataBuilder.of(timestamp, nodeId, meta.getMetricName(), this.generateValue(meta));
    }
}

